# WP Block Generator CLI

A custom WP-CLI command to generate WordPress blocks with predefined templates, making block development easier and faster.


```
                                     .__        __
__  _  _______  ___.__.______   ____ |__| _____/  |_
\ \/ \/ /\__  \<   |  |\____ \ /  _ \|  |/    \   __\
 \     /  / __ \\___  ||  |_> >  <_> )  |   |  \  |
  \/\_/  (____  / ____||   __/ \____/|__|___|  /__|
              \/\/     |__|                  \/



a statenweb joint


```

## Installation

To use the WP Block Generator, install it via Composer:

```sh
composer require statenweb/wp-block-generator
```

### Composer Local Path Installation (for development purposes)

If you're working on the generator locally, you can add it to your project via Composer with a local path:

```json
{
  "require": {
    "statenweb/wp-block-generator": "*"
  },
  "repositories": [
    {
      "type": "path",
      "url": "../path-to-local-wp-block-generator"
    }
  ]
}
```

Then run:

```sh
composer update statenweb/wp-block-generator
```

---

## Usage

Once installed, you can use the WP-CLI command to generate blocks in your WordPress theme.

### Generating a New Block

To generate a block, run the following command from the root of your WordPress installation:

```sh
wp blockgen generate "My Custom Block"
```

**Example:**

```sh
wp blockgen generate "Hero Section"
```

This will create:

1. A block template file inside your theme:
    - `wp-content/themes/your-theme/theme/block/hero-section.php`

2. A block definition class inside your theme:
    - `wp-content/themes/your-theme/theme/Victoria/Blocks/Hero_Section.php`

3. Updates the `Blocks_Provider.php` file to register the new block.

---

## Generated Files Structure

After running the command, your project structure will look like this:

```
wp-content/themes/your-theme/theme/
│-- block/
│   └── hero-section.php
│-- Victoria/
│   └── Blocks/
│       └── Hero_Section.php
│   └── Providers/
│       └── Blocks_Provider.php (auto-updated)
```

---

## Block Naming Conventions

- Input block names should use spaces, not hyphens or underscores.
- The generator will automatically format them correctly.

**Examples:**

| Input Name             | Generated `BLOCK_NAME` Constant |
|------------------------|---------------------------------|
| `hero-section`          | `Hero Section`                 |
| `hero_section`          | `Hero Section`                 |
| `Hero_Section_Block`    | `Hero Section Block`            |

---

## Updating the Blocks Provider

Every time a block is generated, the `Blocks_Provider.php` file is updated by:

- Adding a `use` statement for the new block (after the last existing `use` statement).
- Adding the block to the `$items` array in the correct order without duplicates.

---

## Uninstalling

To remove the WP Block Generator from your project, run:

```sh
composer remove statenweb/wp-block-generator
```

---

## Troubleshooting

If the command is not recognized, try:

1. **Ensure Composer's autoload is updated:**

   ```sh
   composer dump-autoload
   ```

2. **Verify WP-CLI command registration:**

   ```sh
   wp help blockgen
   ```

3. **Check for syntax errors in Blocks_Provider.php file:**

   ```sh
   nano wp-content/themes/your-theme/theme/Victoria/Providers/Blocks_Provider.php
   ```

---

## Development and Contributions

If you'd like to contribute or customize the generator:

1. Clone the repository:

   ```sh
   git clone https://github.com/your-repo/wp-block-generator.git
   ```

2. Install dependencies:

   ```sh
   composer install
   ```

3. Run locally in your WordPress project:

   Add the local repository in your project's `composer.json`:

   ```json
   {
     "repositories": [
       {
         "type": "path",
         "url": "../wp-block-generator"
       }
     ]
   }
   ```

   Then run:

   ```sh
   composer require statenweb/wp-block-generator --dev
   ```

4. Create a feature branch:

   ```sh
   git checkout -b feature/my-feature
   ```

5. Submit a pull request after testing.
