# Victoria Package for StatenWeb Starter Theme

```
                                     .__        __
__  _  _______  ___.__.______   ____ |__| _____/  |_
\ \/ \/ /\__  \<   |  |\____ \ /  _ \|  |/    \   __\
 \     /  / __ \\___  ||  |_> >  <_> )  |   |  \  |
  \/\_/  (____  / ____||   __/ \____/|__|___|  /__|
              \/\/     |__|                  \/



a statenweb joint


```

The `Victoria` package is a reusable component designed for integration with a StatenWeb starter theme. This package is distributed via Composer and needs to be placed in the correct theme directory for usage.

A WP-CLI command is provided as a helper to move the package from the `vendor` directory to the appropriate location inside the starter theme.

## 📂 Directory Structure

```
root_dir/
│── web/
│   ├── wp-content/
│   │   ├── themes/
│   │   │   ├── starter-2024/ (renamed per project)
│   │   │   │   ├── theme/
│   │   │   │   │   ├── Victoria/  ← 📌 Package destination
│── vendor/
│   ├── statenweb/
│   │   ├── files/
│   │   │   ├── victoria/  ← 📌 Package source
```

## 🚀 Installation

1. Clone the `starter-2024` theme:
   ```bash
   git clone https://github.com/statenweb/starter-2024
   ```

2. Install the `Victoria` package using Composer:
   ```bash
   composer require statenweb/victoria
   ```

3. Move the Package to the Correct Location

## 🛠️ Moving the Package to the Correct Location

### Using WP-CLI (Recommended)
A WP-CLI command is provided to move the package to the correct theme directory.

#### Move the `Victoria` package (Interactive Mode)
```bash
wp victoria publish
```
- This will prompt before overwriting any existing files.

#### Move and Overwrite All Files
```bash
wp victoria publish --overwrite-all
```
- This will overwrite all files without asking for confirmation.

## 📝 Notes

- The first theme found in `wp-content/themes/` is used.
- If `theme/` directory does not exist, it will be created.
- If `Victoria` package is missing in `vendor`, an error will be displayed.