<?php

namespace StatenWeb\Generators;

use StatenWeb\Abstracts\Generator;

class Hook_Generator extends Generator {
	protected function get_asset_files() {
		return [
			[
				'file_path' => "{$this->theme_path}/Victoria/{$this->get_assets_directory_name()}/{$this->asset_class}.php",
				'stub_file' => 'hook-definition.stub',
				'replace' => [
					'HOOK_CLASS' => $this->asset_class,
				]
			]
		];
	}

	protected function get_provider_class_name() {
		return 'Hooks_Provider';
	}

	protected function get_assets_directory_name() {
		return 'Hooks';
	}
}