<?php

namespace StatenWeb\Commands;

use WP_CLI_Command;

class Sw_Generator_Blocks_List extends WP_CLI_Command {
	/**
	 * List available API blocks. Optionally pick one interactively to scaffold.
	 *
	 * ## OPTIONS
	 * [--interactive]
	 * : Show a picker and generate the selected block.
	 *
	 * ## EXAMPLES
	 *   wp sw-generator blocks-list
	 *   wp sw-generator blocks-list --interactive
	 *
	 * @when after_wp_load
	 */
	public function __invoke( $args, $assoc_args ) {
		( new Sw_Generator() )->blocks_list( $args, $assoc_args );
	}
}
