<?php

namespace StatenWeb\Generators;

use StatenWeb\Abstracts\Generator;

class Sidebar_Generator extends Generator {
	protected function get_asset_files() {
		return [
			[
				'file_path' => "{$this->theme_path}/Victoria/{$this->get_assets_directory_name()}/{$this->asset_class}.php",
				'stub_file' => 'sidebar-definition.stub',
				'replace' => [
					'SIDEBAR_CLASS' => $this->asset_class,
					'SIDEBAR_SLUG' => $this->asset_slug,
					'SIDEBAR_NAME' => $this->asset_name,
				]
			]
		];
	}

	protected function get_provider_class_name() {
		return 'Sidebars_Provider';
	}

	protected function get_assets_directory_name() {
		return 'Sidebars';
	}
}