<?php

namespace StatenWeb\Generators;

use StatenWeb\Abstracts\Generator;

class Shortcode_Generator extends Generator {
	protected function get_asset_files() {
		return [
			[
				'file_path' => "{$this->theme_path}/Victoria/{$this->get_assets_directory_name()}/{$this->asset_class}.php",
				'stub_file' => 'shortcode-definition.stub',
				'replace' => [
					'SHORTCODE_CLASS' => $this->asset_class,
					'SHORTCODE_SLUG' => $this->asset_slug,
				]
			]
		];
	}

	protected function get_provider_class_name() {
		return 'Shortcodes_Provider';
	}

	protected function get_assets_directory_name() {
		return 'Shortcodes';
	}
}