# WP Assets Generator CLI

A custom WP-CLI command to generate StatenWeb's starter theme assets (from Vitoria package) with predefined templates, making development easier and faster.


```
                                     .__        __
__  _  _______  ___.__.______   ____ |__| _____/  |_
\ \/ \/ /\__  \<   |  |\____ \ /  _ \|  |/    \   __\
 \     /  / __ \\___  ||  |_> >  <_> )  |   |  \  |
  \/\_/  (____  / ____||   __/ \____/|__|___|  /__|
              \/\/     |__|                  \/



a statenweb joint


```

## Installation

To use the SW Generator, install it via Composer:

```sh
composer require statenweb/sw-generator
```

### Composer Local Path Installation (for development purposes)

If you're working on the generator locally, you can add it to your project via Composer with a local path:

```json
{
  "require": {
    "statenweb/sw-generator": "*"
  },
  "repositories": [
    {
      "type": "path",
      "url": "../path-to-local-sw-generator"
    }
  ]
}
```

Then run:

```sh
composer update statenweb/sw-generator
```

---

## Usage

Once installed, you can use the WP-CLI command to generate assets in your WordPress theme.

### Generating a New Asset

To generate an asset, run the following command from the root of your WordPress installation:

```sh
wp sw-generator generate <asset> "<Asset Name>"
```

**Available assets:**

```sh
wp sw-generator generate block "My Custom Block"
wp sw-generator generate cpt "My Custom Cpt"
wp sw-generator generate enqueue "My Custom Enqueue"
wp sw-generator generate hook "My Custom Hook"
wp sw-generator generate provider "My Custom Provider"
wp sw-generator generate shortcode "My Custom Shortcode"
wp sw-generator generate sidebar "My Custom Sidebar"
```

**Example:**

```sh
wp sw-generator generate cpt "My Custom Cpt"
```

This will create:

1. An asset definition class inside your theme:
    - `wp-content/themes/your-theme/theme/Victoria/Post_Types/My_Custom_Cpt.php`

2. Updates the `Cpts_Provider.php` file to register the new custom post type.

---

## Generated Files Structure

After running the command, your project structure will look like this:

```
wp-content/themes/your-theme/theme/
│-- Victoria/
│   └── Post_Types/
│       └── My_Custom_Cpt.php
│   └── Providers/
│       └── Cpts_Provider.php (auto-updated)
```

---

## Assets Naming Conventions

- Input assets names should use spaces, not hyphens or underscores.
- The generator will automatically format them correctly.

**Examples:**

| Input Name             | Generated `BLOCK_NAME` Constant |
|------------------------|---------------------------------|
| `hero-section`          | `Hero Section`                 |
| `hero_section`          | `Hero Section`                 |
| `Hero_Section_Block`    | `Hero Section Block`            |

---

## Updating the Assets Provider

Every time an asset is generated, the respective provider file is updated by:

- Adding a `use` statement for the new asset (after the last existing `use` statement).
- Adding the asset to the `$items` array in the correct order without duplicates.

---

## Uninstalling

To remove the SW Generator from your project, run:

```sh
composer remove statenweb/sw-generator
```
