<?php

namespace StatenWeb\Generators;

use StatenWeb\Abstracts\Generator;

class Cpt_Generator extends Generator {
	protected function get_asset_files() {
		return [
			[
				'file_path' => "{$this->theme_path}/Victoria/{$this->get_assets_directory_name()}/{$this->asset_class}.php",
				'stub_file' => 'cpt-definition.stub',
				'replace' => [
					'CPT_CLASS' => $this->asset_class,
					'CPT_SLUG' => $this->asset_slug,
					'CPT_NAME' => $this->asset_name,
				]
			]
		];
	}

	protected function get_provider_class_name() {
		return 'Cpts_Provider';
	}

	protected function get_assets_directory_name() {
		return 'Post_Types';
	}
}