<?php

namespace StatenWeb\Generators;

use StatenWeb\Abstracts\Generator;
use WP_CLI;

class Block_Generator extends Generator {
	public function __invoke( $asset_name ) {
		// Ensure Utils method exists before generating block
		$this->theme_path = $this->get_theme_path();
		$this->ensure_utils_gff_method_exists();

		// Call parent implementation
		return parent::__invoke( $asset_name );
	}

	protected function get_asset_files() {
		return [
			[
				'file_path' => "{$this->theme_path}/block/{$this->asset_slug}.php",
				'stub_file' => 'block-template.stub',
				'replace' => [
					'BLOCK_NAME' => $this->asset_name,
					'BLOCK_SLUG' => $this->asset_slug,
				]
			],
			[
				'file_path' => "{$this->theme_path}/Victoria/{$this->get_assets_directory_name()}/{$this->asset_class}.php",
				'stub_file' => 'block-definition.stub',
				'replace' => [
					'BLOCK_CLASS' => $this->asset_class,
					'BLOCK_SLUG' => $this->asset_slug,
					'BLOCK_NAME' => $this->asset_name,
				]
			]
		];
	}

	protected function get_provider_class_name() {
		return 'Blocks_Provider';
	}

	protected function get_assets_directory_name() {
		return 'Blocks';
	}
}
