# WP Assets Generator CLI

A custom WP-CLI command to generate StatenWeb's starter theme assets (from the **Victoria** package) with predefined templates or directly from an API of concrete blocks.

```
                                     .__        __
__  _  _______  ___.__.______   ____ |__| _____/  |_
\ \/ \/ /\__  \<   |  |\____ \ /  _ \|  |/    \   __\
 \     /  / __ \\___  ||  |_> >  <_> )  |   |  \  |
  \/\_/  (____  / ____||   __/ \____/|__|___|  /__|
              \/\/     |__|                  \/



a statenweb joint
```

---

## Installation

Install via Composer:

```sh
composer require statenweb/sw-generator
```

### Local Path Installation (for development)

```json
{
  "require": {
    "statenweb/sw-generator": "*"
  },
  "repositories": [
    {
      "type": "path",
      "url": "../path-to-local-sw-generator"
    }
  ]
}
```

Then:

```sh
composer update statenweb/sw-generator
```

---

## Environment (.env)

When generating **API-powered blocks**, the generator reads credentials strictly from environment variables (`.env`).

```
SW_GENERATOR_API_URL="https://your-api-host.tld"
SW_GENERATOR_API_TOKEN="supersecret"
# Optional: control SSL verification (local dev convenience)
WP_ENV=development
```

> In non-production (`WP_ENV != production`) the generator disables SSL verification to make local dev with self‑signed certs easier. In production, SSL is verified.

---

## Commands Overview

- `wp sw-generator generate <asset> "<Asset Name>"` — Generate any supported asset.
- `wp sw-generator blocks-list` — List available API blocks.
- `wp sw-generator blocks-list --interactive` — Pick an API block interactively and scaffold it.

**Available assets:**

```sh
wp sw-generator generate block "My Custom Block"
wp sw-generator generate cpt "My Custom Cpt"
wp sw-generator generate enqueue "My Custom Enqueue"
wp sw-generator generate hook "My Custom Hook"
wp sw-generator generate provider "My Custom Provider"
wp sw-generator generate shortcode "My Custom Shortcode"
wp sw-generator generate sidebar "My Custom Sidebar"
```
---

## Blocks - Workflow 1: Local Stub Blocks (no API)

Generate a block using local stubs (the original behavior).

```sh
wp sw-generator generate block "My Local Block"
```

This will create:

- **View**: `theme/block/my-local-block.php`
- **Definition**: `theme/Victoria/Blocks/My_Local_Block.php`
- **Provider**: updates `theme/Victoria/Providers/Blocks_Provider.php`

> Name processing:
> - Input `"My Local Block"` → class `My_Local_Block`, slug `my-local-block`, constant `BLOCK_NAME = 'My Local Block'`.

---

## Blocks - Workflow 2: API-Powered Concrete Blocks

Generate a **concrete** block by pulling full code from an API.

### A) List available API blocks

```sh
wp sw-generator blocks-list
```

Sample output:

```
+--------------+-------------+
| slug         | name        |
+--------------+-------------|
| cards        | Cards       |
| faq          | FAQ         |
| hero         | SW Hero     |
+--------------+-------------|
```

### B) Pick an API block interactively

```sh
wp sw-generator blocks-list --interactive
```

- Shows a picker.
- Uses the **API-provided name** of the chosen block for class/file/constant names.

Example flow:

```
Select a block to generate:
  [1] cards
  [2] faq
  [3] hero
Enter number [1]: 2

Generating 'FAQ' from API (slug: faq)...
File created: block/faq.php
File created: Victoria/Blocks/FAQ.php
Synced: Victoria/Abstracts/Fields_Builder.php
Skipped (exists): Victoria/Fields/FieldsBuilder.php
Blocks_Provider.php updated with: FAQ
Success: API block 'FAQ' created successfully!
```

### C) Generate a specific API block by slug

```sh
wp sw-generator generate block "Custom Cards" --type=cards
```

- `"Custom Cards"` (quoted name) is authoritative:
    - **Class** → `Custom_Cards`
    - **File names** → `block/custom-cards.php` and `Victoria/Blocks/Custom_Cards.php`
    - **Constants** → `BLOCK_SLUG = 'custom-cards'`, `BLOCK_NAME = 'Custom Cards'`
- `--type=cards` selects the source block from API.

> If `--type` is omitted (and `--pick` not used), a **stub block** is generated (Workflow 1).

### D) Force overwrite

```sh
wp sw-generator generate block "Cards" --type=cards --force
```

- Overwrites existing block files if present.
- **Does not** overwrite `Victoria/Fields/FieldsBuilder.php` (see below).

---

## What Gets Generated (API blocks)

Given a block named `"Cards"` and `--type=cards`:

```
wp-content/themes/your-theme/theme/
│-- block/
│   └── cards.php
│-- Victoria/
│   └── Blocks/
│       └── Cards.php
│   └── Abstracts/
│       └── Fields_Builder.php   ← synced from API
│   └── Fields/
│       └── FieldsBuilder.php    ← created if missing (never overwritten)
│   └── Providers/
│       └── Blocks_Provider.php  ← auto-updated
```

### Shared Victoria files behavior

- **`Victoria/Abstracts/Fields_Builder.php`**
    - If missing → created
    - If exists and content differs → overwritten
    - If exists and identical → skipped (up‑to‑date)

- **`Victoria/Fields/FieldsBuilder.php`**
    - If missing → created
    - If exists → **never** overwritten

> These two files are delivered as part of the `/wp-json/sw/v1/blocks/{slug}` payload by the API site.

---

## Naming & Rewriting Rules (API)

When generating from API, the quoted name you pass controls the final identifiers:

- Class: **renamed** to match your quoted name (e.g., `Cards` or `FAQ`).
- Slug: **renamed** to kebab-case of your quoted name (e.g., `cards`, `f-a-q`).
- Constants inside the definition file are updated:
    - `const BLOCK_SLUG = '...'` → new slug
    - `const BLOCK_NAME = '...'` → new human name
- Render template path is updated:
    - `'render_template' => 'block/{slug}.php'`

Non-text assets (images, etc.) are copied and their path is adjusted if it includes class/slug names.

---

## Providers Auto-Update

Whenever an asset is generated:

- The respective provider file is updated by:
    - Appending a `use Victoria\{Assets}\{Class};` statement (if missing).
    - Adding `{Class}::class` to the `$items` array (without duplicates).
- Formatting is preserved, and blank lines are normalized.

---

## Full Command Reference

### Generate

```sh
wp sw-generator generate <asset> "<Asset Name>" [--type=<slug>] [--pick] [--force]
```

- `<asset>`: `block`, `cpt`, `enqueue`, `hook`, `provider`, `shortcode`, `sidebar`
- `--type=<slug>` (blocks only): scaffold a **concrete** API block
- `--pick` (blocks only): show interactive picker of API blocks (uses the selected block’s API name)
- `--force`: overwrite block files when using `--type`

### List API Blocks

```sh
wp sw-generator blocks-list [--interactive]
```

- `--interactive`: pick a block and scaffold it using the API’s **name**

---

## Uninstalling

```sh
composer remove statenweb/sw-generator
```

---

## Troubleshooting

- **SSL on local dev**: If you use self‑signed certs, make sure `WP_ENV != production`. The generator disables SSL verification in that case.
- **Missing API URL**: Ensure `.env` contains `SW_GENERATOR_API_URL` and (optionally) `SW_GENERATOR_API_TOKEN`.
- **Permalinks**: If API routes 404, **visit Settings → Permalinks** and save to flush rewrite rules.
