# Victoria Package Entities Export

A custom WP-CLI command to export classes, traits, and interfaces from the Victoria package, including their dependencies, into a zip file.

```
                                     .__        __
__  _  _______  ___.__.______   ____ |__| _____/  |_
\ \/ \/ /\__  \<   |  |\____ \ /  _ \|  |/    \   __\
 \     /  / __ \\___  ||  |_> >  <_> )  |   |  \  |
  \/\_/  (____  / ____||   __/ \____/|__|___|  /__|
              \/\/     |__|                  \/


A statenweb joint
```

## Installation

To use the Victoria Export CLI, install it via Composer:

```sh
composer require statenweb/sw-exporter
```

### Composer Local Path Installation (for development purposes)

If you're working on the generator locally, you can add it to your project via Composer with a local path:

```json
{
  "require": {
    "statenweb/sw-exporter": "*"
  },
  "repositories": [
    {
      "type": "path",
      "url": "../path-to-local-sw-exporter"
    }
  ]
}
```

Then run:

```sh
composer update statenweb/sw-exporter
```

---

## Usage

Once installed, you can use the WP-CLI command to export entities from your Victoria package.

### Exporting an Entity

To export a class, trait, or interface, run the following command from the root of your WordPress installation:

```sh
wp sw-exporter export <entity>
```

**Example:**

```sh
wp sw-exporter export Hero
```

This will:

1. Find `Hero.php` inside the `Victoria` directory.
2. Collect its dependencies (parent classes, interfaces, traits, and related classes).
3. Create a zip archive containing all necessary files inside:
    - `wp-content/themes/your-theme/theme/Victoria/exports/Hero.zip`

---

## Exported Files Structure

After running the command, the exported files will be structured as follows:

```
wp-content/themes/your-theme/theme/Victoria/exports/
│-- Hero.zip
```

Inside the zip file, all required files will be included to fully support the exported entity.