<?php
/**
 * Plugin Name: SW Blocks API
 * Description: Exposes endpoints to list and fetch Victoria blocks (definition + view) from the active theme.
 * Version:     1.0.2
 * Author:      StatenWeb
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require_once __DIR__ . '/inc/class-sw-blocks-api.php';

add_action( 'rest_api_init', function () {
	$api = new \SW\Blocks_API();

	register_rest_route(
		'sw/v1',
		'/blocks',
		[
			'methods'             => WP_REST_Server::READABLE,
			'callback'            => [ $api, 'list_blocks' ],
			'permission_callback' => [ $api, 'permission' ],
		]
	);

	register_rest_route(
		'sw/v1',
		'/blocks/(?P<slug>[a-z0-9\-]+)',
		[
			'methods'             => WP_REST_Server::READABLE,
			'callback'            => [ $api, 'get_block' ],
			'permission_callback' => [ $api, 'permission' ],
			'args'                => [
				'slug' => [
					'required'          => true,
					'validate_callback' => function ( $param ) {
						return (bool) preg_match( '/^[a-z0-9\-]+$/', $param );
					},
				],
			],
		]
	);
} );

// Optional permissive CORS for GET.
add_action( 'rest_api_init', function () {
	add_filter( 'rest_pre_serve_request', function ( $served, $result, $request, $server ) {
		$route = $request->get_route();
		if ( strpos( $route, '/sw/v1/blocks' ) !== false ) {
			header( 'Access-Control-Allow-Origin: *' );
			header( 'Vary: Origin', false );
		}
		return $served;
	}, 10, 4 );
} );
