# SW Blocks API

A WordPress plugin that exposes **block definitions and supporting files** (templates, PHP classes, assets, and shared field builders) via a REST API.  
Use this together with the [`statenweb/sw-generator`](https://packagist.org/packages/statenweb/sw-generator) WP‑CLI package to pull blocks into another site’s theme.

---

## Requirements

- WordPress 6+
- PHP 8.1+
- ACF Pro (blocks are registered via ACF)
- Your theme follows this structure (Bedrock-style):
  - `wp-content/themes/<theme>/theme/…`
  - Block class files in `theme/Victoria/Blocks`
  - Block render templates in `theme/block`

> The plugin uses the **active (child) theme** directory via `get_stylesheet_directory()` and then appends `/theme`.

---

## Installation

Place the plugin into your WordPress `plugins` directory and activate it.

```sh
wp plugin activate sw-blocks-api
```

---

## Configuration (.env)

On the **API site** (the site serving blocks), set a token in your `.env` file:

```dotenv
# Required: bearer token checked by the API
SW_GENERATOR_API_TOKEN="your_super_secret_token"
```

- All API requests must include the header:  
  `Authorization: Bearer your_super_secret_token`

> No URL config is needed on the **API** site. URL configuration is for the **client** site (see below).

### (Client site) Environment vars for the generator

On the **client** site that will download blocks, add to its `.env`:

```dotenv
# Base URL of the API site (domain only; the generator appends /wp-json/sw/v1/...)
SW_GENERATOR_API_URL="https://your-api-site.tld"

# Same token as set on the API site
SW_GENERATOR_API_TOKEN="your_super_secret_token"

# Optional: local dev convenience (the generator disables SSL verification unless WP_ENV=production)
WP_ENV="development"
```

---

## Verify the API

From your machine (replace domain and token):

```sh
curl -i -H "Authorization: Bearer your_super_secret_token"   https://your-api-site.tld/wp-json/sw/v1/blocks
```

If you get **401 Unauthorized**, check the token in the API site’s `.env`.  
If you get **404**, flush permalinks: **WP Admin → Settings → Permalinks → Save**.

---

## REST API Endpoints

> Namespace: `sw/v1`

### 1) List blocks

```
GET /wp-json/sw/v1/blocks
```

**Response example:**
```json
[
  { "slug": "faq", "name": "FAQ", "class": "FAQ" },
  { "slug": "hero", "name": "Hero", "class": "Hero" }
]
```

### 2) Get block by slug

```
GET /wp-json/sw/v1/blocks/{slug}
```

**Response includes:**

- `block/{slug}.php` (render template)
- `Victoria/Blocks/{Class}.php` (block class)
- Optional assets discovered from the block’s `enqueue_assets` closure:
  - e.g. `block-js/{slug}.js`, `assets/css/{slug}/{slug}-theme.css`, or any path referenced via:
    - `get_template_directory_uri()` / `get_stylesheet_directory_uri()`
    - `get_theme_file_uri('path')`
    - `trailingslashit( get_*_directory() ) . 'path'`
- Shared files (included on every response):
  - `Victoria/Abstracts/Fields_Builder.php` (always synced/overwritten if different)
  - `Victoria/Fields/FieldsBuilder.php` (only created if missing on client)

---

## Typical Workflow

1. **API site**
   - Activate **SW Blocks API**.
   - Ensure blocks live in:
     - `theme/Victoria/Blocks/<BlockClass>.php`
     - `theme/block/<slug>.php`
   - (Optional) Enqueue assets in the block’s `get_block_definition()['enqueue_assets']` closure.

2. **Client site**
   - Install `statenweb/sw-generator` via Composer.
   - Add env vars (`SW_GENERATOR_API_URL`, `SW_GENERATOR_API_TOKEN`).
   - Discover and pull blocks:
     ```sh
     wp sw-generator blocks-list
     wp sw-generator blocks-list --interactive
     wp sw-generator generate block "Hero" --type=hero
     ```

---

## Troubleshooting

- **404 on API routes**  
  Go to **Settings → Permalinks** and click **Save** to flush rewrite rules.

- **401 Unauthorized**  
  Missing or wrong `Authorization: Bearer ...` token. Verify `SW_GENERATOR_API_TOKEN` on the API site and the client’s token value.

- **SSL / cURL 60 errors (local dev)**  
  Use a trusted cert on the API site, or ensure the client site runs with `WP_ENV` not equal to `production`
  so the generator will skip cert verification during development.

- **Assets not included**  
  Ensure the files referenced in `enqueue_assets` actually exist in the theme. The API only adds files present on disk.
