<?php

if ( ! function_exists( 'SW' ) ) {
	function SW() {
		return new Facet_Wp_Remote_Data_Handler();
	}
}

if ( ! function_exists( 'sw_get_remote_site_properties' ) ) {
	function sw_get_remote_site_properties( $post_ids ) {
		$transient_key = Facet_Wp_Remote_Data_Cache::property_posts_remote_site_data( $post_ids );

		$skip_cache = apply_filters( 'facetwp_remote_data_skip_cache', false );

		$properties = ! $skip_cache
			? Facet_Wp_Remote_Data_Cache::get( $transient_key )
			: false;

		if ( false === $properties ) {
			$properties = SW()->get_remote_site_posts( $post_ids );

			if ( is_wp_error( $properties ) ) {
				return [];
			}

			if ( ! empty( $properties ) ) {
				Facet_Wp_Remote_Data_Cache::set( $transient_key, $properties );
			}
		}

		return ! empty( $properties ) ? $properties : [];
	}
}

if ( ! function_exists( 'sw_get_remote_site_property' ) ) {
	function sw_get_remote_site_property( $post_id ) {
		$transient_key = Facet_Wp_Remote_Data_Cache::property_remote_site_data( $post_id );

		$skip_cache = apply_filters( 'facetwp_remote_data_skip_cache', false );

		$post_remote_data = ! $skip_cache
			? Facet_Wp_Remote_Data_Cache::get( $transient_key )
			: false;

		if ( false === $post_remote_data ) {
			$post_remote_data = SW()->get_property_remote_site_data( $post_id );

			if ( ! $post_remote_data ) return null;

			Facet_Wp_Remote_Data_Cache::set( $transient_key, $post_remote_data );
		}

		return $post_remote_data ?: null;
	}
}