<?php
/**
 * Template for displaying single FacetWP result.
 *
 * This template can be overridden by copying it to yourtheme/facet-wp-remote-data/facet-wp-remote-data-property-template.php.
 *
 * Available variables:
 * - $properties_data: Array of property data.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! empty( $property_data ) ) {
	[
		'property_id' => $property_id,
		'property_template_tags' => $property_template_tags,
		'property_calculator_data' => $property_calculator_data,
	] = $property_data;

	[
		'property' => $property,
		'featured_image' => $featured_image,
		'additional_images' => $additional_images,
		'first_4_images' => $first_4_images,
		'class' => $class,
		'image_counter' => $image_counter,
		'price_string' => $price_string,

		'header_data' => $header_data,
		'data_sections' => $data_sections,
	] = $property_template_tags;

	[
		'default_down_payment_percentage' => $default_down_payment_percentage,
		'default_interest_rate' => $default_interest_rate,
		'default_down_payment' => $default_down_payment,
		'default_length_of_mortgage' => $default_length_of_mortgage,
	] = $property_calculator_data;
}

get_header();

if ( ! empty( $property_data ) ) : ?>
    <main id="primary">
        <section id="main">
            <section class="grid laptop:grid-cols-3 desktop:grid-cols-2 border-2 border-white">
                <div class="col-span-2 desktop:col-span-1">
                    <div class="laptop:max-h-[600px] desktop:max-h-[700px]">
						<?php if ( ! empty( $featured_image ) ) : ?>
                            <img src="<?php echo esc_url( $featured_image ); ?>"
                                 alt="<?php echo esc_attr( $property['address'] ); ?>"
                                 class="w-full max-h-full object-cover">
						<?php endif; ?>
                    </div>
                </div>
                <div class="grid <?php echo esc_attr( $class ); ?>">
					<?php
					foreach ( $first_4_images as $image ) :
						$image_counter++;
						?>
                        <div class="hidden laptop:max-h-[300px] desktop:max-h-[350px] <?php echo $image_counter > 2 ? 'desktop:block ' : ' laptop:block'; ?>">
							<?php if ( ! empty( $image ) ) : ?>
                                <img src="<?php echo esc_url( $image ); ?>"
                                     alt="<?php echo esc_attr( $property['address'] ); ?>"
                                     class="w-full max-h-full object-cover">
							<?php endif; ?>
                        </div>
					<?php endforeach; ?>
                </div>
            </section>
            <section class="py-[3rem] bg-off-black text-white">
                <div class=" flex container flex-wrap laptop:flex-nowrap">
                    <div class="w-full laptop:min-w-[50%] flex flex-col gap-3 grow-[2]">
                        <h1 class="text-[2.125rem] leading-[130%] "><?php echo esc_html( $property['address'] ); ?></h1>
                        <p class="text-[1.5rem] "><?php echo esc_html( $price_string ); ?></p>

                    </div>
                    <div class="grow-[1] flex flex-row laptop:text-right py-5 laptop:py-0 gap-10">

						<?php foreach ( (array) $header_data as ['label' => $label, 'content' => $content] ) : ?>
                            <div>
                                <p class="whitespace-nowrap text-[2rem] laptop:text-[2.125]"><?php echo esc_html( $content ); ?></p>
                                <p class="whitespace-nowrap text-[1rem]"><?php echo esc_html( $label ); ?></p>
                            </div>
						<?php endforeach; ?>


                    </div>


                </div>
            </section>
            <section class="py-[1.5rem] border-b-[1px] border-[#D6D6D6]">
                <div class="container flex justify-start laptop:justify-between">
                    <div class="[&_button]:text-[#707070] container hidden laptop:flex gap-[2rem]">
                        <button class="text-[1rem] font-400 uppercase">Overview</button>
                        <button class="text-[1rem] font-400 uppercase">Facts & Features</button>
                        <button class="text-[1rem] font-400 uppercase">Map & Directions</button>
                        <button class="text-[1rem] font-400 uppercase">Request Showing</button>
                    </div>
                    <div class="flex gap-5">
                        <button class="button button-blue button-rounded whitespace-nowrap">REQUEST INFO</button>
                        <button class="button button-green button-rounded whitespace-nowrap">ASK QUESTION</button>
                    </div>
                </div>
            </section>

            <section>
                <div class="flex container text-black">
                    <div class="pt-[3rem] laptop:pt-[4rem] laptop:basis-[70%] laptop:grow-0 laptop:pr-20">
                        <h3 class="font-serif text-[2.5rem] laptop:text-[2.625rem] mb-[2rem]">About <?php echo esc_html( $property['top_line_of_address_only'] ); ?></h3>
                        <div class="[&_p]:text-[1rem] [&_p]:leading-[2rem] [&_p]:text-off-black"><?php echo apply_filters( 'the_content', $property['remarks'] ); ?></div>



						<?php
						foreach ( (array) $data_sections as ['title' => $title, 'data' => $data] ) :
							if ( ! trim(
								array_reduce(
									$data,
									function ( $carry, $item ) {
										return (string) $carry . (string) $item['content'];
									},
									null
								)
							) ) :
								continue;
							endif;
							?>
                            <h3 class="font-serif text-[2.5rem] laptop:text-[2.625rem] mb-[2rem] mt-10"><?php echo esc_html( $title ); ?></h3>
                            <div class="grid grid-cols-1 desktop:grid-cols-2 laptop:gap-x-10 property-data-wrap">
								<?php
								foreach ( (array) $data as ['label' => $label, 'content' => $content] ) :
									if ( ! $content ) {
										continue;}
									?>
                                    <div class="property-data-table-row w-full grid-cols-2 grid ">
                                        <div><?php echo esc_html( $label ); ?></div><div><?php echo esc_html( $content ); ?></div>
                                    </div>
								<?php endforeach; ?>
                            </div>

						<?php endforeach; ?>



                        <div class="mt-10">
							<?php echo do_shortcode( sprintf( '[google_map location="%s" price=%s]', $property['address'], sprintf( '$%sK', floor( $property['price'] / 1000 ) ) ) ); ?>
                        </div>




                    </div>
                    <div class="laptop:basis-[30%] shrink-0 flex flex-col gap-5">
                        <div class="bg-off-white p-[1.5rem] flex flex-col gap-5">
                            <button class="button button-blue w-full flex items-center justify-center gap-1">
                                <img src="<?php echo plugin_dir_url( __FILE__ ); ?>/images/smartphone-white.svg" class="h-[1.5rem] w-auto" alt="Cell Phone Icon">VIDEO TOUR FROM HOME
                            </button>
                            <button class="button button-black w-full block">
                                CONTACT AGENT
                            </button>
                        </div>
                        <div class="bg-off-white p-[1.5rem] text-black flex flex-col gap-5 text-off-black form-mask">
                            <p class="uppercase font-bold text-[1rem]">Payment Calculator</p>
                            <div class="flex flex-col gap-1">
                                <p class="text-[0.875rem]"><label for="property-price">Property Price</label></p>
                                <input id="property-price" type="number" class="text-input" value="<?php echo (int) $property['price']; ?>">
                            </div>
                            <div class="flex flex-col gap-1">
                                <p class="text-[0.875rem]"><label for="down-payment">Down Payment</label></p>
                                <div class="flex max-w-full">
                                    <input id="down-payment" type="number" class="text-input w-[65%] border-r-transparent " value="<?php echo (float) $default_down_payment; ?>">
                                    <input id="down-payment-percentage" aria-label="Down Payment Percentage" type="number" class="text-input w-[35%]  grow-0" value="<?php echo (float) $default_down_payment_percentage; ?>">
                                </div>
                            </div>
                            <div class="flex flex-col gap-1">
                                <p class="text-[0.875rem]"><label for="length-of-mortgage">Length of Mortgage</label></p>
                                <input id="length-of-mortgage" type="number" class="text-input " value="<?php echo $default_length_of_mortgage; ?>" data-inputmask="'mask': '99 ye\\ars', 'numericInput': true, 'placeholder': ''" >
                            </div>
                            <div class="flex flex-col gap-1">
                                <p class="text-[0.875rem]"><label for="interest-rate">Annual Interest Rate</label></p>
                                <input id="interest-rate" type="number" class="text-input " value="<?php echo $default_interest_rate; ?>" data-inputmask="'mask': '99%', 'numericInput': true, 'placeholder': ''" >
                            </div>
                            <div id="monthly-payment"></div>

                            <canvas id="mortgage-payment-chart"></canvas>

                        </div>
                    </div>
                </div>
            </section>

        </section><!-- #main -->
    </main><!-- #primary -->
<?php else : ?>
	<p><?php esc_html_e( 'No post found.' ); ?></p>
<?php endif;

get_footer();