(function ($) {
    'use strict';

    $(function () {
        if (typeof FWP !== 'undefined') {
            FWP.auto_refresh = false;
        }
    });

    function processFacets() {
        $('.facetwp-facet').each(function () {
            var facet = $(this);
            var facet_name = facet.attr('data-name');
            var facet_type = facet.attr('data-type');
            var facet_label = FWP.settings.labels[facet_name];

            // Check if this facet should be hidden
            var isHidden = swFacet.preselected_hidden_facets.includes(facet_name);

            if (isHidden) {
                facet.addClass('preselect-hidden');
                return;
            }

            if (!['pager', 'sort', 'reset'].includes(facet_type)) {
                if (facet.closest('.facet-wrap').length < 1 && facet.closest('.facetwp-flyout').length < 1) {
                    facet.wrap('<div class="facet-wrap flex border-slate-700 border-2 max-w-[600px] p-4 m-4"></div>')
                        .before('<p class="facet-label m-0 mr-4">' + facet_label + '</p>');
                }
            }
        });
    }

    $(document).on('facetwp-loaded', processFacets);
})(jQuery);
