(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

    $(document).ready(function () {
        $('#sync-facetwp-settings').click(function (e) {
            e.preventDefault();

            $('#sync-message').hide().text('');

            $.ajax({
                url: swFacetWp.ajax_url,
                type: 'POST',
                data: {
                    action: 'sync_facetwp_settings',
                    nonce: swFacetWp.nonce,
                },
                beforeSend: function () {
                    $('#sync-facetwp-settings').text('Syncing...').prop('disabled', true);
                },
                success: function (response) {
                    if (response.success) {
                        let countdown = 3;

                        $('#sync-message')
                            .text(`FacetWP settings synced successfully! Refreshing page in ${countdown}...`)
                            .css('color', 'green')
                            .show();

                        let interval = setInterval(() => {
                            countdown--;

                            $('#sync-message').text(`FacetWP settings synced successfully! Refreshing page in ${countdown}...`);

                            if (countdown <= 0) {
                                clearInterval(interval);
                                location.reload();
                            }
                        }, 1000);
                    } else {
                        $('#sync-message').text('Error: ' + response.data).css('color', 'red').show();
                    }
                },
                complete: function () {
                    $('#sync-facetwp-settings').text('Sync FacetWP Settings').prop('disabled', false);
                }
            });
        });

        $('#delete-facetwp-cache').click(function (e) {
            e.preventDefault();

            $('#delete-message').hide().text('');

            $.ajax({
                url: swFacetWp.ajax_url,
                type: 'POST',
                data: {
                    action: 'delete_facetwp_cache',
                    nonce: swFacetWp.nonce,
                },
                beforeSend: function () {
                    $('#delete-facetwp-cache').text('Deleting...').prop('disabled', true);
                },
                success: function (response) {
                    if (response.success) {
                        $('#delete-message').text('FacetWP cache cleared successfully!').css('color', 'green').show();
                    } else {
                        $('#delete-message').text('Error: ' + response.data).css('color', 'red').show();
                    }
                },
                complete: function () {
                    $('#delete-facetwp-cache').text('Delete FacetWP Cache').prop('disabled', false);
                }
            });
        });
    });

})( jQuery );
