<?php

class Facet_Wp_Remote_Data_Utils {

	public static function should_ssl_verify() {
		$env = ! empty( $_ENV['WP_ENV'] ) ? $_ENV['WP_ENV'] : null;

		return 'development' !== $env;
	}

	public static function get_remote_site_url() {
		return untrailingslashit( get_option( 'facetwp_remote_data_remote_site_url' ) );
	}

	public static function get_auth_header() {
		$credentials = self::get_remote_site_credentials();

		if ( ! $credentials ) return null;

		$auth_header = base64_encode( "{$credentials['username']}:{$credentials['password']}" );

		return $auth_header;
	}

	private static function get_remote_site_credentials() {
		$username = get_option( 'facetwp_remote_data_remote_site_username' );
		$password = get_option( 'facetwp_remote_data_remote_site_password' );

		return $username && $password
			? [
				'username' => $username,
				'password' => $password
			]
			: null;
	}

}