<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://statenweb.com
 * @since      1.0.0
 *
 * @package    Facet_Wp_Remote_Data
 * @subpackage Facet_Wp_Remote_Data/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Facet_Wp_Remote_Data
 * @subpackage Facet_Wp_Remote_Data/includes
 * @author     Marko Bader <marko@statenweb.com>
 */
class Facet_Wp_Remote_Data_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'facet-wp-remote-data',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
