(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

    $(document).ready(function () {
        $('#sync-facetwp-settings').click(function (e) {
            e.preventDefault();

            $('#sync-message').hide().text('');

            $.ajax({
                url: facetwpSync.ajax_url,
                type: 'POST',
                data: {
                    action: 'sync_facetwp_settings',
                    nonce: facetwpSync.nonce,
                },
                beforeSend: function () {
                    $('#sync-facetwp-settings').text('Syncing...').prop('disabled', true);
                },
                success: function (response) {
                    if (response.success) {
                        $('#sync-message').text('FacetWP settings synced successfully!').css('color', 'green').show();
                    } else {
                        $('#sync-message').text('Error: ' + response.data).css('color', 'red').show();
                    }
                },
                complete: function () {
                    $('#sync-facetwp-settings').text('Sync FacetWP Settings').prop('disabled', false);
                }
            });
        });
    });

})( jQuery );
