(function ($) {
    'use strict';

    $(function () {
        if (typeof FWP !== 'undefined') {
            FWP.auto_refresh = false;
        }
    });

    function processFacets() {
        $('.facetwp-facet').each(function () {
            var facet = $(this);
            var facet_name = facet.attr('data-name');
            var facet_type = facet.attr('data-type');
            var facet_label = FWP.settings.labels[facet_name];

            // Check if this facet should be hidden
            var isHidden = swFacet.preselected_hidden_facets.includes(facet_name);

            if (isHidden) {
                facet.addClass('preselect-hidden');
                return;
            }

            if (swFacet.facet_show_labels) {
                if (!['pager', 'sort', 'reset'].includes(facet_type)) {
                    if (facet.closest('.facet-wrap').length < 1 && facet.closest('.facetwp-flyout').length < 1) {
                        facet.wrap(`<div class="facetwp-facet-wrap-${facet_name} ${swFacet.facet_wrapper_classes}"></div>`)
                            .before(`<p class="facetwp-facet-label-${facet_name} ${swFacet.facet_label_classes}">${facet_label}</p>`);
                    }
                }
            }
        });
    }

    $(document).on('facetwp-loaded', processFacets);
})(jQuery);
