# FacetWP Remote Data

**FacetWP Remote Data** is a WordPress plugin that fetches **FacetWP-filtered data** from a remote WordPress site. This allows you to query and display posts filtered by FacetWP from an external source.

## Features
- Fetch FacetWP-filtered post IDs from a remote site.
- Retrieve full post details via the WordPress REST API.
- Easily configure remote connection settings via the **WordPress Admin**.
- **Custom Templating System:** Customize the output by overriding the default template in your theme or via a filter.
- **JavaScript Enqueueing:** Load scripts dynamically for listing and property pages.

## Installation
1. **Upload the plugin** to your WordPress site.
2. **Activate the plugin** via the **Plugins** menu in WordPress.
3. **Go to Settings → FacetWP Remote Settings** and enter:
    - **Username**
    - **Password**
    - **Remote Site URL**
4. Save changes and click on **'Sync FacetWP Settings'** to sync FacetWP settings from the main site.

### 'Enable Automatic Syncing' Checkbox
When enabled, this option ensures that whenever FacetWP settings are updated on the main site, a request is automatically sent to the subsite to sync and update its FacetWP settings accordingly.

---

## **Caching (Transients)**
FacetWP Remote Data **caches responses from the remote site** using WordPress transients. This reduces the number of API requests and improves performance.

### **Transient Caching for Remote Site Data**
- When fetching FacetWP-filtered data or posts data, the plugin **stores the response in a transient**.
- The transient key is dynamically generated based on the **query arguments** or **post id**.
- Cached data **expires after 10 minutes**, after which a fresh request is made.

#### **Skipping Cache (Forcing a New API Request)**
You can bypass the cache and force a fresh request using the `facetwp_remote_data_skip_cache` filter:
```php
add_filter( 'facetwp_remote_data_skip_cache', '__return_true' );
```

---

## Template Customization
FacetWP Remote Data provides a flexible templating system that allows you to modify the output by copying the template file into your theme, customizing it via a filter, or both.

### **Listing Page Templating**
FacetWP Remote Data provides a template for rendering filtered listing results.

#### **How It Works**
- **Default Template Location:**
  ```
  [plugin root]/templates/facet-wp-remote-data-listing-template.php
  ```

- **Theme Override:**
  ```
  [your-theme]/facet-wp-remote-data/facet-wp-remote-data-listing-template.php
  ```

- **Filter-Based Override:**
  ```php
  add_filter( 'facet_wp_remote_data_listing_template_path', function( $template_path ) {
      return get_stylesheet_directory() . '/custom-templates/custom-facetwp-template.php';
  });
  ```

#### **How to Override the Listing Template**
1. **Copy the default template** from `[plugin root]/templates/facet-wp-remote-data-listing-template.php`.
2. **Paste it into your theme** under `[your-theme]/facet-wp-remote-data/`.
3. The `$properties_data` variable contains the properties data.
4. **Customize as needed.**

---

### **Property Page Templating**
FacetWP Remote Data also provides a **property detail page template** that loads content dynamically based on a property ID.

#### **How It Works**
- The **property page template** is responsible for displaying individual properties.
- It loads dynamically when the URL contains `?id=<property_id>`.

- **Default Template Location:**
  ```
  [plugin root]/templates/facet-wp-remote-data-property-template.php
  ```

- **Theme Override:**
  ```
  [your-theme]/facet-wp-remote-data/facet-wp-remote-data-property-template.php
  ```

- **Filter-Based Override:**
  ```php
  add_filter( 'facet_wp_remote_data_property_template_path', function( $template_path ) {
      return get_stylesheet_directory() . '/custom-templates/custom-property-template.php';
  });
  ```

#### **How to Override the Property Template**
1. **Copy the default template** from `[plugin root]/templates/facet-wp-remote-data-property-template.php`.
2. **Paste it into your theme** under `[your-theme]/facet-wp-remote-data/`.
3. The `$property_data` variable contains the property data.
4. **Customize as needed.**

---

## **Loading Scripts into Templates**
FacetWP Remote Data provides an extendable way to enqueue JavaScript files for both **listing pages** and **property pages**.

### **How It Works**
The plugin fires **two actions** when loading templates:
- `facet_wp_property_page_load` → Fires when rendering a property page.
- `facet_wp_listing_page_load` → Fires when rendering a listing page.

Use these hooks to enqueue JavaScript files dynamically.

### **How to Enqueue Scripts**
To load custom JavaScript for **property pages**, add:
```php
add_action( 'facet_wp_property_page_load', function( $template_path, $template_vars ) {
    wp_enqueue_script(
        'facet-wp-property-script',
        get_stylesheet_directory_uri() . '/assets/js/facet-wp-property.js',
        ['jquery'],
        filemtime(get_stylesheet_directory() . '/assets/js/facet-wp-property.js'),
        true
    );
}, 10, 2 );
```

To load JavaScript for **listing pages**, use:
```php
add_action( 'facet_wp_listing_page_load', function( $template_path, $template_vars ) {
    wp_enqueue_script(
        'facet-wp-listing-script',
        get_stylesheet_directory_uri() . '/assets/js/facet-wp-listing.js',
        ['jquery'],
        filemtime(get_stylesheet_directory() . '/assets/js/facet-wp-listing.js'),
        true
    );
}, 10, 2 );
```

---
