<?php
/**
 * Template for displaying single FacetWP result.
 *
 * This template can be overridden by copying it to yourtheme/facet-wp-remote-data/facet-wp-remote-data-property-template.php.
 *
 * Available variables:
 * - $property_datas_data: Array of posts data.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

get_header();

if ( ! empty( $property_data ) ) : ?>
    <div
        class="facetwp-remote-data-property-container"
        data-post-id="<?php echo esc_attr( $property_data['id'] ); ?>"
        style="margin: 100px; padding: 20px; background-color: lightgray; text-align: center; border: 1px solid #ccc;"
    >
        <?php if ( ! empty( $property_data['_embedded']['wp:featuredmedia'][0]['link'] ) ) : ?>
            <div>
                <img
                    src="<?php echo esc_attr( $property_data['_embedded']['wp:featuredmedia'][0]['link'] ); ?>"
                    alt="<?php echo esc_attr( $property_data['_embedded']['wp:featuredmedia'][0]['title']['rendered'] ); ?>"
                >
            </div>
            <?php endif; ?>
            <?php if ( ! empty( $property_data['title']['rendered'] ) ) : ?>
                <h3>
                    <?php echo esc_html( $property_data['title']['rendered'] ); ?>
                </h3>
            <?php endif; ?>
            <?php if ( ! empty( $property_data['excerpt']['rendered'] ) ) : ?>
                <div>
                    <?php echo wp_kses_post( $property_data['excerpt']['rendered'] ); ?>
                </div>
            <?php endif; ?>
            <?php if ( ! empty( $property_data['_embedded']['wp:term'] ) ) : ?>
            <div>
                <p>
                    Categories:
                    <?php
                        $categories = array_filter(
                            array_map(
                                fn ( $term ) => $term[0]['name'] ?? '',
                                $property_data['_embedded']['wp:term']
                            )
                        );

                        echo ! empty( $categories ) ? implode( ', ', $categories ) : '';
                    ?>
            </div>
        <?php endif; ?>
	    <?php if ( ! empty( $property_data['_embedded']['author'][0]['name'] ) ) : ?>
            <div>
                <p>
                    Author: <?php echo esc_html( $property_data['_embedded']['author'][0]['name'] ); ?>
                </p>
            </div>
	    <?php endif; ?>
    </div>
<?php else : ?>
	<p><?php esc_html_e( 'No post found.' ); ?></p>
<?php endif;

get_footer();