<?php
/**
 * Template for displaying FacetWP results.
 *
 * This template can be overridden by copying it to yourtheme/facet-wp-remote-data/facet-wp-remote-data-listing-template.php.
 *
 * Available variables:
 * - $posts_data: Array of posts data.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! empty( $posts_data ) ) : ?>
    <div
        class="facetwp-remote-data-listing-container"
        style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 10px; padding: 24px;"
    >
        <?php foreach ( $posts_data as $post ) : ?>
            <div
                class="facetwp-remote-data-listing-item"
                data-post-id="<?php echo esc_attr( $post['id'] ); ?>"
                style="padding: 20px; background-color: lightgray; text-align: center; border: 1px solid #ccc;"
            >
                <a href="<?php echo esc_attr( $post['link'] ); ?>">
                    <?php if ( ! empty( $post['_embedded']['wp:featuredmedia'][0]['link'] ) ) : ?>
                        <div>
                            <img
                                src="<?php echo esc_attr( $post['_embedded']['wp:featuredmedia'][0]['link'] ); ?>"
                                alt="<?php echo esc_attr( $post['_embedded']['wp:featuredmedia'][0]['title']['rendered'] ); ?>"
                            >
                        </div>
                    <?php endif; ?>
	                <?php if ( ! empty( $post['title']['rendered'] ) ) : ?>
                        <h3>
			                <?php echo esc_html( $post['title']['rendered'] ); ?>
                        </h3>
	                <?php endif; ?>
	                <?php if ( ! empty( $post['excerpt']['rendered'] ) ) : ?>
                        <div>
			                <?php echo wp_kses_post( $post['excerpt']['rendered'] ); ?>
                        </div>
	                <?php endif; ?>
	                <?php if ( ! empty( $post['_embedded']['wp:term'] ) ) : ?>
                        <div>
                            <p>
                                Categories:
                                <?php
                                    $categories = array_filter(
                                        array_map(
                                            fn ( $term ) => $term[0]['name'] ?? '',
                                            $post['_embedded']['wp:term']
                                        )
                                    );

                                    echo ! empty( $categories ) ? implode( ', ', $categories ) : '';
                                ?>
                        </div>
	                <?php endif; ?>
	                <?php if ( ! empty( $post['_embedded']['author'][0]['name'] ) ) : ?>
                        <div>
                            <p>
                                Author: <?php echo esc_html( $post['_embedded']['author'][0]['name'] ); ?>
                            </p>
                        </div>
	                <?php endif; ?>
                </a>
            </div>
        <?php endforeach; ?>
    </div>
<?php else : ?>
	<p><?php esc_html_e( 'No posts found.' ); ?></p>
<?php endif; ?>
