<section class="pt-12 lg:pt-14 pb-8 border-t border-solid border-[#f2f2f2]">
	<div class="container">
		<?php 
			$latest_listings_arr = Facet_Wp_Remote_Data_Handler::get_latest_listings( posts_per_page: esc_html( $posts_per_page ), paged: esc_html( $paged ) );
		?>
		<div class="cta-headline">
			<h3>Latest Listings</h3>
		</div>
		<?php if( ! empty( $latest_listings_arr ) ) : ?>
			<div class="listings latest-listings">
				<?php foreach( $latest_listings_arr as $latest_listing ) : ?>
					<?php
						$listing_property_id = $latest_listing['property_id'] ?? null;
						$listing_featured_img = $latest_listing['featured_image'] ?? '';
						$listing_additional_imgs = $latest_listing['additional_images'] ?? [];
						$listing_price = $latest_listing['price'] ?? '';
						$listing_address = $latest_listing['address'] ?? '';
						$listing_bedrooms = $latest_listing['bedrooms'] ?? null;
						$listing_bathrooms = $latest_listing['bathrooms'] ?? null;
						$listing_square_feet = $latest_listing['square_feet'] ?? null;
						$listing_property_subtype = $latest_listing['property_subtype'] ?? '';
						$listing_mls_id = $latest_listing['mls_id'];
						$listing_latitude = $latest_listing['latitude'];
						$listing_longitude = $latest_listing['longitude'];
						$listing_link = $latest_listing['link'] ?? '#';

					?>
					<a class="facetwp-remote-data-latest-listing-item" href="<?php echo esc_url( $listing_link ); ?>" data-post-id="<?php echo esc_attr( $listing_property_id ); ?>">
						<div class="header inline-block w-full aspect-[4/3] h-auto lg:h-[303px] overflow-hidden">
							<?php if ( ! empty( $listing_featured_img ) ) : ?>
								<img class="w-full h-full object-cover object-center" width="404" height="303" src="<?php echo esc_attr( $listing_featured_img ); ?>" alt="<?php echo esc_attr( $listing_address ); ?>">
							<?php else : ?>
                                <div class="relative w-full h-full bg-gray-500 text-white"></div>
							<?php endif; ?>
						</div>
						<div class="body">
							<?php if ( ! empty( $listing_price ) ) : ?>
								<h3><?php echo '$' . esc_html( number_format( $listing_price ) ); ?></h3>
							<?php endif; ?>
							<?php if ( ! empty( $listing_address ) ) : ?>
								<address class="listing-addr"><?php echo esc_html( $listing_address ); ?></address>
							<?php endif; ?>
							<?php if ( ! empty( $listing_mls_id ) ) : ?>
								<div class="listing-mls">MLS#: <?php echo esc_html( $listing_mls_id ); ?></div>
							<?php endif; ?>
							<div class="listing-office">Robert DeFalco Realty, Inc.</div>
						</div>
					</a>
				<?php endforeach; ?>
			</div>
		<?php endif ?>
	</div>
</section>