<?php

enum Mls: string
{
	case SIBOR_MLS = 'sibor_mls';
	case BROOKLYN = 'brooklyn';
	case JERSEYMLS = 'jerseymls';
	case MONMOUTH_MLS = 'monmouth_mls';

	public function label(): string
	{
		return match ( $this ) {
			self::SIBOR_MLS => 'Staten Island',
			self::BROOKLYN => 'Brooklyn',
			self::JERSEYMLS => 'Central Jersey',
			self::MONMOUTH_MLS => 'Monmouth County',
		};
	}

	public static function labels( $keysToUpper = false ): array
	{
		return array_reduce( self::cases(), function ( $carry, $case ) use ( $keysToUpper ) {
			$key = $keysToUpper ? strtoupper( $case->value ) : $case->value;

			$carry[ $key ] = $case->label();

			return $carry;
		}, [] );
	}

	public static function fromLabel( string $label ): ?self
	{
		foreach ( self::cases() as $case ) {
			if ( strcasecmp( $case->label(), $label ) === 0 ) {
				return $case;
			}
		}

		return null;
	}

	public function cacheKey(): string
	{
		return 'facet_wp_map_all_locations_' . strtolower( $this->value );
	}

	public static function getCacheKey( string $mls ): ?string {
		return Mls::tryFrom( $mls )?->cacheKey();
	}

	public static function cacheKeys(): array
	{
		return array_reduce( self::cases(), function ( $carry, $case ) {
			$carry[ $case->value ] = $case->cacheKey();

			return $carry;
		}, [] );
	}
}
