<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://statenweb.com
 * @since             1.0.0
 * @package           Facet_Wp_Remote_Data
 *
 * @wordpress-plugin
 * Plugin Name:       FacetWP remote data
 * Plugin URI:        https://statenweb.com
 * Description:       Retrieve FacetWP filtered data from a remote WordPress site.
 * Version:           1.1.33
 * Author:            Marko Bader
 * Author URI:        https://statenweb.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       facet-wp-remote-data
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'FACET_WP_REMOTE_DATA_VERSION', '1.1.33' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-facet-wp-remote-data-activator.php
 */
function activate_facet_wp_remote_data() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-facet-wp-remote-data-activator.php';
	Facet_Wp_Remote_Data_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-facet-wp-remote-data-deactivator.php
 */
function deactivate_facet_wp_remote_data() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-facet-wp-remote-data-deactivator.php';
	Facet_Wp_Remote_Data_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_facet_wp_remote_data' );
register_deactivation_hook( __FILE__, 'deactivate_facet_wp_remote_data' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-facet-wp-remote-data.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_facet_wp_remote_data() {

	$plugin = new Facet_Wp_Remote_Data();
	$plugin->run();

}
run_facet_wp_remote_data();
