<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://statenweb.com
 * @since      1.0.0
 *
 * @package    Facet_Wp_Remote_Data
 * @subpackage Facet_Wp_Remote_Data/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Facet_Wp_Remote_Data
 * @subpackage Facet_Wp_Remote_Data/public
 * @author     Marko Bader <marko@statenweb.com>
 */
class Facet_Wp_Remote_Data_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Facet_Wp_Remote_Data_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Facet_Wp_Remote_Data_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/facet-wp-remote-data-public.css', array(), $this->version, 'all' );

		wp_enqueue_style(
			'facetwp-remote-data--subsite-tailwind',
			plugin_dir_url( dirname( __FILE__ ) ) . 'assets/css/tailwind-built.css',
			[],
			$this->version
		);

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Facet_Wp_Remote_Data_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Facet_Wp_Remote_Data_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		global $post;

//		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/facet-wp-remote-data-public.js', array( 'jquery' ), $this->version, false );

		if (
			'1' === get_query_var( 'sw_remote_data_property_page' )
			|| ( is_singular() && has_shortcode( $post->post_content, 'property_payment_calculator' ) )
		) {
			if ( ! wp_script_is( 'chart' ) ) {
				wp_enqueue_script(
					'chart',
					'https://cdn.jsdelivr.net/npm/chart.js',
					array( 'jquery' ),
					'1.0.0',
					true
				);
			}

			if ( ! wp_script_is( 'chart-labels' ) ) {
				wp_enqueue_script(
					'chart-labels',
					'https://cdn.jsdelivr.net/npm/chartjs-plugin-datalabels',
					array( 'jquery', 'chart' ),
					'1.0.0',
					true
				);
			}

			if ( ! wp_script_is( 'sw-input-mask' ) ) {
				wp_enqueue_script(
					'sw-input-mask',
					'https://cdnjs.cloudflare.com/ajax/libs/jquery.inputmask/3.3.4/jquery.inputmask.bundle.min.js',
					array( 'jquery' ),
					'3.3.4',
					true
				);
			}

			wp_enqueue_script(
				'payment-calculator',
				plugin_dir_url( __FILE__ ) . 'js/payment-calculator.js',
				array( 'jquery', 'sw-input-mask', 'chart-labels' ),
				$this->version,
				false
			);
		}

		if ( function_exists( 'FWP' ) && ! empty( $post ) ) {
			$preselected_hidden_facets = [];

			$facets = FWP()->helper->get_facets();

			foreach ( $facets as $facet ) {
				$facet_name = $facet['name'];

				$preselected_value = get_post_meta(
					$post->ID,
					Facet_Wp_Remote_Data_Neighborhood_Page::PREFIX_FACET_WP_REMOTE_DATA_PRESELECTED__FACET . $facet_name,
					true
				);

				$show_preselected = get_post_meta(
					$post->ID,
					Facet_Wp_Remote_Data_Neighborhood_Page::PREFIX_FACET_WP_REMOTE_DATA_PRESELECTED__FACET . $facet_name . '_show',
					true
				);

				if ( 'sort' !== $facet['type'] && ( ! empty( $preselected_value ) && empty( $show_preselected ) ) ) {
					$preselected_hidden_facets[] = $facet_name;
				}
			}

			wp_enqueue_script(
				'facet-labels-and-visibility',
				plugin_dir_url( __FILE__ ) . 'js/facet-labels-and-visibility.js',
				array( 'jquery' ),
				$this->version,
				false
			);

			wp_localize_script(
				'facet-labels-and-visibility',
				'swFacet',
				[
					'preselected_hidden_facets' => $preselected_hidden_facets,
					'facet_show_labels' => apply_filters( 'sw_facetwp_show_labels', true ),
					'facet_wrapper_classes' => apply_filters(
						'sw_facetwp_wrapper_classes',
						'facet-wrap flex border-slate-700 border-2 max-w-[600px] p-4 m-4'
					),
					'facet_label_classes' => apply_filters(
						'sw_facetwp_label_classes',
						'facet-label m-0 mr-4'
					),
				]
			);
		}

		wp_enqueue_script(
			'facetwp-remote-data-user',
			plugin_dir_url( __FILE__ ) . 'js/facetwp-remote-data-user.js',
			array( 'jquery' ),
			$this->version,
			true
		);

		wp_localize_script(
			'facetwp-remote-data-user',
			'swFacetWpUser',
			[
				'nonce' => wp_create_nonce( 'wp_rest' ),
			]
		);
	}

}
