<?php
/**
 * Template for displaying FacetWP results.
 *
 * This template can be overridden by copying it to yourtheme/facet-wp-remote-data/facet-wp-remote-data-listing-template.php.
 *
 * Available variables:
 * - $properties_data: Array of properties data.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! empty( $properties_data ) ) : ?>
    <div
        class="facetwp-remote-data-listing-container"
        style="display: grid; grid-template-columns: repeat(3, 1fr); gap: 10px; padding: 24px;"
    >
        <?php foreach ( $properties_data as $property ) : ?>
            <div
                class="facetwp-remote-data-listing-item"
                data-post-id="<?php echo esc_attr( $property['property_id'] ); ?>"
                style="padding: 20px; background-color: lightgray; text-align: center; border: 1px solid #ccc;"
            >
                <a href="<?php echo esc_attr( $property['link'] ); ?>">
                    <?php if ( ! empty( $property['featured_image'] ) ) : ?>
                        <div>
                            <img
                                src="<?php echo esc_attr( $property['featured_image'] ); ?>"
                                alt="<?php echo esc_attr( $property['address'] ); ?>"
                            >
                        </div>
                    <?php endif; ?>
	                <?php if ( ! empty( $property['price'] ) ) : ?>
                        <h3>
			                <?php echo '$' . esc_html( number_format( $property['price'] ) ); ?>
                        </h3>
	                <?php endif; ?>
	                <?php if ( ! empty( $property['address'] ) ) : ?>
                        <h5>
			                <?php echo esc_html( $property['address'] ); ?>
                        </h5>
	                <?php endif; ?>

	                <?php if ( ! empty( $property['bedrooms'] ) ) : ?>
                        <p>
			                <?php echo esc_html( $property['bedrooms'] ); ?> BEDS
                        </p>
	                <?php endif; ?>
	                <?php if ( ! empty( $property['bathrooms'] ) ) : ?>
                        <p>
			                <?php echo esc_html( $property['bathrooms'] ); ?> BATHS
                        </p>
	                <?php endif; ?>
	                <?php if ( ! empty( $property['bathrooms'] ) ) : ?>
                        <p>
			                <?php echo esc_html( number_format( $property['bathrooms'] ) ); ?> SQFT
                        </p>
	                <?php endif; ?>
	                <?php if ( ! empty( $property['type'] ) ) : ?>
                        <p>
			                <?php echo esc_html( $property['type'] ); ?>
                        </p>
	                <?php endif; ?>
	                <?php if ( ! empty( $property['mls_id'] ) ) : ?>
                        <p>
			                MLS ® # <?php echo esc_html( $property['mls_id'] ); ?>
                        </p>
	                <?php endif; ?>
                </a>
            </div>
        <?php endforeach; ?>
    </div>
<?php else : ?>
	<p><?php esc_html_e( 'No posts found.' ); ?></p>
<?php endif; ?>
