<?php

/**
 * Define the internationalization functionality
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @link       https://statenweb.com
 * @since      1.0.0
 *
 * @package    Facetwp_Remote_Data_Main_Site
 * @subpackage Facetwp_Remote_Data_Main_Site/includes
 */

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.0.0
 * @package    Facetwp_Remote_Data_Main_Site
 * @subpackage Facetwp_Remote_Data_Main_Site/includes
 * @author     Marko Bader <marko@statenweb.com>
 */
class Facetwp_Remote_Data_Main_Site_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'facetwp-remote-data-main-site',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

	}



}
