<?php

class Facet_Wp_Remote_Data_Cache {

	public const PREFIX_PROPERTIES_LISTING_DATA = 'properties_listing_data_';
	public const PREFIX_PROPERTY_PAGE_DATA = 'property_page_data_';
	public const PREFIX_PROPERTIES_MAP_DATA = 'properties_map_data_';

	public static function get_cache_prefixes() {
		return [
			self::PREFIX_PROPERTIES_LISTING_DATA,
			self::PREFIX_PROPERTY_PAGE_DATA,
			self::PREFIX_PROPERTIES_MAP_DATA,
		];
	}

	public static function properties_listing_site_data( $post_ids ) {
		return self::PREFIX_PROPERTIES_LISTING_DATA . md5( is_array( $post_ids ) ? serialize( $post_ids ) : $post_ids );
	}

	public static function properties_listing_map_data( $post_ids ) {
		return self::PREFIX_PROPERTIES_MAP_DATA . md5( is_array( $post_ids ) ? serialize( $post_ids ) : $post_ids );
	}

	public static function property_site_data( $post_id ) {
		return self::PREFIX_PROPERTY_PAGE_DATA . $post_id;
	}

	public static function set( $transient_key, $data, $expiration = 10 * MINUTE_IN_SECONDS  ) {
		set_transient( $transient_key, $data, $expiration );
	}

	public static function delete_property_cached_data( $post_id ) {
		$transient_key = self::property_site_data( $post_id );

		$deleted_transient = delete_transient( $transient_key );

		return $deleted_transient
			? true
			: new WP_Error( 'no_rows', 'No cached data.', ['status' => 204] );
	}

	public static function delete_cache() {
		global $wpdb;

		$prefixes = self::get_cache_prefixes();

		$deleted = 0;

		if ( wp_using_ext_object_cache() ) {
			// Delete transients stored in the object cache (if not stored in the DB)
			if ( function_exists( 'wp_cache_flush_group' ) ) {
				$deleted = wp_cache_flush_group( 'transient' );
			}
		} else {
			// Delete transients stored in the DB
			foreach ( $prefixes as $prefix ) {
				$result = $wpdb->query(
					$wpdb->prepare(
						"DELETE FROM {$wpdb->options} WHERE option_name LIKE %s",
						$wpdb->esc_like( '_transient_' . $prefix ) . '%'
					)
				);

				$deleted += $result ?: 0;
			}
		}

		return $deleted ? true : new WP_Error( 'no_rows', 'No cached data.', ['status' => 204] );
	}

}
