<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://statenweb.com
 * @since             1.0.0
 * @package           Facetwp_Remote_Data_Main_Site
 *
 * @wordpress-plugin
 * Plugin Name:       FacetWP remote data
 * Plugin URI:        https://statenweb.com
 * Description:       Share FacetWP filtered data to a remote WordPress site
 * Version:           1.0.11
 * Author:            Marko Bader
 * Author URI:        https://statenweb.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       facetwp-remote-data-main-site
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'FACETWP_REMOTE_DATA_MAIN_SITE_VERSION', '1.0.11' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-facetwp-remote-data-main-site-activator.php
 */
function activate_facetwp_remote_data_main_site() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-facetwp-remote-data-main-site-activator.php';
	Facetwp_Remote_Data_Main_Site_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-facetwp-remote-data-main-site-deactivator.php
 */
function deactivate_facetwp_remote_data_main_site() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-facetwp-remote-data-main-site-deactivator.php';
	Facetwp_Remote_Data_Main_Site_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_facetwp_remote_data_main_site' );
register_deactivation_hook( __FILE__, 'deactivate_facetwp_remote_data_main_site' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-facetwp-remote-data-main-site.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_facetwp_remote_data_main_site() {

	$plugin = new Facetwp_Remote_Data_Main_Site();
	$plugin->run();

}
run_facetwp_remote_data_main_site();
