<?php

class Facetwp_Remote_Data_Main_Site_Facetwp_Handler {

	protected $background_process;

	public function __construct() {
		$this->background_process = new Facetwp_Remote_Data_Background_Process();
	}

	public function facetwp_api_can_access() {
		return current_user_can( 'manage_options' );
	}

	public function update_option_facetwp_settings( $old_value, $new_value ) {
		if ( $old_value === $new_value ) return;

		$subsites = get_option( 'facetwp_remote_data_subsites_urls', [] );

		if ( empty( $subsites ) || ! is_array( $subsites ) ) return;

		foreach ( $subsites as $subsite_url ) {
			$this->background_process->push_to_queue(
				[
					'subsite_url' => $subsite_url,
					'tries' => 0,
				]
			);
		}

		$this->background_process->save();
	}

	public static function trigger_facetwp_sync( $subsite_url ) {
		$sync_url = trailingslashit( $subsite_url ) . 'wp-json/sw-facetwp/v1/sync-settings';

		error_log( "FacetWP Remote Data: Triggering sync for: {$sync_url}" );

		$response = wp_remote_get(
			$sync_url, [
				'headers' => [
					'Main-Site-Url' => get_bloginfo( 'url' )
				],
				'timeout' => 30,
				'sslverify' => Facetwp_Remote_Data_Main_Site_Utils::should_ssl_verify()
			]
		);

		if ( is_wp_error( $response ) ) {
			error_log( "ERROR: FacetWP Remote Data - syncing with {$subsite_url}: " . $response->get_error_message() );
			return false;
		}

		$http_code = wp_remote_retrieve_response_code( $response );

		if ( $http_code !== 200 ) {
			error_log( "ERROR: FacetWP Remote Data - received HTTP status code {$http_code} from {$subsite_url}." );
			return false;
		}

		error_log( "SUCCESS: FacetWP Remote Data - FacetWP settings synced successfully for {$subsite_url}." );

		return true;
	}

}