<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://statenweb.com
 * @since      1.0.0
 *
 * @package    Facetwp_Remote_Data_Main_Site
 * @subpackage Facetwp_Remote_Data_Main_Site/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Facetwp_Remote_Data_Main_Site
 * @subpackage Facetwp_Remote_Data_Main_Site/admin
 * @author     Marko Bader <marko@statenweb.com>
 */
class Facetwp_Remote_Data_Main_Site_Admin {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Facetwp_Remote_Data_Main_Site_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Facetwp_Remote_Data_Main_Site_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/facetwp-remote-data-main-site-admin.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Facetwp_Remote_Data_Main_Site_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Facetwp_Remote_Data_Main_Site_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/facetwp-remote-data-main-site-admin.js', array( 'jquery' ), $this->version, false );

		wp_localize_script( $this->plugin_name,
			'swFacetWp',
			[
				'ajax_url' => admin_url( 'admin-ajax.php' ),
				'nonce'    => wp_create_nonce( 'facetwp_sw_facetwp_admin_ajax_nonce' ),
			]
		);
	}

	public function add_plugin_admin_menu() {
		add_options_page(
			__( 'FacetWP Remote Site Settings' ),
			__( 'FacetWP Remote Settings' ),
			'manage_options',
			'facetwp-remote-data-settings',
			[ $this, 'display_settings_page' ]
		);
	}

	public function display_settings_page() {
		?>
		<div class="wrap">
			<h1><?php esc_html_e( 'FacetWP Remote Site Settings' ); ?></h1>

			<!-- Clear Cache -->
			<p>
				Clear cache (delete all transients).
				<br>
				<strong>Warning:</strong> This will clear the cached FacetWP data on this site.
			</p>
			<button id="delete-facetwp-cache" class="button button-primary">
				<?php esc_html_e( 'Clear FacetWP Cache' ); ?>
			</button>

			<p id="delete-message" style="display: none; color: green;"></p>
		</div>
		<?php
	}

	public function wp_ajax_delete_facetwp_cache_callback() {
		check_ajax_referer( 'facetwp_sw_facetwp_admin_ajax_nonce', 'nonce' );

		$result = Facet_Wp_Remote_Data_Cache::delete_cache();

		if ( is_wp_error( $result ) ) {
			wp_send_json_error( $result->get_error_message() );
		} else {
			wp_send_json_success( [ 'message' => "FacetWP cache cleared!", 'deleted' => true ] );
		}

		exit();
	}

	public function save_post_property( $post_id ) {
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;

		if ( false !== wp_is_post_revision( $post_id ) ) return;

		if ( 'publish' !== get_post_status( $post_id ) ) return;

		delete_transient( Facet_Wp_Remote_Data_Cache::property_site_data( $post_id ) );
	}

}
