<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://statenweb.com
 * @since      1.0.0
 *
 * @package    Facetwp_Remote_Data_Main_Site
 * @subpackage Facetwp_Remote_Data_Main_Site/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Facetwp_Remote_Data_Main_Site
 * @subpackage Facetwp_Remote_Data_Main_Site/public
 * @author     Marko Bader <marko@statenweb.com>
 */
class Facetwp_Remote_Data_Main_Site_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Facetwp_Remote_Data_Main_Site_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Facetwp_Remote_Data_Main_Site_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/facetwp-remote-data-main-site-public.css', array(), $this->version, 'all' );

	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Facetwp_Remote_Data_Main_Site_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Facetwp_Remote_Data_Main_Site_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/facetwp-remote-data-main-site-public.js', array( 'jquery' ), $this->version, false );

	}

}
