<?php

class Facetwp_Remote_Data_Main_Site_Rest_Api {

	public function register_rest_api_routes() {
		register_rest_route(
			'sw-facetwp/v1',
			'/get-facetwp-settings',
			[
				'methods'  => 'GET',
				'callback' => [$this, 'facetwp_get_settings'],
				'permission_callback' => [$this, 'facetwp_check_permissions'],
			]
		);

		register_rest_route(
			'sw-facetwp/v1',
			'/forward-autocomplete-ajax-call',
			[
				'methods'  => 'POST',
				'callback' => [$this, 'facetwp_subsite_forwarded_autocomplete_ajax_call'],
				'permission_callback' => [$this, 'facetwp_check_permissions'],
			]
		);
	}

	public function facetwp_get_settings( WP_REST_Request $request ) {
		$facetwp_settings = get_option( 'facetwp_settings' );

		if ( empty( $facetwp_settings ) ) {
			return new WP_Error( 'no_settings', 'FacetWP settings not found', ['status' => 404] );
		}

		$subsite_url = $request->get_header( 'Subsite-Url' );

		if ( ! empty( $subsite_url ) ) {
			$sanitized_origin = esc_url_raw( $subsite_url );

			$subsites = get_option( 'facetwp_remote_data_subsites_urls', [] );

			if ( ! is_array( $subsites ) ) {
				$subsites = [];
			}

			if ( ! in_array( $sanitized_origin, $subsites, true ) ) {
				$subsites[] = $sanitized_origin;

				update_option( 'facetwp_remote_data_subsites_urls', $subsites );
			}
		}

		return rest_ensure_response( $facetwp_settings );
	}

	public function facetwp_subsite_forwarded_autocomplete_ajax_call( WP_REST_Request $request ) {
		$raw_body = $request->get_body();

		$decoded_body = json_decode( $raw_body, true );

		$_POST = is_array( $decoded_body ) ? $decoded_body : [];

		if ( class_exists( 'FacetWP_Facet_Autocomplete' ) ) {
			( new \FacetWP_Facet_Autocomplete() )->ajax_load();

			exit();
		}
	}

	public function facetwp_check_permissions() {
		return current_user_can( 'manage_options' );
	}

}