<?php
/**
 * Init all the functions.
 *
 * @package Virtue Bold
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Main Child Theme Function INIT
 */
function v_bold_startup() {
	// Remove Date.
	remove_action( 'virtue_post_mini_excerpt_before_header', 'virtue_post_meta_date', 10 );
	remove_action( 'virtue_post_excerpt_before_header', 'virtue_single_post_meta_date', 20 );
	remove_action( 'virtue_single_post_before_header', 'virtue_single_post_meta_date', 20 );
	remove_action( 'virtue_post_carousel_small_excerpt_header', 'virtue_post_carousel_date', 20 );
	// Remove Grid subhead.
	remove_action( 'virtue_post_grid_small_excerpt_header', 'virtue_post_grid_header_meta', 20 );
	remove_action( 'virtue_post_grid_excerpt_header', 'virtue_post_grid_header_meta', 20 );
	// Remove Subhead.
	remove_action( 'virtue_post_excerpt_header', 'virtue_post_header_meta', 20 );
	remove_action( 'virtue_single_loop_post_header', 'virtue_post_header_meta', 30 );
	remove_action( 'virtue_single_post_header', 'virtue_post_header_meta', 30 );
	remove_action( 'virtue_post_mini_excerpt_header', 'virtue_post_meta_tooltip_subhead', 20 );
	// Remove Tags.
	remove_action( 'virtue_post_excerpt_footer', 'virtue_post_footer_tags', 10 );
	remove_action( 'virtue_post_grid_excerpt_footer', 'virtue_post_footer_tags', 10 );
	remove_action( 'virtue_single_loop_post_footer', 'virtue_post_footer_tags', 20 );
	remove_action( 'virtue_single_post_footer', 'virtue_post_footer_tags', 20 );

	/**
	 * Add Category
	 */
	function v_bold_post_header_category() {
		if ( '1' === virtue_premium_get_option( 'hide_postedin' ) && has_category() ) {
			echo '<div class="kt_head_category">';
				the_category( '|' );
			echo '</div>';
		}
	}
	add_action( 'virtue_post_excerpt_header', 'v_bold_post_header_category', 5 );
	add_action( 'virtue_single_post_header', 'v_bold_post_header_category', 5 );
	add_action( 'virtue_single_loop_post_header', 'v_bold_post_header_category', 5 );
	/**
	 * Define Image Height
	 */
	function v_bold_default_image_height() {
		return null;
	}
	add_filter( 'kt_post_excerpt_image_height', 'v_bold_default_image_height' );
	/**
	 * Define Image Width
	 */
	function v_bold_default_single_image_width() {
		return 1334;
	}
	add_filter( 'kt_blog_full_image_width', 'v_bold_default_single_image_width' );
	/**
	 * Define Image Width
	 */
	function v_bold_default_blog_image_width() {
		return 1334;
	}
	add_filter( 'kt_blog_image_width', 'v_bold_default_blog_image_width' );
	/**
	 * Add Meta Author and Comments
	 */
	function v_bold_post_header_meta() {
		echo '<div class="kt_bold_meta">';
		do_action( 'virtue_bold_before_post_meta_subhead' );
		if ( ( 'post' === get_post_type() && '1' === virtue_premium_get_option( 'hide_postdate' ) ) || ( 'post' !== get_post_type() && '1' === virtue_premium_get_option( 'custom_post_show_postdate' ) ) ) {
			echo '<span class="updated kt_bold_date" itemprop="datePublished"><span class="postday">' . esc_html( get_the_date( get_option( 'date_format' ) ) ) . '</span></span>';
		}
		if ( '1' === virtue_premium_get_option( 'hide_author' ) ) {
			$authorbytext = virtue_premium_get_option( 'post_by_text', __( 'by', 'virtue' ) );
			echo '<span class="kt_bold_postauthor author vcard"> - <span class="kt_bold_admin_text">' . esc_html( $authorbytext ) . '</span> <span itemprop="author"><a href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" class="fn" rel="author">' . get_the_author() . '</a></span></span>';
		}
		if ( get_comments_number() != 0 && '1' === virtue_premium_get_option( 'hide_commenticon' ) ) {
			echo '<span class="postcommentscount"> - <a href="' . esc_attr( get_the_permalink() ) . '#virtue_comments"><i class="icon-bubbles3"></i> ' . esc_html( get_comments_number( '0', '1', '%' ) ) . '</a></span>';
		}

		do_action( 'virtue_bold_after_post_meta_subhead' );
		echo '</div>';
	}
	add_action( 'virtue_post_mini_excerpt_header', 'v_bold_post_header_meta', 20 );
	add_action( 'virtue_post_excerpt_header', 'v_bold_post_header_meta', 20 );
	add_action( 'virtue_single_loop_post_header', 'v_bold_post_header_meta', 30 );
	add_action( 'virtue_single_post_header', 'v_bold_post_header_meta', 30 );

	/**
	 * Add Meta Date
	 */
	function v_bold_post_header_date() {
		if ( ( 'post' === get_post_type() && '1' === virtue_premium_get_option( 'hide_postdate' ) ) || ( 'post' !== get_post_type() && '1' === virtue_premium_get_option( 'custom_post_show_postdate' ) ) ) {
			echo '<div class="kt_bold_meta_date">';
			echo '<span class="updated kt_bold_date" itemprop="datePublished"><span class="postday">' . esc_html( get_the_date( get_option( 'date_format' ) ) ) . '</span></span>';
			echo '</div>';
		}
	}
	add_action( 'virtue_post_carousel_small_excerpt_header', 'v_bold_post_header_date', 30 );

	/**
	 * Move Breadcrumbs
	 */
	function v_bold_virtue_post_header_breadcrumbs() {
		if ( is_single() ) {
			if ( kadence_display_post_breadcrumbs() ) {
				echo '<div id="single-post-titleclass" class="titleclass"><div class="container">';
					virtue_breadcrumbs();
				echo '</div></div>';
			}
		}
	}
	add_action( 'virtue_single_post_begin', 'v_bold_virtue_post_header_breadcrumbs', 5 );
	remove_action( 'virtue_single_post_header', 'virtue_post_header_breadcrumbs', 10 );

	/**
	 * Add Custom CSS
	 */
	function v_bold_custom_css() {
		global $virtue_premium;
		if ( ! empty( $virtue_premium['primary_color'] ) ) {
			$primary_color = '.product_item .kad_add_to_cart:hover, .product_item.hidetheaction:hover .kad_add_to_cart:hover, .kad-btn-primary:hover, html .woocommerce-page .widget_layered_nav ul.yith-wcan-label li a:hover, html .woocommerce-page .widget_layered_nav ul.yith-wcan-label li.chosen a, .woocommerce-message .button:hover, .widget_layered_nav_filters ul li a, .widget_layered_nav ul li.chosen a, .track_order .button:hover, .wpcf7 input.wpcf7-submit:hover, .yith-wcan .yith-wcan-reset-navigation:hover, .single_add_to_cart_button:hover, .kad-hover-bg-primary:hover, .widget_shopping_cart_content .checkout:hover, .login .form-row .button:hover, .post-password-form input[type="submit"]:hover, .menu-cart-btn .kt-cart-total:hover, #kad-head-cart-popup a.button.checkout:hover, .kad-post-navigation .kad-previous-link a:hover, .kad-post-navigation .kad-next-link a:hover, .shipping-calculator-form .button, .cart_totals .checkout-button, .select2-results .select2-highlighted, .variations .kad_radio_variations label.selectedValue, #payment #place_order, .shop_table .actions input[type=submit].checkout-button, input[type="submit"].button, .order-actions .button, .image_menu_hover_class, #commentform .form-submit #submit:hover, .product_item .add_to_cart_button:hover,.product .entry-summary .kad_add_to_cart:hover, .kad-post-navigation .kad-next-link a, .kad-post-navigation .kad-previous-link a, .widget_archives.so-panel ul a, .widget_categories.so-panel ul a, .widget_recent-posts.so-panel ul a, input[type="submit"].button:hover, .home-iconmenu .home-icon-item:hover, .home-iconmenu a:hover, .wrap .cart_totals .checkout-button:hover {border-color:'.$virtue_premium['primary_color'].';} .product .entry-summary .kad_add_to_cart:hover, .product .entry-summary .single_add_to_cart_button:hover, #commentform .form-submit #submit:hover, .wrap .cart_totals .checkout-button:hover {background:'.$virtue_premium['primary_color'].';} .widget_archives.so-panel ul a:hover, .widget_categories.so-panel ul a:hover, .widget_recent-posts.so-panel ul a:hover {color:'.$virtue_premium['primary_color'].';}';
		} else {
			$primary_color = '';
		}
		if(!empty($virtue_premium['x1_virtue_logo_upload']['url'])) {
			$logobg = '#nav-main .sf-menu>li:first-child:before { background: url('.$virtue_premium['x1_virtue_logo_upload']['url'].'); background-size: contain; background-repeat: no-repeat; background-position: center; background-position-x:110px;}';
		} else {
			$logobg = '';
		}
		echo '<style type="text/css" id="kt-childbold-custom-css">' . $primary_color . $logobg . '</style>';
	}
	add_action( 'wp_head', 'v_bold_custom_css', 50 );

	// Shop Page.
	remove_action( 'virtue_woocommerce_page_title_right', 'virtue_woocommerce_page_title_shortcode', 40 );
	if ( function_exists( 'virtue_woocommerce_page_title_shortcode' ) ) {
		add_action( 'virtue_woocommerce_page_title_left', 'virtue_woocommerce_page_title_shortcode', 40 );
	}
	/**
	 * Open shop top container.
	 */
	function v_bold_open_shop_top_container() {
		echo '<div class="clearfix kt_shop_top_container">';
	}
	add_action( 'woocommerce_before_shop_loop', 'v_bold_open_shop_top_container', 15 );
	/**
	 * Close shop top container.
	 */
	function v_bold_close_shop_top_container() {
		echo '</div>';
	}
	add_action( 'woocommerce_before_shop_loop', 'v_bold_close_shop_top_container', 45 );

	remove_action( 'virtue_woocommerce_page_title_left', 'woocommerce_result_count', 20 );
	add_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 30 );
	remove_action( 'virtue_woocommerce_page_title_right', 'woocommerce_catalog_ordering', 30 );
	add_action( 'woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 40 );
	remove_action( 'virtue_woocommerce_page_title_right', 'virtue_woocommerce_page_title_toggle', 20 );

	if ( function_exists( 'virtue_woocommerce_page_title_toggle' ) ) {
		add_action( 'woocommerce_before_shop_loop', 'virtue_woocommerce_page_title_toggle', 35 );
	}
	// Product Page.
	if ( function_exists( 'virtue_woo_product_breadcrumbs' ) ) {
		add_action( 'woocommerce_before_main_content', 'virtue_woo_product_breadcrumbs', 5 );
	}
	remove_action( 'woocommerce_before_main_content', 'virtue_woo_product_breadcrumbs', 20 );

	// Getting Started Page.
	function v_bold_import_options_default() {
		echo '<h3>'.__('Virtue Bold - Premium Child Theme', 'virtue_bold').'</h3>';
		echo '<h4>If you are a new user it is recomended that you install the Bold theme options defaults.</h4>';
		echo '<p>Please note that activating the bold default theme options will reset any theme options for the virtue premium theme. If you have made any changes in the theme options panel be sure to create a backup of your theme options using the export tool.</p>';
	}
	add_action( 'kt_startpage_getting_started_top', 'v_bold_import_options_default');

	add_filter( 'kt_getting_started_page_title', 'v_bold_startup_title');
	function v_bold_startup_title() {
			return '<h1>' . __( 'Virtue Bold - Premium Child Theme', 'virtue_bold' ) . '</h1>';
	}
	add_action( 'kt_getting_started_nav_before', 'v_bold_startup_tab');
	function v_bold_startup_tab() {
			echo '<a class="nav-tab nav-tab-active" data-tab-id="kt-boldtab" href="#">' . __( 'Virtue Bold', 'virtue_bold' ) .'</a>';
	}
	add_action( 'kt_getting_started_before', 'v_bold_startup_tab_content');
	function v_bold_startup_tab_content() {
		?>
		<div id="kt-boldtab" class="nav-tab-content panel_open kt-admin-clearfix">
		    <div class="kad-startup-bold kt-main">
		        <?php do_action('kt_getting_started_before_helpful'); ?>
		        <h4><?php echo __('Virtue Bold Startup Info', 'virtue_bold');?></h4>
		        <p class="kt-notice">If you are a new user it is recomended that you set the Bold theme options defaults.</p>
		        <button class="kt-install-theme-options">Set Bold Theme Options Defaults</button>
		        <p class="kt_default_set_success kt-ajax-notice" style="display:none">Success, Defaults Set!</p>
		        <p class="kt_default_set_fail kt-ajax-notice" style="display:none">Failed, reload and try again</p>
		        <p>This will set your font and header style defaults you can change them after to whatever style you prefer.</p>
		    </div>
		      
		</div>
		<?php
	}
	add_action( 'admin_print_styles-appearance_page_kt_api_manager_dashboard', 'kt_childhold_getting_started_styles' );
	function kt_childhold_getting_started_styles() {
		wp_register_style( 'kt_childbold_startup-css', get_stylesheet_directory_uri() . '/admin/kt_getting_started.css', array(), 100, 'all' );
		wp_enqueue_style( 'kt_childbold_startup-css' );
		wp_register_script( 'kt_childbold_startup-js', get_stylesheet_directory_uri() . '/admin/kt_getting_started.js', array(), 100, true );
		wp_enqueue_script( 'kt_childbold_startup-js' );
	}
	add_action( 'wp_ajax_kt_set_bold_defaults', 'kt_set_bold_defaults_ajax' );
	function kt_set_bold_defaults_ajax() {
		$options = get_option( 'virtue_premium' );
		if ( ! is_array( $options ) ) {
			$options = array();
		}
		$options['boxed_layout'] = 'wide';
		$options['header_style'] = 'standard';
		$options['sticky_header'] = '0';
		$options['logo_layout'] = 'logocenter';
		$options['primary_sticky'] = '1';
		$options['font_logo_style']['font-family'] = 'Ubuntu';
		$options['font_tagline_style']['font-family'] = 'Ubuntu';
		$options['menu_margin_top'] = '0';
		$options['menu_margin_bottom'] = '0';
		$options['topbar'] = '0';
		$options['product_shop_layout'] = '3';
		$options['font_shop_title']['font-family'] = 'Ubuntu';
		$options['font_shop_title']['font-style'] = '';
		$options['font_shop_title']['font-weight'] = '400';
		$options['post_summery_default'] = 'img_landscape';
		if(empty($options['primary_color']) ) {
			$options['primary_color'] = '#1468e5';
		}
		if(empty($options['primary20_color']) ) {
			$options['primary20_color'] = '#3078e5';
		}
		// H1
		$options['font_h1']['font-family'] = 'Ubuntu';
		$options['font_h1']['google'] = 'true';
		$options['font_h1']['font-style'] = '';
		$options['font_h1']['font-weight'] = '400';
		$options['font_h1']['font-size'] = '48px';
		$options['font_h1']['line-height'] = '50px';
		$options['font_h1']['subsets'] = 'latin';
		$options['font_h1']['color'] = '#333333';
		// H2
		$options['font_h2']['font-family'] = 'Ubuntu';
		$options['font_h2']['google'] = 'true';
		$options['font_h2']['font-style'] = '';
		$options['font_h2']['font-weight'] = '400';
		$options['font_h2']['font-size'] = '44px';
		$options['font_h2']['line-height'] = '45px';
		$options['font_h2']['subsets'] = 'latin';
		$options['font_h2']['color'] = '#333333';
		// H3
		$options['font_h3']['font-family'] = 'Ubuntu';
		$options['font_h3']['google'] = 'true';
		$options['font_h3']['font-style'] = '';
		$options['font_h3']['font-weight'] = '400';
		$options['font_h3']['font-size'] = '36px';
		$options['font_h3']['line-height'] = '40px';
		$options['font_h3']['subsets'] = 'latin';
		$options['font_h3']['color'] = '#333';
		// H4
		$options['font_h4']['font-family'] = 'Ubuntu';
		$options['font_h4']['google'] = 'true';
		$options['font_h4']['font-style'] = '';
		$options['font_h4']['font-weight'] = '400';
		$options['font_h4']['font-size'] = '28px';
		$options['font_h4']['line-height'] = '40px';
		$options['font_h4']['subsets'] = 'latin';
		$options['font_h4']['color'] = '#333';
		// H5
		$options['font_h5']['font-family'] = 'Ubuntu';
		$options['font_h5']['google'] = 'true';
		$options['font_h5']['font-style'] = '';
		$options['font_h5']['font-weight'] = '500';
		$options['font_h5']['font-size'] = '22px';
		$options['font_h5']['line-height'] = '24px';
		$options['font_h5']['subsets'] = 'latin';
		$options['font_h5']['color'] = '#333';
		// BODY
		$options['font_p']['font-family'] = 'Ubuntu';
		$options['font_p']['google'] = 'true';
		$options['font_p']['font-style'] = '';
		$options['font_p']['font-weight'] = '300';
		$options['font_p']['font-size'] = '18px';
		$options['font_p']['line-height'] = '28px';
		$options['font_p']['subsets'] = 'latin';
		// Primary MENU
		$options['font_primary_menu']['font-family'] = 'Ubuntu';
		$options['font_primary_menu']['google'] = 'true';
		$options['font_primary_menu']['font-style'] = '';
		$options['font_primary_menu']['font-weight'] = '500';
		$options['font_primary_menu']['font-size'] = '16px';
		$options['font_primary_menu']['subsets'] = 'latin';
		$options['font_primary_menu']['line-height'] = '40px';
		// SECONDARY MENU
		$options['font_secondary_menu']['font-family'] = 'Ubuntu';
		$options['font_secondary_menu']['google'] = 'true';
		$options['font_secondary_menu']['font-style'] = '';
		$options['font_secondary_menu']['font-weight'] = '500';
		$options['font_secondary_menu']['subsets'] = 'latin';
		// DROP DOWN COLORS
		$options['dropdown_font_color'] = '#cccccc';
		$options['dropdown_background_color'] = '#333333';
		$options['dropdown_border_color'] = '#333333';
		$options['dropdown_font_hover_color'] = '#ffffff';
		// MOBILE MENU
		$options['font_mobile_menu']['font-family'] = 'Ubuntu';
		$options['font_mobile_menu']['google'] = 'true';
		$options['font_mobile_menu']['font-style'] = '';
		$options['font_mobile_menu']['font-weight'] = '500';
		$options['font_mobile_menu']['font-size'] = '16px';
		$options['font_mobile_menu']['line-height'] = '20px';
		$options['font_mobile_menu']['subsets'] = 'latin';
		// Update
		update_option( 'virtue_premium', $options );

		exit;
	}
}
add_action( 'init', 'v_bold_startup' );
require_once locate_template( '/admin/kt-theme-updates.php' );
