<?php
define( 'LAYOUT_PATH', get_template_directory() . '/assets/css/skins/' );
define( 'OPTIONS_PATH', get_template_directory_uri() . '/themeoptions/options_assets/' );

function pinnacle_all_rev_sliders_in_array() {
	if ( class_exists( 'RevSlider' ) && is_admin() ) {
		$theslider      = new RevSlider();
		$arrSliders = $theslider->getArrSliders();
		$arrA   = array();
		$arrT   = array();
		foreach ( $arrSliders as $slider ) {
			$arrA[] = $slider->getAlias();
			$arrT[] = $slider->getTitle();
		}
		if ( ! empty( $arrT ) ) {
			$result = array_combine( $arrA, $arrT );
		} else {
			$result = '';
		}
		return $result;
	}
}
	$of_revolution = array();
	$of_rev = pinnacle_all_rev_sliders_in_array();
if ( ! empty( $of_rev ) ) {
	$of_revolution = $of_rev;
} else {
	$of_revolution = '';
}
	$alt_stylesheet_path = apply_filters( 'kt_skin_style_path', LAYOUT_PATH );
	$alt_stylesheets = array();
if ( is_dir( $alt_stylesheet_path ) ) {
	if ( $alt_stylesheet_dir = opendir( $alt_stylesheet_path ) ) {
		while ( ( $alt_stylesheet_file = readdir( $alt_stylesheet_dir ) ) !== false ) {
			if ( stristr( $alt_stylesheet_file, '.css' ) !== false ) {
				$alt_stylesheets[ $alt_stylesheet_file ] = $alt_stylesheet_file;
			}
		}
		closedir( $alt_stylesheet_dir );
	}
}
function kad_all_ksp_in_array() {
	if ( class_exists( 'KadenceSliderPro_Output' ) && is_admin() ) {
		global $wpdb;
		$sliders = $wpdb->get_results( 'SELECT * FROM ' . $wpdb->prefix . 'ksp_sliders' );
		if ( ! empty( $sliders ) ) {
			$name  = array();
			$id     = array();
			foreach ( $sliders as $slider ) {
				$name[] = $slider->name;
				$id[]   = $slider->id;
			}
			if ( ! empty( $id ) ) {
				$result = array_combine( $id, $name );
			} else {
				$result = '';
			}
			return $result;
		}
	}
}
	$of_ksp = array();
	$of_ksp_test = kad_all_ksp_in_array();
if ( ! empty( $of_ksp_test ) ) {
	$of_ksp = $of_ksp_test;
} else {
	$of_ksp = '';
}
/*
--- BEGIN Config ----
*/

if ( ! class_exists( 'Redux' ) ) {
		return;
}
// This is your option name where all the Redux data is stored.
	$opt_name = 'pinnacle';

	// If Redux is running as a plugin, this will remove the demo notice and links
	add_action( 'redux/loaded', 'kadence_remove_demo' );


/**
	 * ---> SET ARGUMENTS
	 * All the possible arguments for Redux.
	 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
	 * */

	$theme = wp_get_theme(); // For use with some settings. Not necessary.
	$args = array(
		'opt_name'             => $opt_name,
		'display_name'         => $theme->get( 'Name' ),
		'display_version'      => $theme->get( 'Version' ),
		'menu_type'            => 'menu',
		'allow_sub_menu'       => true,
		'menu_title'           => __( 'Theme Options', 'pinnacle' ),
		'page_title'           => __( 'Theme Options', 'pinnacle' ),
		'google_api_key'       => 'AIzaSyALkgUvb8LFAmrsczX56ZGJx-PPPpwMid0',
		'google_update_weekly' => false,
		'async_typography'     => false,
		'admin_bar'            => true,
		'admin_bar_icon'       => 'dashicons-admin-generic',
		'admin_bar_priority'   => 50,
		'dev_mode'             => false,
		'use_cdn'              => false,
		'update_notice'        => false,
		'customizer'           => true,
		'page_priority'        => 50,
		'forced_dev_mode_off'  => true,
		'page_permissions'     => 'manage_options',
		'menu_icon'            => '',
		'page_icon'            => 'kad_logo_header',
		'page_slug'            => 'ktoptions',
		'ajax_save'            => true,
		'default_show'         => false,
		'default_mark'         => '',
		'footer_credit' => __( 'Thank you for using the Pinnacle Theme by <a href="https://kadencewp.com/" target="_blank">Kadence WP</a>.', 'pinnacle' ),
		'hints'                => array(
			'icon'          => 'kt-icon-question',
			'icon_position' => 'right',
			'icon_color'    => '#444',
			'icon_size'     => 'normal',
			'tip_style'     => array(
				'color'   => 'dark',
				'shadow'  => true,
				'rounded' => false,
				'style'   => '',
			),
			'tip_position'  => array(
				'my' => 'top left',
				'at' => 'bottom right',
			),
			'tip_effect'    => array(
				'show' => array(
					'effect'   => 'slide',
					'duration' => '500',
					'event'    => 'mouseover',
				),
				'hide' => array(
					'effect'   => 'slide',
					'duration' => '500',
					'event'    => 'click mouseleave',
				),
			),
		),
	);

	// SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
	$args['share_icons'][] = array(
        'url' => 'https://www.facebook.com/KadenceWP',
        'title' => 'Follow Kadence WP on Facebook', 
        'icon' => 'dashicons dashicons-facebook',
    );
    $args['share_icons'][] = array(
        'url' => 'https://www.twitter.com/KadenceWP',
        'title' => 'Follow Kadence WP on Twitter', 
        'icon' => 'dashicons dashicons-twitter',
    );
	$args['share_icons'][] = array(
	    'url' => 'https://www.instagram.com/KadenceWP',
	    'title' => 'Follow Kadence WP on Instagram', 
	    'icon' => 'dashicons dashicons-format-image',
	);
	$args['share_icons'][] = array(
	    'url' => 'http://www.youtube.com/c/KadenceWP',
	    'title' => 'Follow Kadence WP on YouTube', 
	    'icon' => 'dashicons dashicons-video-alt3',
	);


	// Add content after the form.
	// $args['footer_text'] = '';

	Redux::setArgs( $opt_name, $args );


	// -> START Basic Fields

	Redux::setSection(
		$opt_name,
		array(
			'title' => __( 'Site Header', 'pinnacle' ),
			'header' => '',
			'id' => 'site_header',
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Welcome to Pinnacle Theme Options', 'pinnacle' ) . '</h3>
                                    <p>' . __( 'This theme was developed by', 'pinnacle' ) . ' <a href="https://kadencewp.com/" target="_blank">Kadence WP</a></p>
                                    <p>' . __( 'For theme documentation visit', 'pinnacle' ) . ': <a href="http://docs.kadencethemes.com/pinnacle-premium/" target="_blank">docs.kadencethemes.com/pinnacle-premium/</a>
                                    <br />
                                    ' . __( 'For support please visit', 'pinnacle' ) . ': <a href="https://kadencewp.com/support/" target="_blank">kadencewp.com/support/</a></p></div>',
			'icon_class' => 'icon-large',
			'icon' => 'kt-icon-screen',
			'fields' => array(
				array(
					'id' => 'header_style',
					'type' => 'select',
					'title' => __( 'Header Style', 'pinnacle' ),
					'options' => array(
						'default' => __( 'default', 'pinnacle' ),
						'center' => __( 'Center Logo with menu on sides', 'pinnacle' ),
					),
					'default' => 'default',
					'customizer' => true,
					'width' => 'width:60%',
				),
				array(
					'id' => 'info_header_center',
					'type' => 'info',
					'customizer' => false,
					'desc' => __( '*Note the left menu is the left menu and the right menu is the right menu. The header is set with two menus.', 'pinnacle' ),
					'required' => array( 'header_style', '=', 'center' ),
				),
				array(
					'id' => 'header_height',
					'type' => 'slider',
					'title' => __( 'Header Height', 'pinnacle' ),
					'default'       => '120',
					'min'       => '30',
					'step'      => '2',
					'max'       => '400',
					'customizer' => true,
				),
				array(
					'id' => 'sticky_header',
					'type' => 'switch',
					'title' => __( 'Enable Sticky Header?', 'pinnacle' ),
					'subtitle' => __( 'Choose to enable fixed header. Automatically off for mobile', 'pinnacle' ),
					'default'       => 1,
					'customizer' => true,
					'hint' => array(
						'title'   => __( 'Choose to enable fixed header.', 'pinnacle' ),
						'content' => __( 'Automatically off for mobile', 'pinnacle' ),
					),
				),
				array(
					'id' => 'm_sticky_header',
					'type' => 'switch',
					'title' => __( 'Enable Mobile Sticky Header?', 'pinnacle' ),
					'subtitle' => __( 'Choose to enable fixed header for mobile', 'pinnacle' ),
					'default' => 0,
					'customizer' => true,
					'hint' => array(
						'title'   => __( 'Choose to enable fixed header for mobile.', 'pinnacle' ),
					),
				),

				array(
					'id' => 'shrink_header',
					'type' => 'switch',
					'title' => __( 'Enable Shrink Header?', 'pinnacle' ),
					'subtitle' => __( 'Choose to enable a shrinking sticky header.', 'pinnacle' ),
					'default' => 0,
					'customizer' => true,
					'hint' => array(
						'title'   => __( 'Choose to enable a shrinking sticky header.', 'pinnacle' ),
					),
				),
				array(
					'id' => 'transparentheader',
					'type' => 'info',
					'desc' => __( 'Transparent Header', 'pinnacle' ),
					'customizer' => true,
				),
				array(
					'id' => 'pagetitle_intoheader',
					'type' => 'switch',
					'customizer' => true,
					'title' => __( 'Enable Transparent header until scrolled?', 'pinnacle' ),
					'subtitle' => __( 'This will make the page header background fill to the top of the page. (Home page set on home slider tab)', 'pinnacle' ),
					'default' => 1,
					'hint' => array(
						'title'   => __( 'This will make the page header background fill to the top of the page.', 'pinnacle' ),
						'content' => __( '(Home page set on home slider tab)', 'pinnacle' ),
					),
				),
				array(
					'id' => 'th_header_menu_color',
					'type' => 'color',
					'title' => __( 'Menu Text Color (For Transparent Header)', 'pinnacle' ),
					'subtitle' => __( 'Choose the font color of the menu font while background is transparent.', 'pinnacle' ),
					'transparent' => false,
					'default' => '#ffffff',
					'validate' => 'color',
					'output'    => array( '.kad-primary-nav ul.sf-menu a', '.nav-trigger-case.collapsed .kad-navbtn' ),
					'customizer' => true,
					'hint' => array(
						'title'   => __( 'Choose the font color of the menu font while background is transparent.', 'pinnacle' ),
					),
				),
				array(
					'id' => 'th_header_border_color',
					'type' => 'color',
					'title' => __( 'Border Color (For Transparent Header)', 'pinnacle' ),
					'subtitle' => __( 'Choose the color of bottom border while background is transparent.', 'pinnacle' ),
					'transparent' => true,
					'default' => '',
					'validate' => 'color',
					'customizer' => true,
					'hint' => array(
						'title'   => __( 'Choose the color of bottom border while background is transparent.', 'pinnacle' ),
					),
				),
				array(
					'id' => 'th_header_logo_color',
					'type' => 'color',
					'title' => __( 'Site title font Color (For Transparent Header)', 'pinnacle' ),
					'subtitle' => __( 'Choose the font color for the logo while background is transparent.', 'pinnacle' ),
					'transparent' => false,
					'validate' => 'color',
					'default' => '#ffffff',
					'output'    => array( '.sticky-wrapper #logo a.brand, .trans-header #logo a.brand' ),
					'customizer' => true,
					'hint' => array(
						'title'   => __( 'Choose the font color for the logo while background is transparent.', 'pinnacle' ),
					),
				),
				array(
					'id' => 'th_x1_logo_upload',
					'type' => 'media',
					'url' => true,
					'customizer' => true,
					'title' => __( 'Logo (For Transparent Header)', 'pinnacle' ),
					'subtitle' => __( 'Upload your Logo.', 'pinnacle' ),
				),
				array(
					'id' => 'th_x2_logo_upload',
					'type' => 'media',
					'url' => true,
					'customizer' => true,
					'title' => __( '@2x Logo (For Transparent Header) ', 'pinnacle' ),
					'subtitle' => __( 'Should be twice the pixel size of your normal logo.', 'pinnacle' ),
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-trophy3',
			'icon_class' => 'icon-large',
			'id' => 'logo_options',
			'title' => __( 'Logo Options', 'pinnacle' ),
			'fields' => array(
				array(
					'id' => 'logo_container_width',
					'type' => 'select',
					'title' => __( 'Logo Container Width', 'pinnacle' ),
					'options' => array(
						'16' => __( '16%', 'pinnacle' ),
						'25' => __( '25%', 'pinnacle' ),
						'33' => __( '33%', 'pinnacle' ),
						'41' => __( '41%', 'pinnacle' ),
						'50' => __( '50%', 'pinnacle' ),
					),
					'default' => '33',
					'customizer' => true,
					'width' => 'width:60%',
				),
				array(
					'id' => 'x1_logo_upload',
					'type' => 'media',
					'url' => true,
					'customizer' => true,
					'title' => __( 'Logo', 'pinnacle' ),
					'subtitle' => __( 'Upload your Logo. If left blank theme will use site name.', 'pinnacle' ),
				),
				array(
					'id' => 'x2_logo_upload',
					'type' => 'media',
					'url' => true,
					'customizer' => true,
					'title' => __( 'Upload Your @2x Logo for Retina Screens', 'pinnacle' ),
					'subtitle' => __( 'Should be twice the pixel size of your normal logo.', 'pinnacle' ),
				),
				array(
					'id' => 'font_logo_style',
					'type' => 'typography',
					'title' => __( 'Sitename Logo Font', 'pinnacle' ),
					// 'compiler'=>true, // Use if you want to hook in your own CSS compiler
					'font-family' => true,
					'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
					'font-backup' => false, // Select a backup non-google font in addition to a google font
					'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
					'subsets' => true, // Only appears if google is true and subsets not set to false
					'font-size' => true,
					'line-height' => false,
					'text-align' => false,
					'color' => true,
					'preview' => true,
					'customizer' => true,
					'output' => array( '.is-sticky header #logo a.brand', '.logofont', '.none-trans-header header #logo a.brand', 'header #logo a.brand' ),
					'subtitle' => __( "Choose size and style your sitename, if you don't use an image logo.", 'pinnacle' ),
					'default' => array(
						'font-family' => 'Raleway',
						'color' => '#444444',
						'font-style' => '400',
						'font-size' => '32px',
					),
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-paintbrush',
			'icon_class' => 'icon-large',
			'id' => 'page_title',
			'title' => __( 'Page Title', 'pinnacle' ),
			'fields' => array(
				array(
					'id' => 'default_showpagetitle',
					'type' => 'switch',
					'customizer' => true,
					'title' => __( 'Show the page title by default', 'pinnacle' ),
					'subtitle' => __( 'This can be overridden on each page.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id'        => 'pageheader_background',
					'type'      => 'background',
					'output'    => array( '.titleclass' ),
					'customizer' => true,
					'title'     => __( 'Page Header Default Background', 'pinnacle' ),
				),
				array(
					'id' => 'pagetitle_overlay',
					'type' => 'color',
					'title' => __( 'Page Header background Overlay color', 'pinnacle' ),
					'subtitle' => __( 'Note this will apply to all page title areas.', 'pinnacle' ),
					'validate' => 'color',
					'output'    => array( 'background' => '.titleclass .header-color-overlay' ),
					'customizer' => true,
					'hint' => array(
						'title'   => __( 'Note this will apply to all page title areas.', 'pinnacle' ),
					),
				),
				array(
					'id' => 'header_overlay_background_transparency',
					'type' => 'select',
					'customizer' => true,
					'title' => __( 'Page Header background Overlay Opacity', 'pinnacle' ),
					'options' => array(
						'1' => '1',
						'0.9' => '0.9',
						'0.8' => '0.8',
						'0.7' => '0.7',
						'0.6' => '0.6',
						'0.5' => '0.5',
						'0.4' => '0.4',
						'0.3' => '0.3',
						'0.2' => '0.2',
						'0.1' => '0.1',
						'0' => '0',
					),
					'default' => '0.8',
					'width' => 'width:60%',
				),
				array(
					'id' => 'pagetitle_color',
					'type' => 'color',
					'title' => __( 'Page Title Color', 'pinnacle' ),
					'subtitle' => __( 'Choose the default pagetitle color for your site.', 'pinnacle' ),
					'transparent' => false,
					'validate' => 'color',
					'default' => '#ffffff',
					'output'    => array( '.titleclass h1' ),
					'customizer' => true,
					'hint' => array(
						'title'   => __( 'Choose the default pagetitle color for your site.', 'pinnacle' ),
					),
				),
				array(
					'id' => 'pagesubtitle_color',
					'type' => 'color',
					'title' => __( 'Page Subtitle Color', 'pinnacle' ),
					'subtitle' => __( 'Choose the default subtitle color for your site.', 'pinnacle' ),
					'transparent' => false,
					'validate' => 'color',
					'default' => '#ffffff',
					'output'    => array( '.titleclass .subtitle' ),
					'customizer' => true,
					'hint' => array(
						'title'   => __( 'Choose the default subtitle color for your site.', 'pinnacle' ),
					),
				),
				array(
					'id' => 'pagetitle_align',
					'type' => 'select',
					'customizer' => true,
					'title' => __( 'Page Title Align', 'pinnacle' ),
					'options' => array(
						'center' => __( 'Center', 'pinnacle' ),
						'left' => __( 'Left', 'pinnacle' ),
						'right' => __( 'Right', 'pinnacle' ),
					),
					'default' => 'center',
					'width' => 'width:60%',
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-page-break',
			'icon_class' => 'icon-large',
			'title' => __( 'Footer', 'pinnacle' ),
			'id' => 'footer',
			'fields' => array(
				array(
					'id' => 'info_calltoaction_sitewide',
					'type' => 'info',
					'customizer' => false,
					'desc' => __( 'Sitewide Footer Call To Action', 'pinnacle' ),
				),
				array(
					'id' => 'sitewide_calltoaction',
					'type' => 'switch',
					'customizer' => false,
					'title' => __( 'Use Sitewide Footer Call to Action', 'pinnacle' ),
					'default'       => 0,
				),
				array(
					'id' => 'sitewide_action_text',
					'type' => 'text',
					'customizer' => false,
					'title' => __( 'Call to Action Text', 'pinnacle' ),
					'required' => array( 'sitewide_calltoaction', '=', '1' ),
				),
				array(
					'id' => 'sitewide_action_color',
					'type' => 'color',
					'customizer' => false,
					'title' => __( 'Call to Action Text Color', 'pinnacle' ),
					'default' => '',
					'validate' => 'color',
					'transparent' => false,
					'output' => array( 'color' => '.kad-call-sitewide-title-case h2.kad-call-title' ),
					'required' => array( 'sitewide_calltoaction', '=', '1' ),
				),
				array(
					'id' => 'sitewide_action_text_btn',
					'type' => 'text',
					'customizer' => false,
					'title' => __( 'Call to Action Button Text', 'pinnacle' ),
					'subtitle' => __( 'e.g. = Read More', 'pinnacle' ),
					'required' => array( 'sitewide_calltoaction', '=', '1' ),
				),
				array(
					'id' => 'sitewide_action_link',
					'type' => 'text',
					'customizer' => false,
					'title' => __( 'Call to Action Button Link', 'pinnacle' ),
					'required' => array( 'sitewide_calltoaction', '=', '1' ),
				),
				array(
					'id' => 'sitewide_action_btn_color',
					'type' => 'color',
					'customizer' => false,
					'title' => __( 'Button Text Color', 'pinnacle' ),
					'default' => '',
					'validate' => 'color',
					'transparent' => false,
					'output' => array( 'color' => '.kad-call-sitewide-button-case a.kad-btn-primary' ),
					'required' => array( 'sitewide_calltoaction', '=', '1' ),
				),
				array(
					'id' => 'sitewide_action_bg_color',
					'type' => 'color',
					'customizer' => false,
					'title' => __( 'Button Background Color', 'pinnacle' ),
					'default' => '',
					'validate' => 'color',
					'output' => array( 'background-color' => '.kad-call-sitewide-button-case a.kad-btn-primary' ),
					'required' => array( 'sitewide_calltoaction', '=', '1' ),
				),
				array(
					'id' => 'sitewide_action_btn_color_hover',
					'type' => 'color',
					'title' => __( 'Button Hover Text Color', 'pinnacle' ),
					'default' => '',
					'validate' => 'color',
					'transparent' => false,
					'customizer' => false,
					'output' => array( 'color' => '.kad-call-sitewide-button-case a.kad-btn-primary:hover' ),
					'required' => array( 'sitewide_calltoaction', '=', '1' ),
				),
				array(
					'id' => 'sitewide_action_bg_color_hover',
					'type' => 'color',
					'title' => __( 'Button Hover Background Color', 'pinnacle' ),
					'default' => '',
					'validate' => 'color',
					'customizer' => false,
					'output' => array( 'background-color' => '.kad-call-sitewide-button-case a.kad-btn-primary:hover' ),
					'required' => array( 'sitewide_calltoaction', '=', '1' ),
				),
				array(
					'id' => 'sitewide_action_padding',
					'type' => 'slider',
					'title' => __( 'Call to action top and bottom padding.', 'pinnacle' ),
					'default'       => '20',
					'min'       => '4',
					'customizer' => false,
					'step'      => '2',
					'max'       => '80',
					'required' => array( 'sitewide_calltoaction', '=', '1' ),
				),
				array(
					'id'        => 'sitewide_action_background',
					'type'      => 'background',
					'customizer' => false,
					'output'    => array( '.kt-call-sitewide-to-action' ),
					'title'     => __( 'Call to action background', 'pinnacle' ),
					'required' => array( 'sitewide_calltoaction', '=', '1' ),
				),
				array(
					'id' => 'info_shortcode_sitewide',
					'type' => 'info',
					'customizer' => false,
					'desc' => __( 'Sitewide Footer Shortcode', 'pinnacle' ),
				),
				array(
					'id' => 'sitewide_footer_shortcode_input',
					'type' => 'text',
					'customizer' => false,
					'title' => __( 'Add shortcode here for output just above footer.', 'pinnacle' ),
				),
				array(
					'id' => 'info_footer_layout',
					'type' => 'info',
					'desc' => __( 'Footer Layout', 'pinnacle' ),
				),
				array(
					'id' => 'footer_layout',
					'type' => 'image_select',
					'title' => __( 'Footer Widget Layout', 'pinnacle' ),
					'subtitle' => __( 'Select how many columns for footer widgets', 'pinnacle' ),
					'customizer' => true,
					'options' => array(
						'fourc' => array(
							'alt' => 'Four Column Layout',
							'img' => OPTIONS_PATH . 'img/footer-widgets-4.png',
						),
						'threec' => array(
							'alt' => 'Three Column Layout',
							'img' => OPTIONS_PATH . 'img/footer-widgets-3.png',
						),
						'twoc' => array(
							'alt' => 'Two Column Layout',
							'img' => OPTIONS_PATH . 'img/footer-widgets-2.png',
						),
						'five' => array(
							'alt' => 'Two Rows, One Column, Two Columns Layout',
							'img' => OPTIONS_PATH . 'img/footer-widgets-5.png',
						),
						'six' => array(
							'alt' => 'Two Rows, One Column Layout',
							'img' => OPTIONS_PATH . 'img/footer-widgets-6.png',
						),
					),
					'default' => 'fourc',
				),

			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-cog',
			'icon_class' => 'icon-large',
			'title' => __( 'Topbar Settings', 'pinnacle' ),
			'id' => 'topbar_settings',
			'fields' => array(
				array(
					'id' => 'topbar',
					'type' => 'switch',
					'title' => __( 'Use Topbar?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide topbar', 'pinnacle' ),
					'customizer' => true,
					'default'       => 0,
				),
				array(
					'id' => 'topbar_height',
					'type' => 'slider',
					'title' => __( 'Topbar Height', 'pinnacle' ),
					'default'       => '30',
					'min'       => '4',
					'step'      => '2',
					'max'       => '100',
					'customizer' => true,
				),
				array(
					'id' => 'topbar_mobile_hide',
					'type' => 'switch',
					'customizer' => false,
					'title' => __( 'Hide on mobile?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide topbar on mobile', 'pinnacle' ),
					'default'       => 1,
				),
				array(
					'id' => 'topbar_icons',
					'customizer' => false,
					'type' => 'switch',
					'title' => __( 'Use Topbar Icon Menu?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide topbar icon Menu', 'pinnacle' ),
					'default'       => 0,
				),
				array(
					'id' => 'topbar_icon_menu',
					'type' => 'kad_icons',
					'customizer' => false,
					'title' => __( 'Topbar Icon Menu', 'pinnacle' ),
					'subtitle' => __( 'Choose your icons for the topbar icon menu.', 'pinnacle' ),
				),
				array(
					'id' => 'topbar_iconmenu_fontsize',
					'type' => 'slider',
					'title' => __( 'Icon menu font size', 'pinnacle' ),
					'default'       => '14',
					'min'       => '8',
					'customizer' => false,
					'step'      => '1',
					'max'       => '36',
				),
				array(
					'id' => 'show_cartcount',
					'type' => 'switch',
					'title' => __( 'Show Cart total in topbar?', 'pinnacle' ),
					'subtitle' => __( 'This only works if using woocommerce', 'pinnacle' ),
					'default'       => 1,
				),
				array(
					'id' => 'topbar_search',
					'type' => 'switch',
					'title' => __( 'Display Search in Topbar?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide search in topbar', 'pinnacle' ),
					'default'       => 1,
				),
				array(
					'id' => 'topbar_search_products',
					'type' => 'switch',
					'title' => __( 'Make topbar Search results only products?', 'pinnacle' ),
					'subtitle' => __( 'This will change the topbar search to a woocommerce search.', 'pinnacle' ),
					'default'       => 0,
				),
				array(
					'id' => 'topbar_widget',
					'type' => 'switch',
					'title' => __( 'Enable widget area in left of Topbar?', 'pinnacle' ),
					'default'       => 0,
				),
				array(
					'id' => 'topbar_layout',
					'type' => 'switch',
					'title' => __( 'Topbar Layout Switch', 'pinnacle' ),
					'subtitle' => __( 'This moves the left items to the right and right items to the left.', 'pinnacle' ),
					'default'       => 0,
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-images',
			'icon_class' => 'icon-large',
			'customizer' => false,
			'id' => 'home_slider',
			'title' => __( 'Home Slider', 'pinnacle' ),
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Home Page Slider Options', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'hs_behindheader',
					'type' => 'switch',
					'title' => __( 'Place behind Header', 'pinnacle' ),
					'subtitle' => __( 'This enabled the transparent header on the home page.', 'pinnacle' ),
					'default' => 1,
					'customizer' => true,
				),
				array(
					'id' => 'choose_home_header',
					'type' => 'select',
					'customizer' => true,
					'title' => __( 'Choose a Home Image Slider', 'pinnacle' ),
					'subtitle' => __( "If you don't want an image slider on your home page choose none.", 'pinnacle' ),
					'options' => array(
						'none' => __( 'None', 'pinnacle' ),
						'pagetitle' => __( 'Page Title', 'pinnacle' ),
						'flex' => __( 'Flex Slider', 'pinnacle' ),
						'carousel' => __( 'Carousel Slider', 'pinnacle' ),
						'imgcarousel' => __( 'Image Carousel', 'pinnacle' ),
						'rev' => __( 'Revolution Slider', 'pinnacle' ),
						'cyclone' => __( 'Shortcode Entry', 'pinnacle' ),
						'ksp' => __( 'Kadence Slider Pro', 'pinnacle' ),
						'ktslider' => __( 'Kadence Slider Legacy', 'pinnacle' ),
						'latest' => __( 'Latest Posts', 'pinnacle' ),
						'video' => __( 'Video', 'pinnacle' ),
					),
					'default' => 'pagetitle',
					'width' => 'width:60%',
				),
				array(
					'id' => 'choose_latest_slider_style',
					'type' => 'select',
					'title' => __( 'Latest Posts Slider Style', 'pinnacle' ),
					'subtitle' => __( 'Choose how you want the latest post slider to look', 'pinnacle' ),
					'options' => array(
						'flex' => __( 'Post Slider (Flex)', 'pinnacle' ),
						'carousel' => __( 'Post Carousel', 'pinnacle' ),
					),
					'default' => 'flex',
					'width' => 'width:60%',
					'required' => array( 'choose_home_header', '=', 'latest' ),
				),
				array(
					'id' => 'latest_carousel_style',
					'type' => 'select',
					'title' => __( 'Carousel Image Size', 'pinnacle' ),
					'subtitle' => __( 'Choose the image size for the full width carousel', 'pinnacle' ),
					'options' => array(
						'3' => __( 'Medium', 'pinnacle' ),
						'2' => __( 'Large', 'pinnacle' ),
						'4' => __( 'Small', 'pinnacle' ),
					),
					'default' => '3',
					'width' => 'width:60%',
					'required' => array( 'choose_latest_slider_style', '=', 'carousel' ),
				),
				array(
					'id' => 'home_page_title',
					'type' => 'textarea',
					'title' => __( 'Home Page Title', 'pinnacle' ),
					'validate' => 'html',
					'default' => 'Welcome to [site-name]',
					'required' => array( 'choose_home_header', '=', 'pagetitle' ),
				),
				array(
					'id' => 'home_page_sub_title',
					'type' => 'textarea',
					'title' => __( 'Home Page SubTitle', 'pinnacle' ),
					'subtitle' => __( 'optional text below home page title', 'pinnacle' ),
					'validate' => 'html',
					'default' => '[site-tagline]',
					'required' => array( 'choose_home_header', '=', 'pagetitle' ),
				),
				array(
					'id' => 'home_page_title_ptop',
					'type' => 'slider',
					'title' => __( 'Home Page Title Padding Top', 'pinnacle' ),
					'default'       => '110',
					'min'       => '5',
					'step'      => '5',
					'max'       => '300',
					'required' => array( 'choose_home_header', '=', 'pagetitle' ),
				),
				array(
					'id' => 'home_page_title_pbottom',
					'type' => 'slider',
					'title' => __( 'Home Page Title Padding Bottom', 'pinnacle' ),
					'default'       => '110',
					'min'       => '5',
					'step'      => '5',
					'max'       => '300',
					'required' => array( 'choose_home_header', '=', 'pagetitle' ),
				),
				array(
					'id'        => 'home_pagetitle_background',
					'type'      => 'background',
					'required' => array( 'choose_home_header', '=', 'pagetitle' ),
				),
				array(
					'id' => 'rev_slider',
					'type' => 'select',
					'title' => __( 'If Revolution Slider', 'pinnacle' ),
					'subtitle' => __( 'Choose your Revolution Slider Here', 'pinnacle' ),
					'options' => $of_revolution,
					'default' => 'select',
					'width' => 'width:60%',
					'required' => array( 'choose_home_header', '=', 'rev' ),
				),
				array(
					'id' => 'ksp_slider',
					'type' => 'select',
					'title' => __( 'If Kadence Slider Pro Slider', 'pinnacle' ),
					'subtitle' => __( 'Choose your Kadence Slider here', 'pinnacle' ),
					'options' => $of_ksp,
					'default' => 'select',
					'width' => 'width:60%',
					'required' => array( 'choose_home_header', '=', 'ksp' ),
				),
				array(
					'id' => 'kt_slider',
					'type' => 'select',
					'title' => __( 'If Kadence Slider Legacy', 'pinnacle' ),
					'subtitle' => __( 'Choose your Kadence Slider here', 'pinnacle' ),
					'data' => 'posts',
					'args' => array(
						'post_type' => 'kadslider',
						'posts_per_page' => -1,
					),
					'default' => 'select',
					'width' => 'width:60%',
					'required' => array( 'choose_home_header', '=', 'ktslider' ),
				),
				array(
					'id' => 'header_slider_arrow',
					'type' => 'switch',
					'title' => __( 'Add arrow at the bottom of slider', 'pinnacle' ),
					'subtitle' => __( 'This adds a little arrow link that scrolls down into the content', 'pinnacle' ),
					'default'       => 0,
					'required' => array( 'choose_home_header', '=', array( 'rev', 'ktslider', 'ksp', 'cyclone' ) ),
				),
				array(
					'id' => 'home_cyclone_slider',
					'type' => 'text',
					'title' => __( 'If Cyclone Slider or using any shortcode', 'pinnacle' ),
					'subtitle' => __( 'Paste shortcode here', 'pinnacle' ),
					'required' => array( 'choose_home_header', '=', 'cyclone' ),
				),
				array(
					'id' => 'home_slider',
					'type' => 'kad_slides',
					'title' => __( 'Slider Images', 'pinnacle' ),
					'subtitle' => __( 'Use large images for best results.', 'pinnacle' ),
					'required' => array( 'choose_home_header', '=', array( 'flex', 'carousel', 'imgcarousel' ) ),
				),
				array(
					'id' => 'slider_size',
					'type' => 'slider',
					'title' => __( 'Slider Max Height', 'pinnacle' ),
					'subtitle' => __( 'Note: does not work if images are smaller than max.', 'pinnacle' ),
					'default'       => '500',
					'min'       => '100',
					'step'      => '5',
					'max'       => '1600',
					'required' => array( 'choose_home_header', '=', array( 'flex', 'carousel', 'imgcarousel', 'latest' ) ),
				),
				array(
					'id' => 'slider_size_width',
					'type' => 'slider',
					'title' => __( 'Slider Max Width', 'pinnacle' ),
					'subtitle' => __( 'Note: does not work if images are smaller than max.', 'pinnacle' ),
					'default'       => '1140',
					'min'       => '600',
					'step'      => '5',
					'max'       => '2400',
					'required' => array( 'choose_home_header', '=', array( 'flex', 'carousel', 'latest' ) ),
				),
				array(
					'id' => 'slider_autoplay',
					'type' => 'switch',
					'title' => __( 'Auto Play?', 'pinnacle' ),
					'subtitle' => __( 'This determines if a slider automatically scrolls', 'pinnacle' ),
					'default'       => 1,
					'required' => array( 'choose_home_header', '=', array( 'flex', 'carousel', 'imgcarousel', 'latest' ) ),
				),
				array(
					'id' => 'slider_pausetime',
					'type' => 'slider',
					'title' => __( 'Slider Pause Time', 'pinnacle' ),
					'subtitle' => __( 'How long to pause on each slide, in milliseconds.', 'pinnacle' ),
					'default'       => '7000',
					'min'       => '3000',
					'step'      => '1000',
					'max'       => '12000',
					'required' => array( 'choose_home_header', '=', array( 'flex', 'carousel', 'imgcarousel', 'latest' ) ),
				),
				array(
					'id' => 'trans_type',
					'type' => 'select',
					'title' => __( 'Transition Type', 'pinnacle' ),
					'subtitle' => __( 'Choose a transition type', 'pinnacle' ),
					'options' => array(
						'fade' => __( 'Fade', 'pinnacle' ),
						'slide' => __( 'Slide', 'pinnacle' ),
					),
					'default' => 'fade',
					'required' => array( 'choose_home_header', '=', array( 'flex', 'latest' ) ),
				),
				array(
					'id' => 'slider_transtime',
					'type' => 'slider',
					'title' => __( 'Slider Transition Time', 'pinnacle' ),
					'subtitle' => __( 'How long for slide transitions, in milliseconds.', 'pinnacle' ),
					'default'       => '600',
					'min'       => '200',
					'step'      => '100',
					'max'       => '1200',
					'required' => array( 'choose_home_header', '=', array( 'flex', 'carousel', 'imgcarousel', 'latest' ) ),
				),
				array(
					'id' => 'slider_captions',
					'type' => 'switch',
					'title' => __( 'Show Captions?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide captions', 'pinnacle' ),
					'default'       => 0,
					'required' => array( 'choose_home_header', '=', array( 'flex', 'carousel' ) ),
				),
				array(
					'id' => 'video_embed',
					'type' => 'textarea',
					'title' => __( 'Video Embed Code', 'pinnacle' ),
					'subtitle' => __( 'If your using a video on the home page place video embed code here.', 'pinnacle' ),
					'default' => '',
					'required' => array( 'choose_home_header', '=', 'video' ),
				),
			),
		)
	);

	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-mobile2',
			'icon_class' => 'icon-large',
			'customizer' => false,
			'id' => 'home_mobile_slider',
			'title' => __( 'Home Mobile Slider', 'pinnacle' ),
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Create a more lightweight home slider for your mobile visitors.', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'mobile_switch',
					'type' => 'switch',
					'title' => __( 'Would you like to use this feature?', 'pinnacle' ),
					'subtitle' => __( 'Choose if you would like to show a different slider on your home page for your mobile visitors.', 'pinnacle' ),
					'default'       => 0,
				),
				array(
					'id' => 'mobile_tablet_show',
					'type' => 'switch',
					'title' => __( 'Show for tablet also?', 'pinnacle' ),
					'subtitle' => __( 'Choose if you would like to show the mobile slider for tablets also.', 'pinnacle' ),
					'default'       => 0,
					'required' => array( 'mobile_switch', '=', '1' ),
				),
				array(
					'id' => 'choose_mobile_slider',
					'type' => 'select',
					'title' => __( 'Choose a Slider for Mobile', 'pinnacle' ),
					'subtitle' => __( 'Choose which slider you would like to show for mobile viewers.', 'pinnacle' ),
					'options' => array(
						'none' => __( 'None', 'pinnacle' ),
						'flex' => __( 'Flex Slider', 'pinnacle' ),
						'carousel' => __( 'Carousel Slider', 'pinnacle' ),
						'rev' => __( 'Revolution Slider', 'pinnacle' ),
						'ksp' => __( 'Kadence Slider Pro', 'pinnacle' ),
						'ktslider' => __( 'Kadence Slider Legacy', 'pinnacle' ),
						'shortcode' => __( 'Shortcode Slider', 'pinnacle' ),
						'pagetitle' => __( 'Page Title', 'pinnacle' ),
						'video' => __( 'Video', 'pinnacle' ),
					),
					'default' => 'none',
					'width' => 'width:60%',
					'required' => array( 'mobile_switch', '=', '1' ),
				),
				array(
					'id' => 'm_home_page_title',
					'type' => 'textarea',
					'title' => __( 'Home Page Title', 'pinnacle' ),
					'validate' => 'html',
					'default' => 'Welcome to [site-name]',
					'required' => array( 'choose_mobile_slider', '=', 'pagetitle' ),
				),
				array(
					'id' => 'm_home_page_sub_title',
					'type' => 'textarea',
					'title' => __( 'Home Page SubTitle', 'pinnacle' ),
					'subtitle' => __( 'optional text below home page title', 'pinnacle' ),
					'validate' => 'html',
					'default' => '[site-tagline]',
					'required' => array( 'choose_mobile_slider', '=', 'pagetitle' ),
				),
				array(
					'id' => 'm_home_page_title_ptop',
					'type' => 'slider',
					'title' => __( 'Home Page Title Padding Top', 'pinnacle' ),
					'default'       => '35',
					'min'       => '5',
					'step'      => '5',
					'max'       => '200',
					'required' => array( 'choose_mobile_slider', '=', 'pagetitle' ),
				),
				array(
					'id' => 'm_home_page_title_pbottom',
					'type' => 'slider',
					'title' => __( 'Home Page Title Padding Bottom', 'pinnacle' ),
					'default'       => '35',
					'min'       => '5',
					'step'      => '5',
					'max'       => '200',
					'required' => array( 'choose_mobile_slider', '=', 'pagetitle' ),
				),
				array(
					'id'        => 'm_home_pagetitle_background',
					'type'      => 'background',
					'output'    => array( '.home_titleclass' ),
					'required' => array( 'choose_mobile_slider', '=', 'pagetitle' ),
				),
				array(
					'id' => 'mobile_rev_slider',
					'type' => 'select',
					'title' => __( 'If Revolution Slider', 'pinnacle' ),
					'subtitle' => __( 'Choose your Revolution Slider Here', 'pinnacle' ),
					'options' => $of_revolution,
					'default' => 'select',
					'width' => 'width:60%',
					'required' => array( 'choose_mobile_slider', '=', 'rev' ),
				),
				array(
					'id' => 'mobile_ksp_slider',
					'type' => 'select',
					'title' => __( 'If Kadence Slider Pro Slider', 'pinnacle' ),
					'subtitle' => __( 'Choose your Kadence Slider here', 'pinnacle' ),
					'options' => $of_ksp,
					'default' => 'select',
					'width' => 'width:60%',
					'required' => array( 'choose_mobile_slider', '=', 'ksp' ),
				),
				array(
					'id' => 'mobile_kt_slider',
					'type' => 'select',
					'title' => __( 'If Kadence Slider Legacy', 'pinnacle' ),
					'subtitle' => __( 'Choose your Kadence Slider Here', 'pinnacle' ),
					'data' => 'posts',
					'args' => array(
						'post_type' => 'kadslider',
						'posts_per_page' => -1,
					),
					'default' => 'select',
					'width' => 'width:60%',
					'required' => array( 'choose_mobile_slider', '=', 'ktslider' ),
				),
				array(
					'id' => 'mobile_cyclone_slider',
					'type' => 'text',
					'title' => __( 'If Cyclone Slider or using any shortcode', 'pinnacle' ),
					'subtitle' => __( 'Paste shortcode here', 'pinnacle' ),
					'required' => array( 'choose_mobile_slider', '=', 'shortcode' ),
				),
				array(
					'id' => 'mobile_slider_arrow',
					'type' => 'switch',
					'title' => __( 'Add arrow at the bottom of slider', 'pinnacle' ),
					'subtitle' => __( 'This adds a little arrow link that scrolls down into the content', 'pinnacle' ),
					'default'       => 0,
					'required' => array( 'choose_mobile_header', '=', array( 'rev', 'ktslider', 'cyclone' ) ),
				),
				array(
					'id' => 'home_mobile_slider',
					'type' => 'kad_slides',
					'title' => __( 'Slider Images', 'pinnacle' ),
					'subtitle' => __( 'Use large images for best results.', 'pinnacle' ),
					'required' => array( 'choose_mobile_slider', '=', array( 'flex', 'carousel' ) ),
				),
				array(
					'id' => 'mobile_slider_size',
					'type' => 'slider',
					'title' => __( 'Slider Max Height', 'pinnacle' ),
					'subtitle' => __( 'Note: does not work if images are smaller than max.', 'pinnacle' ),
					'default'       => '300',
					'min'       => '100',
					'step'      => '5',
					'max'       => '800',
					'required' => array( 'choose_mobile_slider', '=', array( 'flex', 'carousel', 'imgcarousel', 'latest' ) ),
				),
				array(
					'id' => 'mobile_slider_size_width',
					'type' => 'slider',
					'title' => __( 'Slider Max Width', 'pinnacle' ),
					'subtitle' => __( 'Note: does not work if images are smaller than max.', 'pinnacle' ),
					'default'       => '480',
					'min'       => '200',
					'step'      => '5',
					'max'       => '800',
					'required' => array( 'choose_mobile_slider', '=', array( 'flex', 'carousel', 'imgcarousel', 'latest' ) ),
				),
				array(
					'id' => 'mobile_slider_autoplay',
					'type' => 'switch',
					'title' => __( 'Auto Play?', 'pinnacle' ),
					'subtitle' => __( 'This determines if a slider automatically scrolls', 'pinnacle' ),
					'default'       => 1,
					'required' => array( 'choose_mobile_slider', '=', array( 'flex', 'carousel', 'imgcarousel', 'latest' ) ),
				),
				array(
					'id' => 'mobile_slider_pausetime',
					'type' => 'slider',
					'title' => __( 'Slider Pause Time', 'pinnacle' ),
					'subtitle' => __( 'How long to pause on each slide, in milliseconds.', 'pinnacle' ),
					'default'       => '7000',
					'min'       => '3000',
					'step'      => '1000',
					'max'       => '12000',
					'required' => array( 'choose_mobile_slider', '=', array( 'flex', 'carousel', 'imgcarousel', 'latest' ) ),
				),
				array(
					'id' => 'mobile_trans_type',
					'type' => 'select',
					'title' => __( 'Transition Type', 'pinnacle' ),
					'subtitle' => __( 'Choose a transition type', 'pinnacle' ),
					'options' => array(
						'fade' => __( 'Fade', 'pinnacle' ),
						'slide' => __( 'Slide', 'pinnacle' ),
					),
					'default' => 'fade',
					'required' => array( 'choose_mobile_slider', '=', array( 'flex', 'carousel', 'imgcarousel', 'latest' ) ),
				),
				array(
					'id' => 'mobile_slider_transtime',
					'type' => 'slider',
					'title' => __( 'Slider Transition Time', 'pinnacle' ),
					'subtitle' => __( 'How long for slide transitions, in milliseconds.', 'pinnacle' ),
					'default'       => '600',
					'min'       => '200',
					'step'      => '100',
					'max'       => '1200',
					'required' => array( 'choose_mobile_slider', '=', array( 'flex', 'carousel', 'imgcarousel', 'latest' ) ),
				),
				array(
					'id' => 'mobile_slider_captions',
					'type' => 'switch',
					'title' => __( 'Show Captions?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide captions', 'pinnacle' ),
					'default'       => 0,
					'required' => array( 'choose_mobile_slider', '=', array( 'flex', 'carousel', 'imgcarousel', 'latest' ) ),
				),
				array(
					'id' => 'mobile_video_embed',
					'type' => 'textarea',
					'title' => __( 'Video Embed Code', 'pinnacle' ),
					'subtitle' => __( 'If your using a video on the home page place video embed code here.', 'pinnacle' ),
					'default' => '',
					'required' => array( 'choose_mobile_slider', '=', 'video' ),
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-home2',
			'icon_class' => 'icon-large',
			'customizer' => false,
			'id' => 'home_layout',
			'title' => __( 'Home Layout', 'pinnacle' ),
			'desc' => '',
			'id' => 'home_layout',
			'fields' => array(
				array(
					'id' => 'home_sidebar_layout',
					'type' => 'image_select',
					'compiler' => false,
					'title' => __( 'Display a sidebar on the Home Page?', 'pinnacle' ),
					'subtitle' => __( 'This determines if there is a sidebar on the home page.', 'pinnacle' ),
					'options' => array(
						'full' => array(
							'alt' => 'Full Layout',
							'img' => OPTIONS_PATH . 'img/1col.png',
						),
						'sidebar' => array(
							'alt' => 'Sidebar Layout',
							'img' => OPTIONS_PATH . 'img/2cr.png',
						),
					),
					'default' => 'full',
				),
				array(
					'id' => 'home_sidebar',
					'type' => 'select',
					'title' => __( 'Choose a Sidebar for your Home Page', 'pinnacle' ),
					'data' => 'sidebars',
					'default' => 'sidebar-primary',
					'width' => 'width:60%',
				),
				array(
					'id' => 'homepage_layout',
					'type' => 'sorter',
					'title' => __( 'Homepage Layout Manager', 'pinnacle' ),
					'subtitle' => __( 'Organize how you want the layout to appear on the homepage', 'pinnacle' ),
					'options' => array(
						'disabled' => array(
							'block_two'   => __( 'Image Menu', 'pinnacle' ),
							'block_three' => __( 'Featured Products', 'pinnacle' ),
							'block_six'   => __( 'Portfolio Carousel', 'pinnacle' ),
							'block_seven' => __( 'Icon Menu', 'pinnacle' ),
							'block_one'   => __( 'Call to Action', 'pinnacle' ),
							'block_four'  => __( 'Page Content', 'pinnacle' ),
							'block_eight' => __( 'Portfolio Full', 'pinnacle' ),
							'block_nine'  => __( 'On Sale Products', 'pinnacle' ),
							'block_ten'   => __( 'Best Selling Products', 'pinnacle' ),
							'block_eleven' => __( 'Custom Carousel', 'pinnacle' ),
							'block_twelve' => __( 'Home Widget Area', 'pinnacle' ),
						),
						'enabled' => array(
							'block_five'  => __( 'Latest Blog Posts', 'pinnacle' ),
						),
					),
				),
				array(
					'id' => 'info_imagemenu_settings',
					'type' => 'info',
					'desc' => __( 'Home Image Menu', 'pinnacle' ),
				),
				array(
					'id' => 'home_image_menu',
					'type' => 'kad_slides',
					'title' => __( 'Image Menu', 'pinnacle' ),
					'subtitle' => __( 'Add images, descriptions, titles, and links', 'pinnacle' ),
				),
				array(
					'id' => 'home_image_menu_column',
					'type' => 'slider',
					'title' => __( 'Choose how many columns in each row', 'pinnacle' ),
					'default'       => '3',
					'min'       => '2',
					'step'      => '1',
					'max'       => '6',
				),
				array(
					'id' => 'img_menu_font_color',
					'type' => 'color',
					'title' => __( 'Font Color', 'pinnacle' ),
					'subtitle' => __( 'Choose the Text Color.', 'pinnacle' ),
					'default' => '',
					'transparent' => false,
					'output' => array(
						'color' => '.home-message h4, .home-message h5',
						'background-color' => '.home-message h4:after',
					),
					'validate' => 'color',
				),
				array(
					'id' => 'img_menu_height',
					'type' => 'slider',
					'title' => __( 'Image Menu Height', 'pinnacle' ),
					'default'       => '210',
					'min'       => '80',
					'step'      => '5',
					'max'       => '400',
				),
				array(
					'id' => 'img_menu_height_setting',
					'type' => 'select',
					'title' => __( 'Height set by', 'pinnacle' ),
					'subtitle' => __( 'Choose how the image menu height will be set.', 'pinnacle' ),
					'options' => array(
						'normal' => __( 'Height setting above', 'pinnacle' ),
						'imgsize' => __( 'Image Size', 'pinnacle' ),
					),
					'default' => 'normal',
					'width' => 'width:60%',
				),
				array(
					'id' => 'info_product_feat_settings',
					'type' => 'info',
					'desc' => __( 'Home Featured Product Settings', 'pinnacle' ),
				),
				array(
					'id' => 'product_title',
					'type' => 'text',
					'title' => __( 'Home Product Carousel Title', 'pinnacle' ),
					'subtitle' => __( 'e.g. = Featured Products', 'pinnacle' ),
				),
				array(
					'id' => 'home_product_feat_column',
					'type' => 'slider',
					'title' => __( 'Choose how many columns are in carousel', 'pinnacle' ),
					'default'       => '4',
					'min'       => '3',
					'step'      => '1',
					'max'       => '6',
				),
				array(
					'id' => 'home_product_count',
					'type' => 'slider',
					'title' => __( 'Choose how many products are in carousel', 'pinnacle' ),
					'default'       => '6',
					'min'       => '4',
					'step'      => '1',
					'max'       => '18',
				),
				array(
					'id' => 'home_product_feat_scroll',
					'type' => 'select',
					'title' => __( 'Carousel Scroll', 'pinnacle' ),
					'subtitle' => __( 'Choose how the product items scroll.', 'pinnacle' ),
					'options' => array(
						'oneitem' => __( 'One Item', 'pinnacle' ),
						'all' => __( 'All Visible', 'pinnacle' ),
					),
					'default' => 'oneitem',
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_product_feat_speed',
					'type' => 'slider',
					'title' => __( 'Choose the carousel speed (in seconds).', 'pinnacle' ),
					'default'       => '9',
					'min'       => '2',
					'step'      => '1',
					'max'       => '12',
				),
				array(
					'id' => 'info_product_sale_settings',
					'type' => 'info',
					'desc' => __( 'Home On Sale Product Settings', 'pinnacle' ),
				),
				array(
					'id' => 'product_sale_title',
					'type' => 'text',
					'title' => __( 'Home On Sale Product Carousel Title', 'pinnacle' ),
					'subtitle' => __( 'e.g. = On Sale Products', 'pinnacle' ),
				),
				array(
					'id' => 'home_product_sale_column',
					'type' => 'slider',
					'title' => __( 'Choose how many columns are in carousel', 'pinnacle' ),
					'default'       => '4',
					'min'       => '3',
					'step'      => '1',
					'max'       => '6',
				),
				array(
					'id' => 'home_product_sale_count',
					'type' => 'slider',
					'title' => __( 'Choose how many products are in carousel', 'pinnacle' ),
					'default'       => '6',
					'min'       => '4',
					'step'      => '1',
					'max'       => '18',
				),
				array(
					'id' => 'home_product_sale_scroll',
					'type' => 'select',
					'title' => __( 'Carousel Scroll', 'pinnacle' ),
					'subtitle' => __( 'Choose how the product items scroll.', 'pinnacle' ),
					'options' => array(
						'oneitem' => __( 'One Item', 'pinnacle' ),
						'all' => __( 'All Visible', 'pinnacle' ),
					),
					'default' => 'oneitem',
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_product_sale_speed',
					'type' => 'slider',
					'title' => __( 'Choose the carousel speed (in seconds).', 'pinnacle' ),
					'default'       => '9',
					'min'       => '2',
					'step'      => '1',
					'max'       => '12',
				),
				array(
					'id' => 'info_product_best_settings',
					'type' => 'info',
					'desc' => __( 'Home Best Selling Product Settings', 'pinnacle' ),
				),
				array(
					'id' => 'product_best_title',
					'type' => 'text',
					'title' => __( 'Home Best Selling Product Carousel Title', 'pinnacle' ),
					'subtitle' => __( 'e.g. = Best Selling Products', 'pinnacle' ),
				),
				array(
					'id' => 'home_product_best_column',
					'type' => 'slider',
					'title' => __( 'Choose how many columns are in carousel', 'pinnacle' ),
					'default'       => '4',
					'min'       => '3',
					'step'      => '1',
					'max'       => '6',
				),
				array(
					'id' => 'home_product_best_count',
					'type' => 'slider',
					'title' => __( 'Choose how many products are in carousel', 'pinnacle' ),
					'default'       => '6',
					'min'       => '4',
					'step'      => '1',
					'max'       => '18',
				),
				array(
					'id' => 'home_product_best_scroll',
					'type' => 'select',
					'title' => __( 'Carousel Scroll', 'pinnacle' ),
					'subtitle' => __( 'Choose how the product items scroll.', 'pinnacle' ),
					'options' => array(
						'oneitem' => __( 'One Item', 'pinnacle' ),
						'all' => __( 'All Visible', 'pinnacle' ),
					),
					'default' => 'oneitem',
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_product_best_speed',
					'type' => 'slider',
					'title' => __( 'Choose the carousel speed (in seconds).', 'pinnacle' ),
					'default'       => '9',
					'min'       => '2',
					'step'      => '1',
					'max'       => '12',
				),
				array(
					'id' => 'info_blog_settings',
					'type' => 'info',
					'desc' => __( 'Home Blog Settings', 'pinnacle' ),
				),
				array(
					'id' => 'blog_title',
					'type' => 'text',
					'title' => __( 'Home Blog Title', 'pinnacle' ),
					'subtitle' => __( 'e.g. = Latest from the blog', 'pinnacle' ),
				),
				array(
					'id' => 'home_post_count',
					'type' => 'slider',
					'title' => __( 'Choose How many posts on Homepage', 'pinnacle' ),
					'default'       => '6',
					'min'       => '2',
					'step'      => '1',
					'max'       => '18',
				),
				array(
					'id' => 'home_post_column',
					'type' => 'slider',
					'title' => __( 'Choose how many post columns on Homepage', 'pinnacle' ),
					'default'       => '3',
					'min'       => '2',
					'step'      => '1',
					'max'       => '4',
				),
				array(
					'id' => 'home_post_type',
					'type' => 'select',
					'data' => 'categories',
					'title' => __( 'Limit posts to a Category', 'pinnacle' ),
					'subtitle' => __( 'Leave blank to select all', 'pinnacle' ),
					'width' => 'width:60%',
				),
				array(
					'id' => 'info_portfolio_settings',
					'type' => 'info',
					'desc' => __( 'Home Portfolio Carousel Settings', 'pinnacle' ),
				),
				array(
					'id' => 'portfolio_title',
					'type' => 'text',
					'title' => __( 'Home Portfolio Carousel title', 'pinnacle' ),
					'subtitle' => __( 'e.g. = Portfolio Carousel title', 'pinnacle' ),
				),
				array(
					'id' => 'portfolio_type',
					'type' => 'select',
					'data' => 'terms',
					'args' => array(
						'taxonomies' => 'portfolio-type',
						'args' => array(),
					),
					'title' => __( 'Portfolio Carousel Category Type', 'pinnacle' ),
					'subtitle' => __( 'Leave blank to select all types', 'pinnacle' ),
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_portfolio_carousel_column',
					'type' => 'slider',
					'title' => __( 'Choose how many columns are in carousel (not items shown)', 'pinnacle' ),
					'default'       => '3',
					'min'       => '2',
					'step'      => '1',
					'max'       => '6',
				),
				array(
					'id' => 'home_portfolio_carousel_count',
					'type' => 'slider',
					'title' => __( 'Choose how many portfolio posts are in carousel (should at least be equal to how many columns are set).', 'pinnacle' ),
					'default'       => '6',
					'min'       => '4',
					'step'      => '1',
					'max'       => '18',
				),
				array(
					'id' => 'home_port_car_layoutstyle',
					'type' => 'select',
					'title' => __( 'Portfolio Layout Style', 'pinnacle' ),
					'options' => array(
						'default' => __( 'Default', 'pinnacle' ),
						'padded_style' => __( 'Post Boxes', 'pinnacle' ),
						'flat-no-margin' => __( 'Flat no Margin', 'pinnacle' ),
						'flat-w-margin' => __( 'Flat with Margin', 'pinnacle' ),
					),
					'default' => 'default',
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_port_car_hoverstyle',
					'type' => 'select',
					'title' => __( 'Portfolio Hover Style', 'pinnacle' ),
					'options' => array(
						'default' => __( 'Default', 'pinnacle' ),
						'p_lightstyle' => __( 'Light', 'pinnacle' ),
						'p_darkstyle' => __( 'Dark', 'pinnacle' ),
						'p_primarystyle' => __( 'Primary Color', 'pinnacle' ),
					),
					'default' => 'default',
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_port_car_imageratio',
					'type' => 'select',
					'title' => __( 'Portfolio Image Ratio', 'pinnacle' ),
					'options' => array(
						'default' => __( 'Default', 'pinnacle' ),
						'square' => __( 'Square 1:1', 'pinnacle' ),
						'portrait' => __( 'Portrait 3:4', 'pinnacle' ),
						'landscape' => __( 'Landscape 4:3', 'pinnacle' ),
						'widelandscape' => __( 'Wide Landscape 4:2', 'pinnacle' ),
					),
					'default' => 'default',
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_portfolio_carousel_speed',
					'type' => 'slider',
					'title' => __( 'Choose the carousel speed (in seconds).', 'pinnacle' ),
					'default'       => '9',
					'min'       => '2',
					'step'      => '1',
					'max'       => '12',
				),
				array(
					'id' => 'home_portfolio_carousel_scroll',
					'type' => 'select',
					'title' => __( 'Portfolio Carousel Scroll', 'pinnacle' ),
					'subtitle' => __( 'Choose how the portfolio items scroll.', 'pinnacle' ),
					'options' => array(
						'oneitem' => __( 'One Item', 'pinnacle' ),
						'all' => __( 'All Visible', 'pinnacle' ),
					),
					'default' => 'oneitem',
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_portfolio_order',
					'type' => 'select',
					'title' => __( 'Portfolio Carousel Order by', 'pinnacle' ),
					'subtitle' => __( 'Choose how the portfolio items should be ordered in the carousel.', 'pinnacle' ),
					'options' => array(
						'menu_order' => __( 'Menu Order', 'pinnacle' ),
						'title' => __( 'Title', 'pinnacle' ),
						'date' => __( 'Date', 'pinnacle' ),
						'rand' => __( 'Random', 'pinnacle' ),
					),
					'default' => 'menu_order',
					'width' => 'width:60%',
				),
				array(
					'id' => 'portfolio_car_fullwidth',
					'type' => 'switch',
					'title' => __( 'Use full width layout?', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'portfolio_car_lightbox',
					'type' => 'switch',
					'title' => __( 'Display lightbox link in portfolio item?', 'pinnacle' ),
					'default'       => 0,
				),
				array(
					'id' => 'portfolio_show_type',
					'type' => 'switch',
					'title' => __( 'Display Portfolio Types under Title', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'portfolio_show_excerpt',
					'type' => 'switch',
					'title' => __( 'Display Portfolio excerpt under Title', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'info_custom_carousel_settings',
					'type' => 'info',
					'desc' => __( 'Home Custom Carousel Settings', 'pinnacle' ),
				),
				array(
					'id' => 'custom_carousel_title',
					'type' => 'text',
					'title' => __( 'Home Custom Carousel Title', 'pinnacle' ),
					'subtitle' => __( 'e.g. = Featured News', 'pinnacle' ),
				),
				array(
					'id' => 'home_custom_carousel_items',
					'type' => 'kad_slides',
					'title' => __( 'Custom Carousel Items', 'pinnacle' ),
					'subtitle' => __( 'Add images, descriptions, titles, and links', 'pinnacle' ),
				),
				array(
					'id' => 'home_custom_carousel_column',
					'type' => 'slider',
					'title' => __( 'Choose how many columns are in carousel', 'pinnacle' ),
					'default'       => '4',
					'min'       => '2',
					'step'      => '1',
					'max'       => '6',
				),
				array(
					'id' => 'home_custom_carousel_scroll',
					'type' => 'select',
					'title' => __( 'Custom Carousel Scroll', 'pinnacle' ),
					'subtitle' => __( 'Choose how the custom items scroll.', 'pinnacle' ),
					'options' => array(
						'oneitem' => __( 'One Item', 'pinnacle' ),
						'all' => __( 'All Visible', 'pinnacle' ),
					),
					'default' => 'oneitem',
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_custom_speed',
					'type' => 'slider',
					'title' => __( 'Choose the carousel speed (in seconds).', 'pinnacle' ),
					'default'       => '9',
					'min'       => '2',
					'step'      => '1',
					'max'       => '12',
				),
				array(
					'id' => 'home_custom_carousel_imageratio',
					'type' => 'switch',
					'title' => __( 'Enable custom image ratio for carousel', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'info_iconmenu_settings',
					'type' => 'info',
					'desc' => __( 'Home Icon Menu', 'pinnacle' ),
				),
				array(
					'id' => 'icon_menu',
					'type' => 'kad_icons',
					'title' => __( 'Icon Menu', 'pinnacle' ),
					'subtitle' => __( 'Choose your icons for the icon menu.', 'pinnacle' ),
				),
				array(
					'id' => 'home_icon_menu_column',
					'type' => 'slider',
					'title' => __( 'Choose how many columns in each row', 'pinnacle' ),
					'default'       => '3',
					'min'       => '2',
					'step'      => '1',
					'max'       => '6',
				),
				array(
					'id' => 'home_icon_menu_btn',
					'type' => 'text',
					'title' => __( 'Icon menu button text (optional)', 'pinnacle' ),
					'subtitle' => __( 'e.g. = Read More', 'pinnacle' ),
				),
				array(
					'id' => 'home_icon_menu_btn_show',
					'type' => 'switch',
					'title' => __( 'Show button on hover', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'icon_font_color',
					'type' => 'color',
					'title' => __( 'Icon Color', 'pinnacle' ),
					'subtitle' => __( 'Choose the color for icon.', 'pinnacle' ),
					'default' => '',
					'transparent' => false,
					'output' => array( 'color' => '.home-iconmenu .home-icon-item i' ),
					'validate' => 'color',
				),
				array(
					'id' => 'icon_bg_color',
					'type' => 'color',
					'title' => __( 'Icon Background Color', 'pinnacle' ),
					'subtitle' => __( 'Choose the background color for icon. * Note the hover color is set by your primary color in basic styling.', 'pinnacle' ),
					'default' => '',
					'validate' => 'color',
					'output' => array( 'background-color' => '.home-iconmenu .home-icon-item i' ),
				),
				array(
					'id' => 'icon_text_font_color',
					'type' => 'color',
					'title' => __( 'Title and Description Font Color', 'pinnacle' ),
					'subtitle' => __( 'Choose the color for icon menu title and description Font.', 'pinnacle' ),
					'default' => '',
					'transparent' => false,
					'validate' => 'color',
					'output' => array(
						'color' => '.home-iconmenu .home-icon-item h4, .home-iconmenu .home-icon-item p ',
						'background-color' => '.home-iconmenu .home-icon-item h4:after',
					),
				),
				array(
					'id' => 'info_calltoaction_home_settings',
					'type' => 'info',
					'desc' => __( 'Home Call To Action Settings', 'pinnacle' ),
				),
				array(
					'id' => 'home_action_text',
					'type' => 'text',
					'title' => __( 'Call to Action Text', 'pinnacle' ),
				),
				array(
					'id' => 'home_action_color',
					'type' => 'color',
					'title' => __( 'Call to Action Text Color', 'pinnacle' ),
					'default' => '',
					'validate' => 'color',
					'transparent' => false,
					'output' => array( 'color' => '.kad-call-title-case .kad-call-title' ),
				),
				array(
					'id' => 'home_action_text_tag',
					'type' => 'select',
					'title' => __( 'Text Tag', 'pinnacle' ),
					'options' => array(
						'h1' => __( 'h1', 'pinnacle' ),
						'h2' => __( 'h2', 'pinnacle' ),
						'h3' => __( 'h3', 'pinnacle' ),
						'span' => __( 'span', 'pinnacle' ),
					),
					'default' => 'h1',
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_action_text_btn',
					'type' => 'text',
					'title' => __( 'Call to Action Button Text', 'pinnacle' ),
					'subtitle' => __( 'e.g. = Read More', 'pinnacle' ),
				),
				array(
					'id' => 'home_action_link',
					'type' => 'text',
					'title' => __( 'Call to Action Button Link', 'pinnacle' ),
				),
				array(
					'id' => 'home_action_btn_color',
					'type' => 'color',
					'title' => __( 'Button Text Color', 'pinnacle' ),
					'default' => '',
					'validate' => 'color',
					'transparent' => false,
					'output' => array( 'color' => '.kad-call-button-case a.kad-btn-primary' ),
				),
				array(
					'id' => 'home_action_bg_color',
					'type' => 'color',
					'title' => __( 'Button Background Color', 'pinnacle' ),
					'default' => '',
					'validate' => 'color',
					'output' => array( 'background-color' => '.kad-call-button-case a.kad-btn-primary' ),
				),
				array(
					'id' => 'home_action_btn_color_hover',
					'type' => 'color',
					'title' => __( 'Button Hover Text Color', 'pinnacle' ),
					'default' => '',
					'validate' => 'color',
					'transparent' => false,
					'output' => array( 'color' => '.kad-call-button-case a.kad-btn-primary:hover' ),
				),
				array(
					'id' => 'home_action_bg_color_hover',
					'type' => 'color',
					'title' => __( 'Button Hover Background Color', 'pinnacle' ),
					'default' => '',
					'validate' => 'color',
					'output' => array( 'background-color' => '.kad-call-button-case a.kad-btn-primary:hover' ),
				),
				array(
					'id' => 'home_action_padding',
					'type' => 'slider',
					'title' => __( 'Call to action top and bottom padding.', 'pinnacle' ),
					'default'       => '20',
					'min'       => '4',
					'step'      => '2',
					'max'       => '300',
				),
				array(
					'id'        => 'home_action_background',
					'type'      => 'background',
					'output'    => array( '.kt-home-call-to-action' ),
					'title'     => __( 'Call to action background', 'pinnacle' ),
				),
				array(
					'id' => 'info_portfolio_full_settings',
					'type' => 'info',
					'desc' => __( 'Home Portfolio Full Settings', 'pinnacle' ),
				),
				array(
					'id' => 'portfolio_full_title',
					'type' => 'text',
					'title' => __( 'Home Portfolio Full Title', 'pinnacle' ),
					'subtitle' => __( 'e.g. = Our Work', 'pinnacle' ),
				),
				array(
					'id' => 'portfolio_full_type',
					'type' => 'select',
					'data' => 'terms',
					'args' => array(
						'taxonomies' => 'portfolio-type',
						'args' => array(),
					),
					'title' => __( 'Portfolio Full Category Type', 'pinnacle' ),
					'subtitle' => __( 'Choose type for the Portfolio Full', 'pinnacle' ),
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_port_count',
					'type' => 'slider',
					'title' => __( 'Choose how many Portfolio Items on Homepage', 'pinnacle' ),
					'default'       => '8',
					'min'       => '3',
					'step'      => '1',
					'max'       => '20',
				),
				array(
					'id' => 'home_portfolio_full_order',
					'type' => 'select',
					'title' => __( 'Portfolio full Order by', 'pinnacle' ),
					'subtitle' => __( 'Choose how the portfolio items should be ordered.', 'pinnacle' ),
					'options' => array(
						'menu_order' => 'Menu Order',
						'title' => 'Title',
						'date' => 'Date',
						'rand' => 'Random',
					),
					'default' => 'menu_order',
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_port_columns',
					'type' => 'slider',
					'title' => __( 'Choose how many Portfolio columns', 'pinnacle' ),
					'default'       => '4',
					'min'       => '2',
					'step'      => '1',
					'max'       => '5',
				),
				array(
					'id' => 'home_port_layoutstyle',
					'type' => 'select',
					'title' => __( 'Portfolio Layout Style', 'pinnacle' ),
					'options' => array(
						'default' => __( 'Default', 'pinnacle' ),
						'padded_style' => __( 'Post Boxes', 'pinnacle' ),
						'flat-no-margin' => __( 'Flat no Margin', 'pinnacle' ),
						'flat-w-margin' => __( 'Flat with Margin', 'pinnacle' ),
					),
					'default' => 'default',
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_port_hoverstyle',
					'type' => 'select',
					'title' => __( 'Portfolio Hover Style', 'pinnacle' ),
					'options' => array(
						'default' => __( 'Default', 'pinnacle' ),
						'p_lightstyle' => __( 'Light', 'pinnacle' ),
						'p_darkstyle' => __( 'Dark', 'pinnacle' ),
						'p_primarystyle' => __( 'Primary Color', 'pinnacle' ),
					),
					'default' => 'default',
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_port_imageratio',
					'type' => 'select',
					'title' => __( 'Portfolio Image Ratio', 'pinnacle' ),
					'options' => array(
						'default' => __( 'Default', 'pinnacle' ),
						'square' => __( 'Square 1:1', 'pinnacle' ),
						'portrait' => __( 'Portrait 3:4', 'pinnacle' ),
						'landscape' => __( 'Landscape 4:3', 'pinnacle' ),
						'widelandscape' => __( 'Wide Landscape 4:2', 'pinnacle' ),
					),
					'default' => 'default',
					'width' => 'width:60%',
				),
				array(
					'id' => 'portfolio_full_masonry',
					'type' => 'switch',
					'title' => __( 'Use masonry Layout?', 'pinnacle' ),
					'default'       => 0,
				),
				array(
					'id' => 'portfolio_full_filter',
					'type' => 'switch',
					'title' => __( 'Use Isotope Filter?', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'portfolio_full_fullwidth',
					'type' => 'switch',
					'title' => __( 'Use full width layout?', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'home_portfolio_lightbox',
					'type' => 'switch',
					'title' => __( 'Display lightbox link in portfolio item?', 'pinnacle' ),
					'default'       => 0,
				),
				array(
					'id' => 'portfolio_full_show_type',
					'type' => 'switch',
					'title' => __( 'Display Portfolio Types under Title', 'pinnacle' ),
					'default'       => 1,
				),
				array(
					'id' => 'portfolio_full_show_excerpt',
					'type' => 'switch',
					'title' => __( 'Display Portfolio excerpt under Title', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'info_page_content',
					'type' => 'info',
					'desc' => __( 'Page Content Options (if home page is latest post page)', 'pinnacle' ),
				),
				array(
					'id' => 'home_post_summery',
					'type' => 'select',
					'title' => __( 'Latest Post Display', 'pinnacle' ),
					'subtitle' => __( 'If Latest Post page is front page. Choose how to show the posts.', 'pinnacle' ),
					'options' => array(
						'summary' => __( 'Normal Post Excerpt', 'pinnacle' ),
						'full' => __( 'Normal Full Post', 'pinnacle' ),
						'grid' => __( 'Grid Post', 'pinnacle' ),
						'photo' => __( 'Photo Post', 'pinnacle' ),
					),
					'default' => 'summery',
					'width' => 'width:60%',
				),
				array(
					'id' => 'home_post_grid_columns',
					'type' => 'select',
					'title' => __( 'Post Grid Columns', 'pinnacle' ),
					'options' => array(
						'2' => __( 'Two', 'pinnacle' ),
						'3' => __( 'Three', 'pinnacle' ),
						'4' => __( 'Four', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => '3',
					'required' => array( 'home_post_summery', '=', array( 'grid', 'photo' ) ),
				),

			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-basket2',
			'icon_class' => 'icon-large',
			'customizer' => false,
			'id' => 'shop_settings',
			'title' => __( 'Shop Settings', 'pinnacle' ),
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Shop Archive Page Settings', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'product_shop_layout',
					'type' => 'select',
					'title' => __( 'Shop Product Column Layout', 'pinnacle' ),
					'subtitle' => __( 'Choose how many product columns on the shop and category pages', 'pinnacle' ),
					'options' => array(
						'3' => __( 'Three Column', 'pinnacle' ),
						'4' => __( 'Four Column', 'pinnacle' ),
						'5' => __( 'Five Column', 'pinnacle' ),
						'6' => __( 'Six Column', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => '4',
					'customizer' => true,
				),
				array(
					'id' => 'product_shop_style',
					'type' => 'select',
					'title' => __( 'Shop Product Style', 'pinnacle' ),
					'subtitle' => __( 'Choose the product style', 'pinnacle' ),
					'options' => array(
						'kad_shop_default' => __( 'Default', 'pinnacle' ),
						'kad_shop_default_simple' => __( 'Simple Text below Image', 'pinnacle' ),
						'kad-simple-shop' => __( 'Simple Text on Image (Light)', 'pinnacle' ),
						'kad-simple-shop-dark' => __( 'Simple Text on Image (dark)', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'kad_shop_default',
					'customizer' => true,
				),
				array(
					'id' => 'shop_layout',
					'type' => 'image_select',
					'compiler' => false,
					'title' => __( 'Display the sidebar on Shop Page?', 'pinnacle' ),
					'subtitle' => __( 'This determines if there is a sidebar on the shop page.', 'pinnacle' ),
					'options' => array(
						'full' => array(
							'alt' => 'Full Layout',
							'img' => OPTIONS_PATH . 'img/1col.png',
						),
						'sidebar' => array(
							'alt' => 'Sidebar Layout',
							'img' => OPTIONS_PATH . 'img/2cr.png',
						),
					),
					'default' => 'full',
				),
				array(
					'id' => 'shop_sidebar',
					'type' => 'select',
					'title' => __( 'Choose a Sidebar for your shop page', 'pinnacle' ),
					'data' => 'sidebars',
					'default' => 'sidebar-primary',
					'width' => 'width:60%',
				),
				array(
					'id' => 'shop_cat_layout',
					'type' => 'image_select',
					'compiler' => false,
					'title' => __( 'Display the sidebar on Product Category Pages?', 'pinnacle' ),
					'subtitle' => __( 'This determines if there is a sidebar on the product category pages.', 'pinnacle' ),
					'options' => array(
						'full' => array(
							'alt' => 'Full Layout',
							'img' => OPTIONS_PATH . 'img/1col.png',
						),
						'sidebar' => array(
							'alt' => 'Sidebar Layout',
							'img' => OPTIONS_PATH . 'img/2cr.png',
						),
					),
					'default' => 'full',
				),
				array(
					'id' => 'shop_cat_sidebar',
					'type' => 'select',
					'title' => __( 'Choose a Sidebar for your Product Category Pages', 'pinnacle' ),
					'data' => 'sidebars',
					'default' => 'sidebar-primary',
					'width' => 'width:60%',
				),
				array(
					'id' => 'products_per_page',
					'type' => 'slider',
					'title' => __( 'How many products per page', 'pinnacle' ),
					'default'       => '12',
					'min'       => '2',
					'step'      => '1',
					'max'       => '80',
				),
				array(
					'id' => 'product_fitrows',
					'type' => 'switch',
					'title' => __( 'Force products into rows', 'pinnacle' ),
					'subtitle' => __( 'Products fit into rows regardless of size', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'shop_filter',
					'type' => 'switch',
					'title' => __( 'Show Category Filter on Shop Page', 'pinnacle' ),
					'subtitle' => __( 'This adds an dynamic filter to the shop page. NOTE this filter is only designed to filter what is visible on the page. It does not act as a menu and query products from multiple pages.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'cat_filter',
					'type' => 'switch',
					'title' => __( 'Show Category Filter on Category Pages', 'pinnacle' ),
					'subtitle' => __( 'This adds an dynamic filter to Category pages. NOTE this filter is only designed to filter what is visible on the page. It does not act as a menu and query products from multiple pages.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'infinitescroll',
					'type' => 'switch',
					'title' => __( 'Use Infinite Scroll on Shop pages', 'pinnacle' ),
					'subtitle' => __( 'Not recomended that you use with filter.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'shop_excerpt',
					'type' => 'switch',
					'title' => __( 'Stop Product Excerpt from loading in the shop grid pages.', 'pinnacle' ),
					'subtitle' => __( 'Good to turn on if there are conflicts on your shop grid pages.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'shop_rating',
					'type' => 'switch',
					'title' => __( 'Show Ratings in Shop and Category Pages', 'pinnacle' ),
					'subtitle' => __( 'This determines if the rating is displayed in the product archive pages', 'pinnacle' ),
					'default' => 1,
					'customizer' => true,
				),
				array(
					'id' => 'outofstocktag',
					'type' => 'switch',
					'title' => __( 'Show Sold tag if product out of stock.', 'pinnacle' ),
					'subtitle' => __( 'This determines if a sold tag is displayed on the top right of the product image', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'shop_hide_action',
					'type' => 'switch',
					'title' => __( 'Hide Add to Cart Till Mouse Hover', 'pinnacle' ),
					'subtitle' => __( 'This determines if add to cart button will be hidden till the mouse hovers over the product', 'pinnacle' ),
					'default' => 1,
					'customizer' => true,
				),
				array(
					'id' => 'product_img_flip',
					'type' => 'switch',
					'title' => __( 'Product Image Flip', 'pinnacle' ),
					'subtitle' => __( 'This allows your product image to flip to the first gallery image when hovered over on shop page. *Note only works in newer browsers.', 'pinnacle' ),
					'default' => 0,
					'customizer' => true,
				),
				array(
					'id' => 'product_quantity_input',
					'type' => 'switch',
					'title' => __( 'Quantity box plus and minus', 'pinnacle' ),
					'subtitle' => __( 'Turn this off if you would like to use browser added plus and minus for number boxes', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'info_cat_product_size',
					'type' => 'info',
					'desc' => __( 'Shop Category Image Size', 'pinnacle' ),
				),
				array(
					'id' => 'product_cat_layout',
					'type' => 'select',
					'title' => __( 'Shop Category Column Layout', 'pinnacle' ),
					'subtitle' => __( 'Choose how many Category Image columns to show on the shop and category pages', 'pinnacle' ),
					'options' => array(
						'2' => __( 'Two Column', 'pinnacle' ),
						'3' => __( 'Three Column', 'pinnacle' ),
						'4' => __( 'Four Column', 'pinnacle' ),
						'5' => __( 'Five Column', 'pinnacle' ),
						'6' => __( 'Six Column', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => '3',
				),
				array(
					'id' => 'product_cat_img_ratio',
					'type' => 'select',
					'title' => __( 'Category Image Aspect Ratio', 'pinnacle' ),
					'subtitle' => __( 'If enabled below this sets how you want your category images to be cropped.', 'pinnacle' ),
					'options' => array(
						'square' => __( 'Square 1:1', 'pinnacle' ),
						'portrait' => __( 'Portrait 3:4', 'pinnacle' ),
						'landscape' => __( 'Landscape 4:3', 'pinnacle' ),
						'widelandscape' => __( 'Wide Landscape 4:2', 'pinnacle' ),
						'off' => __( 'Turn Off', 'pinnacle' ),
					),
					'default' => 'square',
					'width' => 'width:60%',
				),
				array(
					'id' => 'info_shop_product_title',
					'type' => 'info',
					'desc' => __( 'Shop Product Title Settings', 'pinnacle' ),
				),
				array(
					'id' => 'font_shop_title',
					'type' => 'typography',
					'title' => __( 'Shop & archive Product title Font', 'pinnacle' ),
					'font-family' => true,
					'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
					'font-backup' => false, // Select a backup non-google font in addition to a google font
					'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
					'subsets' => true, // Only appears if google is true and subsets not set to false
					'font-size' => true,
					'line-height' => true,
					'color' => true,
					'preview' => true, // Disable the previewer
					'output' => array( '.product_item .product_details h5, .product-category.grid_item a h5' ),
					'subtitle' => __( 'Choose Size and Style for product titles on category and archive pages.', 'pinnacle' ),
					'default' => array(
						'font-family' => 'Raleway',
						'color' => '',
						'font-style' => '700',
						'font-size' => '15px',
						'line-height' => '20px',
					),
				),
				array(
					'id' => 'shop_title_uppercase',
					'type' => 'switch',
					'title' => __( 'Set Product Title to Uppercase?', 'pinnacle' ),
					'subtitle' => __( 'This makes your product titles uppercase on Category pages', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'shop_title_min_height',
					'type' => 'slider',
					'title' => __( 'Product title Min Height', 'pinnacle' ),
					'subtitle' => __( 'If your titles are long increase this to help align your products height.', 'pinnacle' ),
					'default'       => '50',
					'min'       => '20',
					'step'      => '5',
					'max'       => '120',
				),
				array(
					'id' => 'info_shop_img_size',
					'type' => 'info',
					'desc' => __( 'Product Image Sizes', 'pinnacle' ),
				),
				array(
					'id' => 'shop_img_ratio',
					'type' => 'select',
					'title' => __( 'Product Image Aspect Ratio', 'pinnacle' ),
					'subtitle' => __( 'If enabled below this sets how you want your product images to be cropped.', 'pinnacle' ),
					'options' => array(
						'square' => __( 'Square 1:1', 'pinnacle' ),
						'portrait' => __( 'Portrait 3:4', 'pinnacle' ),
						'landscape' => __( 'Landscape 4:3', 'pinnacle' ),
						'widelandscape' => __( 'Wide Landscape 4:2', 'pinnacle' ),
					),
					'default' => 'square',
					'width' => 'width:60%',
				),
				array(
					'id' => 'product_img_resize',
					'type' => 'switch',
					'title' => __( 'Enable Product Image Aspect Ratio on Catalog pages', 'pinnacle' ),
					'subtitle' => __( 'If turned off image dimensions are set by woocommerce settings - recommended width: 270px for Catalog Images', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'product_simg_resize',
					'type' => 'switch',
					'title' => __( 'Enable Product Image Aspect Ratio on product Page', 'pinnacle' ),
					'subtitle' => __( 'If turned off image dimensions are set by woocommerce settings - recommended width: 468px for Single Product Image', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'info_shop_slider',
					'type' => 'info',
					'desc' => __( 'Shop Slider/Content', 'pinnacle' ),
				),
				array(
					'id' => 'ss_behindheader',
					'type' => 'switch',
					'title' => __( 'Place behind Header', 'pinnacle' ),
					'subtitle' => __( 'This enabled the transparent header on the Shop page.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'choose_shop_header',
					'type' => 'select',
					'title' => __( 'Choose a Head Content for your shop page', 'pinnacle' ),
					'options' => array(
						'pagetitle' => __( 'Page Title', 'pinnacle' ),
						'rev' => __( 'Revolution Slider', 'pinnacle' ),
						'ksp' => __( 'Kadence Slider Pro', 'pinnacle' ),
						'ktslider' => __( 'Kadence Slider Legacy', 'pinnacle' ),
						'cyclone' => __( 'Shortcode Entry', 'pinnacle' ),
						'flex' => __( 'Flex Slider', 'pinnacle' ),
						'carousel' => __( 'Carousel Slider', 'pinnacle' ),
						'none' => __( 'None', 'pinnacle' ),
					),
					'default' => 'pagetitle',
					'width' => 'width:60%',
				),
				array(
					'id' => 'shop_page_title',
					'type' => 'info',
					'desc' => __( '*Set up Your page title in the page settings', 'pinnacle' ),
					'required' => array( 'choose_shop_header', '=', 'pagetitle' ),
				),
				array(
					'id' => 'rev_slider_shop',
					'type' => 'select',
					'title' => __( 'If Revolution Slider', 'pinnacle' ),
					'subtitle' => __( 'Choose your Revolution Slider Here', 'pinnacle' ),
					'options' => $of_revolution,
					'default' => 'select',
					'width' => 'width:60%',
					'required' => array( 'choose_shop_header', '=', 'rev' ),
				),
				array(
					'id' => 'kt_slider_shop',
					'type' => 'select',
					'title' => __( 'If Kadence Slider', 'pinnacle' ),
					'subtitle' => __( 'Choose your Kadence Slider Here', 'pinnacle' ),
					'data' => 'posts',
					'args' => array(
						'post_type' => 'kadslider',
						'posts_per_page' => -1,
					),
					'default' => 'select',
					'width' => 'width:60%',
					'required' => array( 'choose_shop_header', '=', 'ktslider' ),
				),
				array(
					'id' => 'ksp_slider_shop',
					'type' => 'select',
					'title' => __( 'If Kadence Slider Pro Slider', 'pinnacle' ),
					'subtitle' => __( 'Choose your Kadence Slider here', 'pinnacle' ),
					'options' => $of_ksp,
					'default' => 'select',
					'width' => 'width:60%',
					'required' => array( 'choose_shop_header', '=', 'ksp' ),
				),
				array(
					'id' => 'shop_cyclone_slider',
					'type' => 'text',
					'title' => __( 'If Shortcode Entry', 'pinnacle' ),
					'subtitle' => __( 'Paste shortcode here', 'pinnacle' ),
					'required' => array( 'choose_shop_header', '=', 'cyclone' ),
				),
				array(
					'id' => 'shop_slider_images',
					'type' => 'kad_slides',
					'title' => __( 'Slider Images', 'pinnacle' ),
					'subtitle' => __( 'Use large images for best results.', 'pinnacle' ),
					'required' => array( 'choose_shop_header', '=', array( 'flex', 'carousel' ) ),
				),
				array(
					'id' => 'shop_slider_size',
					'type' => 'slider',
					'title' => __( 'Slider Max Height', 'pinnacle' ),
					'subtitle' => __( 'Note: does not work if images are smaller than max.', 'pinnacle' ),
					'default'       => '400',
					'min'       => '100',
					'step'      => '5',
					'max'       => '600',
					'required' => array( 'choose_shop_header', '=', array( 'flex', 'carousel' ) ),
				),
				array(
					'id' => 'shop_slider_size_width',
					'type' => 'slider',
					'title' => __( 'Slider Max Width', 'pinnacle' ),
					'subtitle' => __( 'Note: does not work if images are smaller than max. If using sidebar set to 770', 'pinnacle' ),
					'default'       => '1140',
					'min'       => '600',
					'step'      => '5',
					'max'       => '1140',
					'required' => array( 'choose_shop_header', '=', array( 'flex', 'carousel' ) ),
				),
				array(
					'id' => 'shop_slider_autoplay',
					'type' => 'switch',
					'title' => __( 'Auto Play?', 'pinnacle' ),
					'subtitle' => __( 'This determines if a slider automatically scrolls', 'pinnacle' ),
					'default'       => 1,
					'required' => array( 'choose_shop_header', '=', array( 'flex', 'carousel' ) ),
				),
				array(
					'id' => 'shop_slider_pausetime',
					'type' => 'slider',
					'title' => __( 'Slider Pause Time', 'pinnacle' ),
					'subtitle' => __( 'How long to pause on each slide, in milliseconds.', 'pinnacle' ),
					'default'   => '7000',
					'min'       => '3000',
					'step'      => '1000',
					'max'       => '12000',
					'required' => array( 'choose_shop_header', '=', array( 'flex', 'carousel' ) ),
				),
				array(
					'id' => 'shop_trans_type',
					'type' => 'select',
					'title' => __( 'Transition Type', 'pinnacle' ),
					'subtitle' => __( 'Choose a transition type', 'pinnacle' ),
					'options' => array(
						'fade' => 'Fade',
						'slide' => 'Slide',
					),
					'default' => 'fade',
					'required' => array( 'choose_shop_header', '=', array( 'flex', 'carousel' ) ),
				),
				array(
					'id' => 'shop_slider_transtime',
					'type' => 'slider',
					'title' => __( 'Slider Transition Time', 'pinnacle' ),
					'subtitle' => __( 'How long for slide transitions, in milliseconds.', 'pinnacle' ),
					'default'       => '600',
					'min'       => '200',
					'step'      => '100',
					'max'       => '1200',
					'required' => array( 'choose_shop_header', '=', array( 'flex', 'carousel' ) ),
				),
				array(
					'id' => 'shop_slider_captions',
					'type' => 'switch',
					'title' => __( 'Show Captions?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide captions', 'pinnacle' ),
					'default'       => 0,
					'required' => array( 'choose_shop_header', '=', array( 'flex', 'carousel' ) ),
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-bag2',
			'icon_class' => 'icon-large',
			'id' => 'product_settings',
			'customizer' => false,
			'title' => __( 'Product Settings', 'pinnacle' ),
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Single Product Settings', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'singleproduct_layout',
					'type' => 'image_select',
					'title' => __( 'Single Product Layout', 'pinnacle' ),
					'subtitle' => __( 'This determines the width of the image area on single product pages.', 'pinnacle' ),
					'options' => array(
						'normal' => array(
							'alt' => 'Normal Layout',
							'img' => OPTIONS_PATH . 'img/pni.png',
						),
						'largeimg' => array(
							'alt' => 'Large Image Layout',
							'img' => OPTIONS_PATH . 'img/pwi.png',
						),
					),
					'default' => 'normal',
				),
				array(
					'id' => 'product_sidebar_default',
					'type' => 'select',
					'title' => __( 'Product Sidebar Default', 'pinnacle' ),
					'options' => array(
						'no' => __( 'No, Do not Show', 'pinnacle' ),
						'yes' => __( 'Yes, Show', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'no',
				),
				array(
					'id' => 'product_sidebar_default_sidebar',
					'type' => 'select',
					'title' => __( 'Choose a Default Sidebar for your Single Product Pages', 'pinnacle' ),
					'data' => 'sidebars',
					'default' => 'sidebar-primary',
					'width' => 'width:60%',
				),
				array(
					'id' => 'info_product_ph_defaults',
					'type' => 'info',
					'desc' => __( 'Single Product Page Header', 'pinnacle' ),
				),
				array(
					'id' => 'default_showproducttitle',
					'type' => 'switch',
					'title' => __( 'Show the Title in header by default', 'pinnacle' ),
					'subtitle' => __( 'This can be overridden on each page.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'single_product_header_title',
					'type' => 'select',
					'title' => __( 'Product Default Title Text', 'pinnacle' ),
					'options' => array(
						'category' => __( 'Category of product', 'pinnacle' ),
						'posttitle' => __( 'Product Title', 'pinnacle' ),
						'custom' => __( 'Custom', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'category',
				),
				array(
					'id' => 'product_header_title_text',
					'type' => 'text',
					'title' => __( 'Post Default Title', 'pinnacle' ),
					'subtitle' => __( 'Example: My Shop', 'pinnacle' ),
					'required' => array( 'single_product_header_title', '=', 'custom' ),
				),
				array(
					'id' => 'product_header_subtitle_text',
					'type' => 'text',
					'title' => __( 'Post Default Subtitle', 'pinnacle' ),
					'required' => array( 'single_product_header_title', '=', 'custom' ),
				),
				array(
					'id' => 'default_showproducttitle_inpost',
					'type' => 'switch',
					'title' => __( 'Single product show the title in post', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'single_product_title_output',
					'type' => 'select',
					'title' => __( 'Single product in post non-head title output', 'pinnacle' ),
					'options' => array(
						'h1' => __( 'Use H1 tag', 'pinnacle' ),
						'h2' => __( 'Use H2 tag', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'h1',
				),
				array(
					'id' => 'product_nav',
					'type' => 'switch',
					'title' => __( 'Display Product Navigation arrows beside title?', 'pinnacle' ),
					'subtitle' => __( 'This will display navigation arrow beside product title to navigate to other products in the same category.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'product_gallery_slider',
					'type' => 'switch',
					'title' => __( 'Enable woocommerce slider for product gallery? (must be woocommerce 3.0+)', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'product_gallery_zoom',
					'type' => 'switch',
					'title' => __( 'Enable woocommerce hover zoom for product gallery? (must be woocommerce 3.0+)', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'product_radio',
					'type' => 'switch',
					'title' => __( 'Display variations as radio buttons instead of select box?', 'pinnacle' ),
					'subtitle' => __( 'This will display product varations in a box form.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'product_tabs',
					'type' => 'switch',
					'title' => __( 'Display product tabs?', 'pinnacle' ),
					'subtitle' => __( 'This determines if product tabs are displayed', 'pinnacle' ),
					'default'       => 1,
				),
				array(
					'id' => 'ptab_description',
					'type' => 'slider',
					'title' => __( 'Product Tab Order - Lowest First', 'pinnacle' ),
					'desc' => __( 'Description Tab', 'pinnacle' ),
					'default'       => '10',
					'min'       => '5',
					'step'      => '5',
					'max'       => '60',
				),
				array(
					'id' => 'ptab_additional',
					'type' => 'slider',
					'desc' => __( 'Additional Information Tab', 'pinnacle' ),
					'default'       => '20',
					'min'       => '5',
					'step'      => '5',
					'max'       => '60',
				),
				array(
					'id' => 'ptab_reviews',
					'type' => 'slider',
					'desc' => __( 'Reviews Tab', 'pinnacle' ),
					'default'       => '30',
					'min'       => '5',
					'step'      => '5',
					'max'       => '60',
				),
				array(
					'id' => 'ptab_video',
					'type' => 'slider',
					'desc' => __( 'Product Video Tab', 'pinnacle' ),
					'default'       => '40',
					'min'       => '5',
					'step'      => '5',
					'max'       => '60',
				),
				array(
					'id' => 'custom_tab_01',
					'type' => 'switch',
					'title' => __( 'Activate Custom Tab 01', 'pinnacle' ),
					'subtitle' => __( 'This adds a custom product tab to your products', 'pinnacle' ),
					'default'       => 0,
				),
				array(
					'id' => 'custom_tab_02',
					'type' => 'switch',
					'title' => __( 'Activate Custom Tab 02', 'pinnacle' ),
					'subtitle' => __( 'This adds a custom product tab to your products', 'pinnacle' ),
					'default'       => 0,
				),
				array(
					'id' => 'custom_tab_03',
					'type' => 'switch',
					'title' => __( 'Activate Custom Tab 03', 'pinnacle' ),
					'subtitle' => __( 'This adds a custom product tab to your products', 'pinnacle' ),
					'default'       => 0,
				),
				array(
					'id' => 'related_products',
					'type' => 'switch',
					'title' => __( 'Display related products?', 'pinnacle' ),
					'subtitle' => __( 'This determines related products are displayed', 'pinnacle' ),
					'default'       => 1,
				),
				array(
					'id' => 'related_item_column',
					'type' => 'slider',
					'title' => __( 'Choose how many columns are in related product carousel', 'pinnacle' ),
					'default'   => '4',
					'min'       => '3',
					'step'      => '1',
					'max'       => '6',
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-images2',
			'icon_class' => 'icon-large',
			'customizer' => false,
			'title' => __( 'Portfolio Options', 'pinnacle' ),
			'id' => 'portfolio_options',
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Portfolio Options', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'portfolio_permalink',
					'type' => 'text',
					'title' => __( 'Portfolio Permalink Base', 'pinnacle' ),
					'subtitle' => __( 'Standard: portfolio *NOTE If you change this resave your permalinks', 'pinnacle' ),
				),
				array(
					'id' => 'portfolio_comments',
					'type' => 'switch',
					'title' => __( 'Allow Comments on Portfolio Posts', 'pinnacle' ),
					'subtitle' => __( 'Turn on to allow Comments on Portfolio posts', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'info_portfolio_grid_options',
					'type' => 'info',
					'desc' => __( 'Portfolio Grid Options', 'pinnacle' ),
				),
				array(
					'id' => 'portfolio_style_default',
					'type' => 'select',
					'width' => 'width:60%',
					'default' => 'flat-w-margin',
					'customizer' => true,
					'title' => __( 'Default Portfolio Layout Style', 'pinnacle' ),
					'subtitle' => __( 'This sets the default layout style for the portfolio post.', 'pinnacle' ),
					'options' => array(
						'padded_style' => __( 'Post Boxes', 'pinnacle' ),
						'flat-no-margin' => __( 'Flat No Margin', 'pinnacle' ),
						'flat-w-margin' => __( 'Flat with Margin', 'pinnacle' ),
					),
				),
				array(
					'id' => 'portfolio_hover_style_default',
					'type' => 'select',
					'width' => 'width:60%',
					'customizer' => true,
					'default' => 'p_primarystyle',
					'title' => __( 'Default Hover Style', 'pinnacle' ),
					'subtitle' => __( 'This sets the default hover style for the portfolio post.', 'pinnacle' ),
					'options' => array(
						'p_primarystyle' => __( 'Primary Color Style', 'pinnacle' ),
						'p_lightstyle' => __( 'Light Style', 'pinnacle' ),
						'p_darkstyle' => __( 'Dark Style', 'pinnacle' ),
					),
				),
				array(
					'id' => 'portfolio_ratio_default',
					'type' => 'select',
					'title' => __( 'Portfolio Grid Image Aspect Ratio', 'pinnacle' ),
					'subtitle' => __( 'This sets how you want your portfolio gird images to be cropped.', 'pinnacle' ),
					'options' => array(
						'square' => __( 'Square 1:1', 'pinnacle' ),
						'portrait' => __( 'Portrait 3:4', 'pinnacle' ),
						'landscape' => __( 'Landscape 4:3', 'pinnacle' ),
						'widelandscape' => __( 'Wide Landscape 4:2', 'pinnacle' ),
					),
					'default' => 'square',
					'width' => 'width:60%',
				),
				array(
					'id' => 'info_product_ph_defaults',
					'type' => 'info',
					'desc' => __( 'Single Portfolio Page Header', 'pinnacle' ),
				),
				array(
					'id' => 'default_showportfoliotitle',
					'type' => 'switch',
					'title' => __( 'Show the Title in header by default', 'pinnacle' ),
					'subtitle' => __( 'This can be overridden on each page.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'default_showportfoliotitle_inpost',
					'type' => 'switch',
					'title' => __( 'Show the Title in post', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'single_portfolio_header_title',
					'type' => 'select',
					'title' => __( 'Single Portfolio Default Title Text', 'pinnacle' ),
					'options' => array(
						'category' => __( 'Category of Portfolio', 'pinnacle' ),
						'posttitle' => __( 'Portfolio Title', 'pinnacle' ),
						'custom' => __( 'Custom', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'posttitle',
				),
				array(
					'id' => 'portfolio_header_title_text',
					'type' => 'text',
					'title' => __( 'Post Default Title', 'pinnacle' ),
					'subtitle' => __( 'Example: My Shop', 'pinnacle' ),
					'required' => array( 'single_portfolio_header_title', '=', 'custom' ),
				),
				array(
					'id' => 'portfolio_header_subtitle_text',
					'type' => 'text',
					'title' => __( 'Post Default Subtitle', 'pinnacle' ),
					'required' => array( 'single_portfolio_header_title', '=', 'custom' ),
				),
				array(
					'id' => 'info_portfolio_nav_options',
					'type' => 'info',
					'desc' => __( 'Single Portfolio Navigation Options', 'pinnacle' ),
				),
				array(
					'id' => 'portfolio_header_nav',
					'type' => 'switch',
					'title' => __( 'Show portfolio nav below post title', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'portfolio_link',
					'type' => 'select',
					'data' => 'pages',
					'width' => 'width:60%',
					'title' => __( 'All Projects Default Portfolio Page', 'pinnacle' ),
					'subtitle' => __( 'This sets the link in every portfolio post. You can override in post.', 'pinnacle' ),
				),
				array(
					'id' => 'portfolio_arrow_nav',
					'type' => 'select',
					'title' => __( 'Portfolio Arrow Navigation', 'pinnacle' ),
					'options' => array(
						'all' => __( 'Navigate through All Posts', 'pinnacle' ),
						'cat' => __( 'Navigate through Category', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'all',
				),
				array(
					'id' => 'info_portfolio_carousel_options',
					'type' => 'info',
					'desc' => __( 'Portfolio Post Bottom Carousel', 'pinnacle' ),
				),
				array(
					'id' => 'single_portfolio_carousel_default',
					'type' => 'select',
					'title' => __( 'Display Bottom Portfolio carousel by Default', 'pinnacle' ),
					'options' => array(
						'no' => __( 'No', 'pinnacle' ),
						'yes' => __( 'Yes', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'no',
				),
				array(
					'id' => 'single_portfolio_carousel_items',
					'type' => 'select',
					'title' => __( 'Bottom Portfolio Carousel Items', 'pinnacle' ),
					'options' => array(
						'all' => __( 'All Portfolio Posts', 'pinnacle' ),
						'cat' => __( 'Only of same Portfolio Type', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'all',
				),
				array(
					'id' => 'portfolio_recent_car_column',
					'type' => 'slider',
					'title' => __( 'Choose how many columns to show on recent portfolio carousel.', 'pinnacle' ),
					'default'       => '4',
					'min'       => '2',
					'step'      => '1',
					'max'       => '6',
				),
				array(
					'id' => 'info_portfolio_cat_defaults',
					'type' => 'info',
					'desc' => __( 'Portfolio Category Pages', 'pinnacle' ),
				),
				array(
					'id' => 'portfolio_tax_column',
					'type' => 'slider',
					'title' => __( 'Choose how many portfolio columns to show on portfolio catagory pages.', 'pinnacle' ),
					'default'       => '4',
					'min'       => '2',
					'step'      => '1',
					'max'       => '6',
				),
				array(
					'id' => 'portfolio_tax_items',
					'type' => 'slider',
					'title' => __( 'Choose how many items you want to show on each category page.', 'pinnacle' ),
					'default'       => '12',
					'min'       => '2',
					'step'      => '1',
					'max'       => '40',
				),
				array(
					'id' => 'portfolio_tax_filter',
					'type' => 'switch',
					'title' => __( 'Show portfolio category with filter', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'portfolio_tax_fullwidth',
					'type' => 'switch',
					'title' => __( 'Show portfolio category as full-screen width', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'portfolio_tax_masonry',
					'type' => 'switch',
					'title' => __( 'Show portfolio category in masonry style', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'portfolio_tax_lightbox',
					'type' => 'switch',
					'customizer' => false,
					'title' => __( 'Display lightbox link?', 'pinnacle' ),
					'default'       => 1,
				),
				array(
					'id' => 'portfolio_type_under_title',
					'type' => 'switch',
					'customizer' => false,
					'title' => __( 'Show Types under Title', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide portfolio type under title.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'portfolio_tax_show_excerpt',
					'type' => 'switch',
					'customizer' => false,
					'title' => __( 'Display Portfolio Excerpt under Title', 'pinnacle' ),
					'default' => 0,
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-pencil2',
			'icon_class' => 'icon-large',
			'customizer' => false,
			'title' => __( 'Blog Options', 'pinnacle' ),
			'id' => 'blog_options',
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Blog Options', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'post_word_count',
					'type' => 'slider',
					'title' => __( 'Post Excerpt Length', 'pinnacle' ),
					'subtitle' => __( 'Determines how many words are in an Excerpt.', 'pinnacle' ),
					'default'   => '40',
					'min'       => '20',
					'step'      => '2',
					'max'       => '80',
				),
				array(
					'id' => 'custom_excerpt_readmore',
					'type' => 'switch',
					'title' => __( 'Add "read more" link to custom excerpts?', 'pinnacle' ),
					'subtitle' => __( 'Choose to automatically add a "read more" link to custom excerpts', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'close_comments',
					'type' => 'switch',
					'title' => __( 'Show Comments Closed Text?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide comments closed alert below posts.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'hide_author_img',
					'type' => 'switch',
					'title' => __( 'Show Author image with posts?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide author image beside post title.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'hide_author',
					'type' => 'switch',
					'title' => __( 'Show author name with posts?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide author name under post title.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'hide_postedin',
					'type' => 'switch',
					'title' => __( 'Show categories with posts?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide categories in the post footer.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'hide_posttags',
					'type' => 'switch',
					'title' => __( 'Show tags with posts?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide tags in the post footer.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'hide_commenticon',
					'type' => 'switch',
					'title' => __( 'Show comment count with posts?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide comment count under post title.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'hide_postdate',
					'type' => 'switch',
					'title' => __( 'Show date with posts?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide date under post title.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'show_postlinks',
					'type' => 'switch',
					'title' => __( 'Show Previous and Next posts links?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide previous and next post links in the footer of a single post.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'blog_infinitescroll',
					'type' => 'switch',
					'title' => __( 'Use Infinite Scroll on Blog pages', 'pinnacle' ),
					'subtitle' => __( 'Remove Pagination and creates infinite scroll instead. Note does not work with slider post summaries', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'blog_cat_infinitescroll',
					'type' => 'switch',
					'title' => __( 'Use Infinite Scroll on Blog archive pages', 'pinnacle' ),
					'subtitle' => __( 'Remove Pagination and creates infinite scroll instead. Note does not work with slider post summaries', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'postexcerpt_hard_crop',
					'type' => 'switch',
					'title' => __( 'Hard Crop excerpt images to the same height.', 'pinnacle' ),
					'subtitle' => __( 'Makes the excerpt images the same size instead of whatever ratio was uploaded.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'blog_grid_display_height',
					'type' => 'switch',
					'title' => __( 'Display Blog Grid posts at equal height', 'pinnacle' ),
					'subtitle' => __( 'Turn on if you want the bog grid to be equal height and display in equal rows regardless of post content.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'info_blog_defaults',
					'type' => 'info',
					'desc' => __( 'Blog Post Page Header', 'pinnacle' ),
				),
				array(
					'id' => 'default_showposttitle',
					'type' => 'switch',
					'title' => __( 'Show the post title in head by default', 'pinnacle' ),
					'subtitle' => __( 'This can be overridden on each page.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'single_post_header_title',
					'type' => 'select',
					'title' => __( 'Blog Post Default Head Title', 'pinnacle' ),
					'options' => array(
						'category' => __( 'Category', 'pinnacle' ),
						'posttitle' => __( 'Post Title', 'pinnacle' ),
						'custom' => __( 'Custom', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'category',
				),
				array(
					'id' => 'default_showposttitle_below',
					'type' => 'switch',
					'title' => __( 'Show the post title below the header', 'pinnacle' ),
					'default' => 1,
					'required' => array( 'single_post_header_title', '=', 'posttitle' ),
				),
				array(
					'id' => 'post_header_title_text',
					'type' => 'text',
					'title' => __( 'Post Default Title', 'pinnacle' ),
					'subtitle' => __( 'Example: Blog', 'pinnacle' ),
					'required' => array( 'single_post_header_title', '=', 'custom' ),
				),
				array(
					'id' => 'post_header_subtitle_text',
					'type' => 'text',
					'title' => __( 'Post Default Subtitle', 'pinnacle' ),
					'required' => array( 'single_post_header_title', '=', 'custom' ),
				),
				array(
					'id' => 'single_post_title_output',
					'type' => 'select',
					'title' => __( 'Blog Post non-Head Title Output', 'pinnacle' ),
					'options' => array(
						'h1' => __( 'Use H1 tag', 'pinnacle' ),
						'h2' => __( 'Use H2 tag', 'pinnacle' ),
						'none' => __( 'Do not display', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'customizer' => false,
					'default' => 'h1',
				),
				array(
					'id' => 'info_blog_defaults',
					'type' => 'info',
					'desc' => __( 'Blog Post Defaults', 'pinnacle' ),
				),
				array(
					'id' => 'blogpost_sidebar_default',
					'type' => 'select',
					'title' => __( 'Blog Post Sidebar Default', 'pinnacle' ),
					'options' => array(
						'yes' => __( 'Yes, Show', 'pinnacle' ),
						'no' => __( 'No, Do not Show', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'yes',
				),
				array(
					'id' => 'post_author_default',
					'type' => 'select',
					'title' => __( 'Blog Post Author Box Default', 'pinnacle' ),
					'options' => array(
						'no' => __( 'No, Do not Show', 'pinnacle' ),
						'yes' => __( 'Yes, Show', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'no',
				),
				array(
					'id' => 'post_carousel_default',
					'type' => 'select',
					'title' => __( 'Blog Post Bottom Carousel Default', 'pinnacle' ),
					'options' => array(
						'no' => __( 'No, Do not Show', 'pinnacle' ),
						'recent' => __( 'Yes - Display Recent Posts', 'pinnacle' ),
						'similar' => __( 'Yes - Display Similar Posts', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'no',
				),
				array(
					'id' => 'post_carousel_columns',
					'type' => 'slider',
					'title' => __( 'Choose how many items to show on recent/similar post carousel.', 'pinnacle' ),
					'default'       => '3',
					'min'       => '3',
					'step'      => '1',
					'max'       => '6',
				),
				array(
					'id' => 'post_summery_default_image',
					'type' => 'media',
					'url' => true,
					'title' => __( 'Default post summary feature Image', 'pinnacle' ),
					'subtitle' => __( 'Replace theme default feature image for posts without a featured image', 'pinnacle' ),
				),
				array(
					'id' => 'info_blog_defaults_stand',
					'type' => 'info',
					'desc' => __( 'Blog Post Defaults Standard', 'pinnacle' ),
				),
				array(
					'id' => 'post_summery_default',
					'type' => 'select',
					'title' => __( 'Standard Blog Post Summary Default', 'pinnacle' ),
					'options' => array(
						'text' => __( 'Text', 'pinnacle' ),
						'img_portrait' => __( 'Portrait Image', 'pinnacle' ),
						'img_landscape' => __( 'Landscape Image', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'img_landscape',
				),
				array(
					'id' => 'info_blog_defaults_image',
					'type' => 'info',
					'desc' => __( 'Blog Post Defaults Image', 'pinnacle' ),
				),
				array(
					'id' => 'image_post_summery_default',
					'type' => 'select',
					'title' => __( 'Image Blog Post Summary Default', 'pinnacle' ),
					'options' => array(
						'text' => __( 'Text', 'pinnacle' ),
						'img_portrait' => __( 'Portrait Image', 'pinnacle' ),
						'img_landscape' => __( 'Landscape Image', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'img_portrait',
				),
				array(
					'id' => 'image_post_blog_default',
					'type' => 'select',
					'title' => __( 'Single Image Post Head Content', 'pinnacle' ),
					'options' => array(
						'none' => __( 'None', 'pinnacle' ),
						'image' => __( 'Image', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'image',
				),
				array(
					'id' => 'info_blog_defaults_gallery',
					'type' => 'info',
					'desc' => __( 'Blog Post Defaults gallery', 'pinnacle' ),
				),
				array(
					'id' => 'gallery_post_summery_default',
					'type' => 'select',
					'title' => __( 'Gallery Blog Post Summary Default', 'pinnacle' ),
					'options' => array(
						'text' => __( 'Text', 'pinnacle' ),
						'img_portrait' => __( 'Portrait Image', 'pinnacle' ),
						'img_landscape' => __( 'Landscape Image', 'pinnacle' ),
						'slider_portrait' => __( 'Portrait Slider', 'pinnacle' ),
						'slider_landscape' => __( 'Landscape Slider', 'pinnacle' ),
						'gallery_grid' => __( 'Gallery Grid', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'slider_landscape',
				),
				array(
					'id' => 'gallery_post_blog_default',
					'type' => 'select',
					'title' => __( 'Single Gallery Post Head Content', 'pinnacle' ),
					'options' => array(
						'none' => __( 'None', 'pinnacle' ),
						'flex' => __( 'Image Slider (Flex Slider)', 'pinnacle' ),
						'carouselslider' => __( 'Carousel Slider (Caroufedsel Slider)', 'pinnacle' ),
						'carousel' => __( 'Image Carousel (Caroufedsel Carousel)', 'pinnacle' ),
						'shortcode' => __( 'Shortcode', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'flex',
				),
				array(
					'id' => 'info_blog_defaults_video',
					'type' => 'info',
					'desc' => __( 'Blog Post Defaults Video', 'pinnacle' ),
				),
				array(
					'id' => 'video_post_summery_default',
					'type' => 'select',
					'title' => __( 'Video Blog Post Summary Default', 'pinnacle' ),
					'options' => array(
						'text' => __( 'Text', 'pinnacle' ),
						'img_portrait' => __( 'Portrait Image', 'pinnacle' ),
						'img_landscape' => __( 'Landscape Image', 'pinnacle' ),
						'video' => __( 'Video', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'video',
				),
				array(
					'id' => 'video_post_blog_default',
					'type' => 'select',
					'title' => __( 'Single Video Post Head Content', 'pinnacle' ),
					'options' => array(
						'none' => __( 'None', 'pinnacle' ),
						'video' => __( 'Video', 'pinnacle' ),
						'shortcode' => __( 'Shortcode', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'video',
				),
				array(
					'id' => 'info_blog_category',
					'type' => 'info',
					'desc' => __( 'Blog Category/Archive Defaults', 'pinnacle' ),
				),
				array(
					'id' => 'category_post_summary',
					'type' => 'select',
					'title' => __( 'Category Display Type', 'pinnacle' ),
					'options' => array(
						'summary' => __( 'Normal Post Excerpt', 'pinnacle' ),
						'full' => __( 'Normal Full Post', 'pinnacle' ),
						'grid' => __( 'Grid Post', 'pinnacle' ),
						'photo' => __( 'Photo Post', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'summary',
				),
				array(
					'id' => 'category_post_grid_columns',
					'type' => 'select',
					'title' => __( 'Category Grid Columns', 'pinnacle' ),
					'options' => array(
						'2' => __( 'Two', 'pinnacle' ),
						'3' => __( 'Three', 'pinnacle' ),
						'4' => __( 'Four', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => '3',
					'required' => array( 'category_post_summary', '=', array( 'grid', 'photo' ) ),
				),
				array(
					'id' => 'blog_cat_layout',
					'type' => 'image_select',
					'compiler' => false,
					'title' => __( 'Display the sidebar on blog archives?', 'pinnacle' ),
					'subtitle' => __( 'This determines if there is a sidebar on the blog category pages.', 'pinnacle' ),
					'options' => array(
						'full' => array(
							'alt' => 'Full Layout',
							'img' => OPTIONS_PATH . 'img/1col.png',
						),
						'sidebar' => array(
							'alt' => 'Sidebar Layout',
							'img' => OPTIONS_PATH . 'img/2cr.png',
						),
					),
					'default' => 'sidebar',
				),
				array(
					'id' => 'blog_cat_sidebar',
					'type' => 'select',
					'title' => __( 'Choose a Sidebar for your Category/Archive Pages', 'pinnacle' ),
					'data' => 'sidebars',
					'default' => 'sidebar-primary',
					'width' => 'width:60%',
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-file',
			'icon_class' => 'icon-large',
			'title' => __( 'Page Options', 'pinnacle' ),
			'id' => 'page_options',
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Page Options', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'page_comments',
					'type' => 'switch',
					'title' => __( 'Allow Comments on Pages', 'pinnacle' ),
					'subtitle' => __( 'Turn on to allow comments on pages.', 'pinnacle' ),
					'default' => 0,
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-palette',
			'icon_class' => 'icon-large',
			'id' => 'basic_styling',
			'title' => __( 'Basic Styling', 'pinnacle' ),
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Basic Stylng', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'skin_stylesheet',
					'type' => 'select',
					'title' => __( 'Theme Skin Stylesheet', 'pinnacle' ),
					'subtitle' => __( 'Note* changes made in options panel will override this stylesheet. Example: Colors set in typography.', 'pinnacle' ),
					'options' => $alt_stylesheets,
					'default' => 'default.css',
					'width' => 'width:60%',
					'customizer' => true,
				),
				array(
					'id' => 'primary_color',
					'type' => 'color',
					'title' => __( 'Primary Color', 'pinnacle' ),
					'subtitle' => __( 'Choose the default Highlight color for your site.', 'pinnacle' ),
					'transparent' => false,
					'validate' => 'color',
					'customizer' => true,
					'hint' => array(
						'title'   => __( 'Choose the default Highlight color for your site.', 'pinnacle' ),
					),
				),
				array(
					'id' => 'primary20_color',
					'type' => 'color',
					'title' => __( 'Primary Hover Color', 'pinnacle' ),
					'subtitle' => __( 'Recomended to be 20% lighter than primary color', 'pinnacle' ),
					'default' => '',
					'transparent' => false,
					'validate' => 'color',
					'customizer' => true,
					'hint' => array(
						'title'   => __( 'Recomended to be 20% lighter than primary color', 'pinnacle' ),
					),
				),
				array(
					'id' => 'gray_font_color',
					'type' => 'color',
					'title' => __( 'Sitewide Gray Fonts', 'pinnacle' ),
					'default' => '',
					'transparent' => false,
					'validate' => 'color',
					'customizer' => true,
				),
				array(
					'id' => 'footerfont_color',
					'type' => 'color',
					'title' => __( 'Footer Font Color', 'pinnacle' ),
					'default' => '',
					'transparent' => false,
					'validate' => 'color',
					'customizer' => true,
				),
				array(
					'id' => 'breadcrumbs_color',
					'type' => 'color',
					'title' => __( 'Breadcrumbs Color', 'pinnacle' ),
					'default' => '',
					'transparent' => false,
					'validate' => 'color',
					'output'    => array( '#kadbreadcrumbs, #kadbreadcrumbs a, .portfolionav a' ),
					'customizer' => true,
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-paint-format',
			'icon_class' => 'icon-large',
			'customizer' => false,
			'id' => 'advanced_styling',
			'title' => __( 'Advanced Styling', 'pinnacle' ),
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Main Content Background', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id'        => 'content_background',
					'type'      => 'background',
					'output'    => array( '.contentclass' ),
					'title'     => __( 'Content Background', 'pinnacle' ),
					'customizer' => true,
				),
				array(
					'id' => 'info_topbar_background',
					'type' => 'info',
					'desc' => __( 'Topbar Background', 'pinnacle' ),
					'customizer' => true,
				),
				array(
					'id'        => 'topbar_background',
					'type'      => 'background',
					'output'    => array( '.topclass' ),
					'title'     => __( 'Topbar Background', 'pinnacle' ),
					'customizer' => true,
				),
				array(
					'id' => 'info_header_background',
					'type' => 'info',
					'desc' => __( 'Header Background', 'pinnacle' ),
					'customizer' => true,
				),
				array(
					'id' => 'header_background_choice',
					'type' => 'select',
					'title' => __( 'Header Background Style', 'pinnacle' ),
					'options' => array(
						'simple' => __( 'Simple', 'pinnacle' ),
						'full' => __( 'Full', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => 'simple',
					'customizer' => true,
				),
				array(
					'id'        => 'header_background',
					'type'      => 'background',
					'output'    => array( '.is-sticky .headerclass', '.none-trans-header .headerclass' ),
					'title'     => __( 'Header Background', 'pinnacle' ),
					'required' => array( 'header_background_choice', '=', 'full' ),
					'customizer' => true,
				),
				array(
					'id' => 'header_background_color',
					'type' => 'color',
					'title' => __( 'Header Background Color', 'pinnacle' ),
					'default' => '',
					'transparent' => false,
					'customizer' => true,
					'validate' => 'color',
					'required' => array( 'header_background_choice', '=', 'simple' ),
				),
				array(
					'id' => 'header_background_transparency',
					'type' => 'select',
					'title' => __( 'If background is color, select Transparency', 'pinnacle' ),
					'options' => array(
						'1' => '1',
						'0.9' => '0.9',
						'0.8' => '0.8',
						'0.7' => '0.7',
						'0.6' => '0.6',
						'0.5' => '0.5',
						'0.4' => '0.4',
						'0.3' => '0.3',
						'0.2' => '0.2',
						'0.1' => '0.1',
						'0' => '0',
					),
					'default' => '1',
					'customizer' => true,
					'width' => 'width:60%',
					'required' => array( 'header_background_choice', '=', 'simple' ),
				),
				array(
					'id' => 'info_menu_background',
					'type' => 'info',
					'desc' => __( 'Menu Background', 'pinnacle' ),
					'customizer' => true,
				),
				array(
					'id'        => 'menu_background',
					'type'      => 'background',
					'output'    => array( '.kad-primary-nav > ul' ),
					'title'     => __( 'Menu Background', 'pinnacle' ),
					'customizer' => true,
				),
				array(
					'id' => 'info_mobile_background',
					'type' => 'info',
					'desc' => __( 'Mobile Menu Background', 'pinnacle' ),
					'customizer' => true,
				),
				array(
					'id'        => 'mobile_background',
					'type'      => 'background',
					'output'    => array( '.mobileclass' ),
					'title'     => __( 'Mobile Menu Background', 'pinnacle' ),
					'customizer' => true,
				),
				array(
					'id' => 'info_post_background',
					'type' => 'info',
					'desc' => __( 'Post and Page Content area Background', 'pinnacle' ),
					'customizer' => true,
				),
				array(
					'id'        => 'post_background',
					'type'      => 'background',
					'output'    => array( '.postclass' ),
					'title'     => __( 'Post Background', 'pinnacle' ),
					'customizer' => true,
				),
				array(
					'id' => 'info_feature_background',
					'type' => 'info',
					'desc' => __( 'Feature Background', 'pinnacle' ),
				),
				array(
					'id'        => 'feature_background',
					'type'      => 'background',
					'output'    => array( '.panel-row-style-wide-feature' ),
					'title'     => __( 'Feature Background', 'pinnacle' ),
					'subtitle'  => __( 'This is for the feature row style in pagebuilder.', 'pinnacle' ),
				),
				array(
					'id' => 'info_footer_background',
					'type' => 'info',
					'desc' => __( 'Footer Background', 'pinnacle' ),
					'customizer' => true,
				),
				array(
					'id'        => 'footer_background',
					'type'      => 'background',
					'output'    => array( '.footerclass' ),
					'customizer' => true,
					'title'     => __( 'Footer Background', 'pinnacle' ),
				),
				array(
					'id' => 'info_body_background',
					'type' => 'info',
					'customizer' => true,
					'desc' => __( 'Body Background', 'pinnacle' ),
				),
				array(
					'id'        => 'body_background',
					'type'      => 'background',
					'output'    => array( 'body' ),
					'customizer' => true,
					'title'     => __( 'Body Background', 'pinnacle' ),
					'subtitle'  => __( 'This shows if site is using the boxed layout option.', 'pinnacle' ),
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-font-size',
			'icon_class' => 'icon-large',
			'id' => 'typography',
			'title' => __( 'Typography', 'pinnacle' ),
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Header Font Options', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'font_h1',
					'type' => 'typography',
					'title' => __( 'H1 Headings', 'pinnacle' ),
					'font-family' => true,
					'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
					'font-backup' => false, // Select a backup non-google font in addition to a google font
					'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
					'subsets' => true, // Only appears if google is true and subsets not set to false
					'font-size' => true,
					'line-height' => true,
					'text-align' => false,
					'all_styles' => true,
					'customizer' => true,
					'color' => true,
					'preview' => true, // Disable the previewer
					'output' => array( 'h1' ),
					'subtitle' => __( 'Choose Size and Style for h1 (This Styles Your Page Titles)', 'pinnacle' ),
					'default' => array(
						'font-family' => 'Raleway',
						'color' => '',
						'font-style' => '700',
						'font-size' => '44px',
						'line-height' => '50px',
					),
				),
				array(
					'id' => 'font_h2',
					'type' => 'typography',
					'title' => __( 'H2 Headings', 'pinnacle' ),
					// 'compiler'=>true, // Use if you want to hook in your own CSS compiler
					  'font-family' => true,
					'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
					'font-backup' => false, // Select a backup non-google font in addition to a google font
					'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
					'subsets' => true, // Only appears if google is true and subsets not set to false
					'font-size' => true,
					'line-height' => true,
					'customizer' => true,
					'text-align' => false,
					// 'word-spacing'=>false, // Defaults to false
					// 'all_styles' => true,
					'color' => true,
					'preview' => true, // Disable the previewer
					'output' => array( 'h2' ),
					'subtitle' => __( 'Choose Size and Style for h2', 'pinnacle' ),
					'default' => array(
						'font-family' => 'Raleway',
						'color' => '',
						'font-style' => '400',
						'font-size' => '32px',
						'line-height' => '40px',
					),
				),
				array(
					'id' => 'font_h3',
					'type' => 'typography',
					'title' => __( 'H3 Headings', 'pinnacle' ),
					// 'compiler'=>true, // Use if you want to hook in your own CSS compiler
					'font-family' => true,
					'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
					'font-backup' => false, // Select a backup non-google font in addition to a google font
					'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
					'subsets' => true, // Only appears if google is true and subsets not set to false
					'font-size' => true,
					'line-height' => true,
					'customizer' => true,
					'text-align' => false,
					// 'word-spacing'=>false, // Defaults to false
					// 'all_styles' => true,
					'color' => true,
					'preview' => true, // Disable the previewer
					'output' => array( 'h3' ),
					'subtitle' => __( 'Choose Size and Style for h3', 'pinnacle' ),
					'default' => array(
						'font-family' => 'Raleway',
						'color' => '',
						'font-style' => '400',
						'font-size' => '26px',
						'line-height' => '40px',
					),
				),
				array(
					'id' => 'font_h4',
					'type' => 'typography',
					'title' => __( 'H4 Headings', 'pinnacle' ),
					// 'compiler'=>true, // Use if you want to hook in your own CSS compiler
					'font-family' => true,
					'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
					'font-backup' => false, // Select a backup non-google font in addition to a google font
					'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
					'subsets' => true, // Only appears if google is true and subsets not set to false
					'font-size' => true,
					'line-height' => true,
					'customizer' => true,
					'text-align' => false,
					// 'word-spacing'=>false, // Defaults to false
					// 'all_styles' => true,
					'color' => true,
					'preview' => true, // Disable the previewer
					'output' => array( 'h4' ),
					'subtitle' => __( 'Choose Size and Style for h4', 'pinnacle' ),
					'default' => array(
						'font-family' => 'Raleway',
						'color' => '',
						'font-style' => '400',
						'font-size' => '24px',
						'line-height' => '34px',
					),
				),
				array(
					'id' => 'font_h5',
					'type' => 'typography',
					'title' => __( 'H5 Headings', 'pinnacle' ),
					// 'compiler'=>true, // Use if you want to hook in your own CSS compiler
					'font-family' => true,
					'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
					'font-backup' => false, // Select a backup non-google font in addition to a google font
					'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
					'subsets' => true, // Only appears if google is true and subsets not set to false
					'font-size' => true,
					'text-align' => false,
					'customizer' => true,
					'line-height' => true,
					'color' => true,
					'preview' => true, // Disable the previewer
					'output' => array( 'h5' ),
					'subtitle' => __( 'Choose Size and Style for h5', 'pinnacle' ),
					'default' => array(
						'font-family' => 'Raleway',
						'color' => '',
						'font-style' => '400',
						'font-size' => '18px',
						'line-height' => '26px',
					),
				),
				array(
					'id' => 'font_subtitle',
					'type' => 'typography',
					'title' => __( 'Page Subtitle', 'pinnacle' ),
					'font-family' => true,
					'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
					'font-backup' => false, // Select a backup non-google font in addition to a google font
					'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
					'subsets' => true, // Only appears if google is true and subsets not set to false
					'font-size' => true,
					'text-align' => false,
					'customizer' => true,
					'line-height' => true,
					'color' => true,
					'preview' => true, // Disable the previewer
					'output' => array( '.subtitle' ),
					'subtitle' => __( 'Choose Size and Style for Page Subtitle', 'pinnacle' ),
					'default' => array(
						'font-family' => 'Raleway',
						'color' => '',
						'font-style' => '400',
						'font-size' => '16px',
						'line-height' => '22px',
					),
				),
				array(
					'id' => 'info_body_font',
					'type' => 'info',
					'desc' => __( 'Body Font Options', 'pinnacle' ),
				),
				array(
					'id' => 'font_p',
					'type' => 'typography',
					'title' => __( 'Body Font', 'pinnacle' ),
					// 'compiler'=>true, // Use if you want to hook in your own CSS compiler
					'font-family' => true,
					'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
					'font-backup' => false, // Select a backup non-google font in addition to a google font
					'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
					'subsets' => true, // Only appears if google is true and subsets not set to false
					'font-size' => true,
					'line-height' => true,
					'customizer' => true,
					'text-align' => false,
					// 'word-spacing'=>false, // Defaults to false
					'all_styles' => true,
					'color' => true,
					'preview' => true, // Disable the previewer
					'output' => array( 'body' ),
					'subtitle' => __( 'Choose Size and Style for paragraphs', 'pinnacle' ),
					'default' => array(
						'font-family' => '',
						'color' => '',
						'font-style' => '400',
						'font-size' => '14px',
						'line-height' => '20px',
					),
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-menu3',
			'icon_class' => 'icon-large',
			'id' => 'menu_settings',
			'title' => __( 'Menu Settings', 'pinnacle' ),
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Primary Menu Options', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'menu_search',
					'type' => 'switch',
					'title' => __( 'Enable Search in Primary Menu?', 'pinnacle' ),
					'subtitle' => __( 'Choose to enable a search button in the header menu', 'pinnacle' ),
					'default' => 1,
					'customizer' => true,
				),
				array(
					'id' => 'menu_search_products',
					'type' => 'switch',
					'title' => __( 'Make menu search results only products?', 'pinnacle' ),
					'subtitle' => __( 'This will change the menu search to a woocommerce search.', 'pinnacle' ),
					'default'       => 0,
				),
				array(
					'id' => 'menu_cart',
					'type' => 'switch',
					'title' => __( 'Enable cart Button in Primary Menu?', 'pinnacle' ),
					'subtitle' => __( 'Choose to enable a Cart button in the header menu', 'pinnacle' ),
					'default' => 0,
					'customizer' => true,
				),
				array(
					'id' => 'font_primary_menu',
					'type' => 'typography',
					'title' => __( 'Primary Menu Font', 'pinnacle' ),
					// 'compiler'=>true, // Use if you want to hook in your own CSS compiler
					'font-family' => true,
					'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
					'font-backup' => false, // Select a backup non-google font in addition to a google font
					'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
					'subsets' => true, // Only appears if google is true and subsets not set to false
					'font-size' => true,
					'line-height' => false,
					'text-align' => false,
					'customizer' => true,
					// 'word-spacing'=>false, // Defaults to false
					// 'all_styles' => true,
					'color' => true,
					'preview' => true, // Disable the previewer
					'output' => array( '.is-sticky .kad-primary-nav ul.sf-menu a, ul.sf-menu a, .none-trans-header .kad-primary-nav ul.sf-menu a' ),
					'subtitle' => __( 'Choose Size and Style for primary menu', 'pinnacle' ),
					'default' => array(
						'font-family' => 'Raleway',
						'color' => '#444444',
						'font-style' => '400',
						'font-size' => '16px',
					),
				),
				array(
					'id' => 'primarymenu_hover_color',
					'type' => 'color',
					'title' => __( 'Hover and Active Font Color', 'pinnacle' ),
					'output'    => array( 'color' => '.kad-primary-nav ul.sf-menu > li > a:hover, .kad-primary-nav ul.sf-menu > li.sfHover > a, .kad-primary-nav ul.sf-menu > li.current-menu-item > a' ),
					'transparent' => false,
					'customizer' => true,
					'validate' => 'color',
				),
				array(
					'id' => 'primarymenu_hover_bg_color',
					'type' => 'color',
					'title' => __( 'Hover and Active Background Color', 'pinnacle' ),
					'output'    => array( 'background' => '.kad-primary-nav ul.sf-menu > li > a:hover, .kad-primary-nav ul.sf-menu > li.sfHover > a, .kad-primary-nav ul.sf-menu > li.current-menu-item > a' ),
					'transparent' => false,
					'customizer' => true,
					'validate' => 'color',
				),
				array(
					'id' => 'info_dropdown_menu_settings',
					'type' => 'info',
					'customizer' => true,
					'desc' => __( 'Dropdown Menu Style', 'pinnacle' ),
				),
				array(
					'id' => 'dropdown_background_color',
					'type' => 'color',
					'title' => __( 'Dropdown Background Color', 'pinnacle' ),
					'output'    => array( 'background' => '.kad-primary-nav .sf-menu ul' ),
					'transparent' => false,
					'customizer' => true,
					'validate' => 'color',
				),
				array(
					'id' => 'dropdown_menu_font_size',
					'type' => 'typography',
					'title' => __( 'Dropdown Menu Font size', 'pinnacle' ),
					// 'compiler'=>true, // Use if you want to hook in your own CSS compiler
					'font-family' => false,
					'google' => false, // Disable google fonts. Won't work if you haven't defined your google api key
					'font-backup' => false, // Select a backup non-google font in addition to a google font
					'font-style' => false, // Includes font-style and weight. Can use font-style or font-weight to declare
					'subsets' => false, // Only appears if google is true and subsets not set to false
					'font-size' => true,
					'font-weight' => false,
					'text-transform' => false,
					'line-height' => false,
					'text-align' => false,
					// 'word-spacing'=>false, // Defaults to false
					'all_styles' => false,
					'color' => true,
					'customizer' => true,
					'preview' => false, // Disable the previewer
					'output' => array( '.kad-header-style-basic .kad-primary-nav ul.sf-menu ul li a' ),
					'subtitle' => __( 'Choose Size and color for the Dropdown menus', 'pinnacle' ),
					'default' => array(
						'font-size' => '13px',
					),
				),
				array(
					'id' => 'dropdown_item_background_hover',
					'type' => 'color',
					'title' => __( 'Item Background Hover Color', 'pinnacle' ),
					'transparent' => true,
					'customizer' => true,
					'output'    => array( 'background' => '#kad-banner .kad-primary-nav ul.sf-menu ul li a:hover, #kad-banner .kad-primary-nav ul.sf-menu ul li.current-menu-item a' ),
					'validate' => 'color',
				),

				array(
					'id' => 'info_menu_mobile_font',
					'type' => 'info',
					'customizer' => true,
					'desc' => __( 'Mobile Menu Options', 'pinnacle' ),
				),
				array(
					'id' => 'mobile_submenu_collapse',
					'type' => 'switch',
					'title' => __( 'Submenu items collapse until opened', 'pinnacle' ),
					'default' => 0,
					'customizer' => true,
				),
				array(
					'id' => 'font_mobile_menu',
					'type' => 'typography',
					'title' => __( 'Mobile Menu Font', 'pinnacle' ),
					// 'compiler'=>true, // Use if you want to hook in your own CSS compiler
					'font-family' => true,
					'customizer' => true,
					'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
					'font-backup' => false, // Select a backup non-google font in addition to a google font
					'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
					'subsets' => true, // Only appears if google is true and subsets not set to false
					'font-size' => true,
					'line-height' => true,
					'text-align' => false,
					// 'word-spacing'=>false, // Defaults to false
					// 'all_styles' => true,
					'color' => true,
					'preview' => true, // Disable the previewer
					'output' => array( '.kad-nav-inner .kad-mnav, .kad-mobile-nav .kad-nav-inner li a, .kad-mobile-nav .kad-nav-inner li .kad-submenu-accordion' ),
					'subtitle' => __( 'Choose Size and Style for Mobile Menu', 'pinnacle' ),
					'default' => array(
						'font-family' => 'Raleway',
						'color' => '',
						'font-style' => '400',
						'font-size' => '16px',
						'line-height' => '20px',
					),
				),
				array(
					'id' => 'mobilemenu_hover_color',
					'type' => 'color',
					'customizer' => true,
					'title' => __( 'Mobile Hover and Active Font Color', 'pinnacle' ),
					'output'    => array( 'color' => '.kad-mobile-nav .kad-nav-inner li.current-menu-item>a, .kad-mobile-nav .kad-nav-inner li a:hover, #kad-banner #mobile-nav-trigger a.nav-trigger-case:hover .kad-menu-name, #kad-banner #mobile-nav-trigger a.nav-trigger-case:hover .kad-navbtn' ),
					'transparent' => false,
					'validate' => 'color',
				),
				array(
					'id' => 'mobilemenu_hover_bg_color',
					'type' => 'color',
					'title' => __( 'Mobile Hover and Active Background Color', 'pinnacle' ),
					'output'    => array( 'background' => '.kad-mobile-nav .kad-nav-inner li.current-menu-item>a, .kad-mobile-nav .kad-nav-inner li a:hover, #kad-banner #mobile-nav-trigger a.nav-trigger-case:hover .kad-menu-name, #kad-banner #mobile-nav-trigger a.nav-trigger-case:hover .kad-navbtn' ),
					'transparent' => false,
					'customizer' => true,
					'validate' => 'color',
				),
				array(
					'id' => 'info_menu_topbar_font',
					'type' => 'info',
					'customizer' => true,
					'desc' => __( 'Topbar Menu Options', 'pinnacle' ),
				),
				array(
					'id' => 'topbar-menu-font-size',
					'type' => 'typography',
					'title' => __( 'Topbar Menu Font', 'pinnacle' ),
					'font-family' => true,
					'customizer' => true,
					'google' => true, // Disable google fonts. Won't work if you haven't defined your google api key
					'font-backup' => false, // Select a backup non-google font in addition to a google font
					'font-style' => true, // Includes font-style and weight. Can use font-style or font-weight to declare
					'subsets' => true, // Only appears if google is true and subsets not set to false
					'font-size' => true,
					'line-height' => false,
					'text-align' => false,
					'color' => true,
					'preview' => true, // Disable the previewer
					'output' => array( '#topbar ul.sf-menu > li > a, #topbar .top-menu-cart-btn, #topbar .top-menu-search-btn, #topbar .nav-trigger-case .kad-navbtn, #topbar .topbarsociallinks li a' ),
					'subtitle' => __( 'Choose Size and Style for topbar menu', 'pinnacle' ),
					'default' => array(
						'font-family' => 'Raleway',
						'color' => '',
						'font-style' => '400',
						'font-size' => '11px',
					),
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-bubbles',
			'icon_class' => 'icon-large',
			'customizer' => false,
			'id' => 'language_settings',
			'title' => __( 'Language Settings', 'pinnacle' ),
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Quick Language Settings', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'search_placeholder_text',
					'type' => 'text',
					'title' => __( 'Search Placeholder Text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Search"', 'pinnacle' ),
				),
				array(
					'id' => 'cart_placeholder_text',
					'type' => 'text',
					'title' => __( 'Menu Cart Text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Your Cart', 'pinnacle' ),
				),
				array(
					'id' => 'sold_placeholder_text',
					'type' => 'text',
					'title' => __( 'Product Sold Text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Sold', 'pinnacle' ),
				),
				array(
					'id' => 'sale_placeholder_text',
					'type' => 'text',
					'title' => __( 'Product Sale Text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Sale', 'pinnacle' ),
				),
				array(
					'id' => 'notavailable_placeholder_text',
					'type' => 'text',
					'title' => __( 'Not Available Text (radio button tooltip)', 'pinnacle' ),
					'subtitle' => __( 'Standard: Not Available', 'pinnacle' ),
				),
				array(
					'id' => 'post_readmore_text',
					'type' => 'text',
					'title' => __( 'Post READ MORE text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Read More', 'pinnacle' ),
				),
				array(
					'id' => 'post_by_text',
					'type' => 'text',
					'title' => __( 'Post Author BY text', 'pinnacle' ),
					'subtitle' => __( 'Standard: by', 'pinnacle' ),
				),
				array(
					'id' => 'post_on_text',
					'type' => 'text',
					'title' => __( 'Post Data ON text', 'pinnacle' ),
					'subtitle' => __( 'Standard: on', 'pinnacle' ),
				),
				array(
					'id' => 'post_with_text',
					'type' => 'text',
					'title' => __( 'Post Comment WITH text', 'pinnacle' ),
					'subtitle' => __( 'Standard: with', 'pinnacle' ),
				),
				array(
					'id' => 'filter_all_text',
					'type' => 'text',
					'title' => __( 'Dynamic filter All text', 'pinnacle' ),
					'subtitle' => __( 'Standard: All', 'pinnacle' ),
				),
				array(
					'id' => 'shop_filter_text',
					'type' => 'text',
					'title' => __( 'Mobile dynamic Filter Products text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Filter Products', 'pinnacle' ),
				),
				array(
					'id' => 'portfolio_filter_text',
					'type' => 'text',
					'title' => __( 'Mobile dynamic Filter Projects text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Filter Projects', 'pinnacle' ),
				),
				array(
					'id' => 'portfolio_viewdetails_text',
					'type' => 'text',
					'title' => __( 'Portfolio View Details text', 'pinnacle' ),
					'subtitle' => __( 'Standard: View Details', 'pinnacle' ),
				),
				array(
					'id' => 'wc_clear_placeholder_text',
					'type' => 'text',
					'title' => __( 'Product Page: Clear Selection Text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Clear selection', 'pinnacle' ),
				),
				array(
					'id' => 'description_tab_text',
					'type' => 'text',
					'title' => __( 'Product Page: Description tab text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Description', 'pinnacle' ),
				),
				array(
					'id' => 'description_header_text',
					'type' => 'text',
					'title' => __( 'Product Page: Description header text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Product Description', 'pinnacle' ),
				),
				array(
					'id' => 'additional_information_tab_text',
					'type' => 'text',
					'title' => __( 'Product Page: Additional Information tab text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Additional Information', 'pinnacle' ),
				),
				array(
					'id' => 'additional_information_header_text',
					'type' => 'text',
					'title' => __( 'Product Page: Additional Information Header text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Additional Information', 'pinnacle' ),
				),
				array(
					'id' => 'video_tab_text',
					'type' => 'text',
					'title' => __( 'Product Page: Product Video tab text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Product Video', 'pinnacle' ),
				),
				array(
					'id' => 'video_title_text',
					'type' => 'text',
					'title' => __( 'Product Page: Product Video Header text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Product Video', 'pinnacle' ),
				),
				array(
					'id' => 'reviews_tab_text',
					'type' => 'text',
					'title' => __( 'Product Page: Reviews tab text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Reviews', 'pinnacle' ),
				),
				array(
					'id' => 'related_products_text',
					'type' => 'text',
					'title' => __( 'Product Page: Related Products text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Related Products', 'pinnacle' ),
				),
				array(
					'id' => 'wc_upsell_products_text',
					'type' => 'text',
					'title' => __( 'Product Page: You may also like... text', 'pinnacle' ),
					'subtitle' => __( 'Standard: You may also like&hellip;', 'pinnacle' ),
				),
				array(
					'id' => 'lightbox_loading_text',
					'type' => 'text',
					'title' => __( 'LightBox: Loading text', 'pinnacle' ),
					'subtitle' => __( 'Standard: Loading...', 'pinnacle' ),
				),
				array(
					'id' => 'lightbox_of_text',
					'type' => 'text',
					'title' => __( 'LightBox: of text', 'pinnacle' ),
					'subtitle' => __( 'Standard: of', 'pinnacle' ),
				),
				array(
					'id' => 'lightbox_error_text',
					'type' => 'text',
					'title' => __( 'LightBox: Error text', 'pinnacle' ),
					'subtitle' => __( 'Standard: The Image could not be loaded.', 'pinnacle' ),
				),
				array(
					'id' => 'contact_consent',
					'type' => 'text',
					'title' => __( 'Contact Form Consent Label', 'pinnacle' ),
					'subtitle' => __( 'Standard: Please check to consent to our privacy policy.', 'pinnacle' ),
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-link4',
			'icon_class' => 'icon-large',
			'customizer' => false,
			'title' => __( 'Breadcrumbs', 'pinnacle' ),
			'id' => 'breadcrumbs',
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Sitewide Breadcrumbs', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'show_breadcrumbs_shop',
					'type' => 'switch',
					'title' => __( 'Show Breadcrumbs on Shop Page?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide breadcrumbs on your Woocommerce pages and Categories', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'show_breadcrumbs_product',
					'type' => 'switch',
					'title' => __( 'Show Breadcrumbs on Products?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide breadcrumbs on your Woocommerce products', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'show_breadcrumbs_post',
					'type' => 'switch',
					'title' => __( 'Show Breadcrumbs on Blog Post?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide breadcrumbs on your single blog post', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'show_breadcrumbs_portfolio',
					'type' => 'switch',
					'title' => __( 'Show Breadcrumbs on Portfolio Post?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide breadcrumbs on your single portfolio posts', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'show_breadcrumbs_staff',
					'type' => 'switch',
					'title' => __( 'Show Breadcrumbs on Staff Post?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide breadcrumbs on your single staff posts', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'staff_link',
					'type' => 'select',
					'data' => 'pages',
					'width' => 'width:60%',
					'title' => __( 'All Staff Post Page', 'pinnacle' ),
					'subtitle' => __( 'This sets the link for your main staff page, for breadcrumbs.', 'pinnacle' ),
					'required' => array( 'show_breadcrumbs_staff', '=', '1' ),
				),
				array(
					'id' => 'show_breadcrumbs_testimonial',
					'type' => 'switch',
					'title' => __( 'Show Breadcrumbs on Testimonial Post?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide breadcrumbs on your single testimonial posts', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'testimonial_link',
					'type' => 'select',
					'data' => 'pages',
					'width' => 'width:60%',
					'title' => __( 'All Testimonial Post Page', 'pinnacle' ),
					'subtitle' => __( 'This sets the link for your main testimonial page, for breadcrumbs.', 'pinnacle' ),
					'required' => array( 'show_breadcrumbs_testimonial', '=', '1' ),
				),
				array(
					'id' => 'show_breadcrumbs_page',
					'type' => 'switch',
					'title' => __( 'Show Breadcrumbs on Pages?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide breadcrumbs on your pages and categories', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'show_breadcrumbs_archive',
					'type' => 'switch',
					'title' => __( 'Show Breadcrumbs on Archives?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide breadcrumbs on your pages and categories', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'home_breadcrumb_text',
					'type' => 'text',
					'title' => __( 'Home title for breadcrumbs', 'pinnacle' ),
					'subtitle' => __( 'Standard: Home', 'pinnacle' ),
				),
				array(
					'id' => 'blog_link',
					'type' => 'select',
					'data' => 'pages',
					'width' => 'width:60%',
					'title' => __( 'All Blog Post Page', 'pinnacle' ),
					'subtitle' => __( 'This sets the link for your main blog page, for breadcrumbs. Use only if your blog page is not your home page.', 'pinnacle' ),
				),
				array(
					'id' => 'shop_breadcrumbs',
					'type' => 'switch',
					'title' => __( 'Show Shop page in breadcrumbs?', 'pinnacle' ),
					'subtitle' => __( 'Choose to show or hide the shop page in breadcrumbs on your site', 'pinnacle' ),
					'default' => 1,
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-wrench',
			'icon_class' => 'icon-large',
			'id' => 'misc_settings',
			'customizer' => false,
			'title' => __( 'Misc Settings', 'pinnacle' ),
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Misc Settings', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'google_analytics',
					'type' => 'text',
					'title' => __( 'Google Analytics Tracking ID', 'pinnacle' ),
					'subtitle' => __( 'Paste your Google Analytics Tracking ID Here. (example: UA-########-#)', 'pinnacle' ),
				),
				array(
					'id' => 'google_analytics_anony',
					'type' => 'switch',
					'title' => __( 'Enable IP Anonymization in Google Analytics', 'pinnacle' ),
					'subtitle' => __( 'Anonymizes the last part of visitors IP address.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'select2_select',
					'type' => 'switch',
					'title' => __( 'Select2 Select', 'pinnacle' ),
					'subtitle' => __( 'Turn on or off the select2 select', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'pinnacle_custom_favicon',
					'type' => 'media',
					'preview' => true,
					'title' => __( 'Custom Favicon', 'pinnacle' ),
					'subtitle' => __( 'This is depreciated, use appearance > customizer > site identity.', 'pinnacle' ),
				),
				array(
					'id' => 'footer_text',
					'type' => 'textarea',
					'title' => __( 'Footer Copyright Text', 'pinnacle' ),
					'subtitle' => __( 'Write your own copyright text here. You can use the following shortcodes in your footer text: [copyright] [site-name] [the-year]', 'pinnacle' ),
					'default' => '[copyright] [the-year] [site-name] [theme-credit]',
				),
				array(
					'id' => 'info_search_sidebars',
					'type' => 'info',
					'desc' => __( 'Search Results', 'pinnacle' ),
				),
				array(
					'id' => 'search_sidebar',
					'type' => 'select',
					'title' => __( 'Search Results - Choose Sidebar', 'pinnacle' ),
					'data' => 'sidebars',
					'default' => 'sidebar-primary',
					'width' => 'width:60%',
				),
				array(
					'id'        => 'search_pageheader_background',
					'type'      => 'background',
					'output'    => array( '.search-results .titleclass' ),
					'title'     => __( 'Search Results Background', 'pinnacle' ),
				),
				array(
					'id' => 'info_sidebars',
					'type' => 'info',
					'desc' => __( 'Create Sidebars', 'pinnacle' ),
				),
				array(
					'id' => 'cust_sidebars',
					'type' => 'multi_text',
					'title' => __( 'Create Custom Sidebars', 'pinnacle' ),
					'subtitle' => __( 'Type new sidebar name into textbox', 'pinnacle' ),
					'default' => __( 'Extra Sidebar', 'pinnacle' ),
				),
				array(
					'id' => 'info_pagewidth',
					'type' => 'info',
					'desc' => __( 'Limit Max Page width', 'pinnacle' ),
				),
				array(
					'id' => 'page_max_width',
					'type' => 'switch',
					'title' => __( 'Limit Max Page to 940px', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'info_smoothscrolling',
					'type' => 'info',
					'desc' => __( 'Smooth Scrolling', 'pinnacle' ),
				),
				array(
					'id' => 'smooth_scrolling',
					'type' => 'select',
					'title' => __( 'Smooth Scrolling', 'pinnacle' ),
					'desc' => __('Please Note, while this can be considered a "cool" feature it is not always the best feature for your users. We suggest caution and testing if you are going to enable. At this point it is kept here for backwards compatibility and we do not recommend using it.', 'pinnacle'),
					'options' => array(
						'0' => __( 'Leave Off', 'pinnacle' ),
						'1' => __( 'Use - with scroll bar replacement', 'pinnacle' ),
						'2' => __( 'Use - no replacement of scroll bar (chrome browser only)', 'pinnacle' ),
					),
					'width' => 'width:60%',
					'default' => '0',
				),
				array(
					'id' => 'smooth_scrolling_hide',
					'type' => 'switch',
					'title' => __( 'Enable Auto Hide', 'pinnacle' ),
					'subtitle' => __( 'This hides the scroll bar then not scrolling.', 'pinnacle' ),
					'default' => 0,
					'required' => array( 'smooth_scrolling', '=', '1' ),
				),
				array(
					'id' => 'smooth_scrolling_background',
					'type' => 'switch',
					'title' => __( 'Hide Scroll background', 'pinnacle' ),
					'subtitle' => __( 'This hides the scroll bar background.', 'pinnacle' ),
					'default' => 0,
					'required' => array( 'smooth_scrolling', '=', '1' ),
				),
				array(
					'id' => 'info_wpgallerys',
					'type' => 'info',
					'desc' => __( 'Wordpress Galleries', 'pinnacle' ),
				),
				array(
					'id' => 'pinnacle_gallery',
					'type' => 'switch',
					'title' => __( 'Enable Pinnacle Galleries to override Wordpress', 'pinnacle' ),
					'subtitle' => __( 'Disable this if using a plugin to customize galleries, for example jetpack tiled gallery.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'pinnacle_gallery_masonry',
					'type' => 'switch',
					'title' => __( 'Use Masonry Feature on Pinnacle Galleries', 'pinnacle' ),
					'subtitle' => __( 'This allows for dynamic gallery grids with images of different height', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'gallery_captions',
					'type' => 'switch',
					'title' => __( 'Show captions on Pinnacle Galleries', 'pinnacle' ),
					'subtitle' => __( 'This sets the default caption setting to true.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'info_animation_in',
					'type' => 'info',
					'desc' => __( 'Site Scroll Animation in', 'pinnacle' ),
				),
				array(
					'id' => 'pinnacle_animate_in',
					'type' => 'switch',
					'title' => __( 'Enable Animation In', 'pinnacle' ),
					'subtitle' => __( 'Disable this if you want to hide all the appear animation', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'info_lightbox',
					'type' => 'info',
					'desc' => __( 'Theme Lightbox', 'pinnacle' ),
				),
				array(
					'id' => 'kadence_lightbox',
					'type' => 'switch',
					'on' => __( 'Lightbox Off', 'pinnacle' ),
					'off' => __( 'Lightbox On', 'pinnacle' ),
					'title' => __( 'Turn Off Theme Lightbox?', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'info_gfonts',
					'type' => 'info',
					'desc' => __( 'Google Fonts', 'pinnacle' ),
				),
				array(
					'id' => 'load_google_fonts_locally',
					'type' => 'switch',
					'title' => __( 'Load Google Fonts Locally', 'pinnacle' ),
					'subtitle' => __( 'This will download font files to your server instead of using google servers.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'info_gmaps',
					'type' => 'info',
					'desc' => __( 'Theme Google Maps', 'pinnacle' ),
				),
				array(
					'id' => 'google_map_api',
					'type' => 'text',
					'title' => __( 'Google Map API', 'pinnacle' ),
					'subtitle' => __( 'Optional, but encouraged if you have a lot of page views so no interruption in service.', 'pinnacle' ),
					'description' => '<a target="_blank" href="https://developers.google.com/maps/documentation/javascript/get-api-key">Get an API code Here</a>',
					'default' => '',
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-code',
			'icon_class' => 'icon-large',
			'customizer' => false,
			'id' => 'custom_css',
			'title' => __( 'Custom CSS', 'pinnacle' ),
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Custom CSS Box', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'custom_css',
					'type' => 'textarea',
					'title' => __( 'Custom CSS', 'pinnacle' ),
					'subtitle' => __( 'Quickly add some CSS to your theme by adding it to this block.', 'pinnacle' ),
				// 'validate' => 'css',
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'id' => 'header_footer_scripts',
			'icon' => 'kt-icon-file',
			'customizer' => false,
			'icon_class' => 'icon-large',
			'title' => __( 'Header and Footer Scripts', 'pinnacle' ),
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Simple output for header and footer scripts', 'pinnacle' ) . '</h3></div>',
			'fields' => array(
				array(
					'id' => 'info_header_script',
					'type' => 'info',
					'desc' => __( 'Header Output', 'pinnacle' ),
				),
				array(
					'id' => 'kt_header_script',
					'type' => 'textarea',
					'title' => __( 'Outputs between &lt;head&gt; and &lt;/head&gt;', 'pinnacle' ),
					'subtitle' => __( 'Quickly add a script to your header.', 'pinnacle' ),
				),
				array(
					'id' => 'info_kt_after_body_open_script',
					'type' => 'info',
					'desc' => __( 'After the opening &lt;body&gt; tag', 'pinnacle' ),
				),
				array(
					'id' => 'kt_after_body_open_script',
					'type' => 'textarea',
					'title' => __( 'Outputs immediately after the opening &lt;body&gt; tag', 'pinnacle' ),
					'subtitle' => __( 'Quickly add a script for google tag manager.', 'pinnacle' ),
				),
				array(
					'id' => 'info_footer_script',
					'type' => 'info',
					'desc' => __( 'Footer Output', 'pinnacle' ),
				),
				array(
					'id' => 'kt_footer_script',
					'type' => 'textarea',
					'title' => __( 'Outputs right before &lt;/body&gt;', 'pinnacle' ),
					'subtitle' => __( 'Quickly add a script to your footer.', 'pinnacle' ),
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'icon' => 'kt-icon-cog2',
			'icon_class' => 'icon-large',
			'customizer' => false,
			'title' => __( 'Theme Extensions', 'pinnacle' ),
			'id' => 'theme_extensions',
			'desc' => "<div class='redux-info-field'><h3>" . __( 'Theme Extensions', 'pinnacle' ) . '</h3></div>
    <p>' . __( 'Disable Built in Theme Extensions. Please Note, this does not change how the front end loads. If these items where already not used then they were not loaded it the front end. These options only clean up the admin area.', 'pinnacle' ) . '</p>',
			'fields' => array(
				array(
					'id' => 'kadence_woo_extension',
					'type' => 'switch',
					'title' => __( 'Woocommerce Shop', 'pinnacle' ),
					'subtitle' => __( 'Turn Off/On all Woocommerce referances and code', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'kadence_portfolio_extension',
					'type' => 'switch',
					'title' => __( 'Portfolio Posts', 'pinnacle' ),
					'subtitle' => __( 'Turn Off/On all Portfolio referances and code', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'kadence_staff_extension',
					'type' => 'switch',
					'title' => __( 'Staff Posts', 'pinnacle' ),
					'subtitle' => __( 'Turn Off/On all Staff referances and code', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'kadence_testimonial_extension',
					'type' => 'switch',
					'title' => __( 'Testimonial Posts', 'pinnacle' ),
					'subtitle' => __( 'Turn Off/On all Testimonial referances and code', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'kadence_header_footer_extension',
					'type' => 'switch',
					'title' => __( 'Header and Footer Script output', 'pinnacle' ),
					'subtitle' => __( 'Turn Off/On Header and Footer Script output boxes.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'enable_custom_404',
					'type' => 'switch',
					'title' => __( 'Custom 404 Page', 'pinnacle' ),
					'subtitle' => __( 'Turn Off/On option for custom 404 page.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'custom_404_page',
					'type' => 'select',
					'data' => 'pages',
					'width' => 'width:60%',
					'title' => __( 'Choose a 404 page', 'pinnacle' ),
					'subtitle' => __( 'Select the page to be used instead of the standard 404 page.', 'pinnacle' ),
					'required' => array( 'enable_custom_404', '=', '1' ),
				),
				array(
					'id' => 'kt_revslider_notice',
					'type' => 'switch',
					'title' => __( 'Enable Install and Updates for Slider Revolution', 'pinnacle' ),
					'subtitle' => __( 'Turn Off/On Revolution slider install/update notices from theme.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'hide_rev_activation_notice',
					'type' => 'switch',
					'title' => __( 'Hide Slider Revolution Activation Notice', 'pinnacle' ),
					'subtitle' => __( 'Turn Off the Revolution notice to activate slider from plugin authors', 'pinnacle' ),
					'on' => __( 'hide', 'pinnacle' ),
					'off' => __( 'show', 'pinnacle' ),
					'default' => 1,
					'required' => array( 'kt_revslider_notice', '=', '1' ),
				),
				array(
					'id' => 'kt_cycloneslider_notice',
					'type' => 'switch',
					'title' => __( 'Enable Install and Updates for Cyclone Slider - No longer recommended that you use this plugin.', 'pinnacle' ),
					'subtitle' => __( 'Turn Off/On Cyclone slider install/update.', 'pinnacle' ),
					'default' => 0,
				),
				array(
					'id' => 'kt_kadenceslider_notice',
					'type' => 'switch',
					'title' => __( 'Enable Install and Updates for Kadence Slider', 'pinnacle' ),
					'subtitle' => __( 'Turn Off/On Kadence slider install/update notices from theme.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'kt_pagebuilder_notice',
					'type' => 'switch',
					'title' => __( 'Enable Notice for Pagebuilder', 'pinnacle' ),
					'subtitle' => __( 'Turn Off/On notices to install pagebuilder.', 'pinnacle' ),
					'default' => 1,
				),
				array(
					'id' => 'kt_tinymce_notice',
					'type' => 'switch',
					'title' => __( 'Enable Notice for Black Studio TinyMCE Widget', 'pinnacle' ),
					'subtitle' => __( 'Turn Off/On notices to install TinyMCE Widget.', 'pinnacle' ),
					'default' => 1,
				),
			),
		)
	);
	Redux::setSection(
		$opt_name,
		array(
			'title'  => __( 'Import / Export', 'pinnacle' ),
			'desc'   => __( 'Import and Export your Theme Options from text or URL.', 'pinnacle' ),
			'icon'   => 'icon-large kt-icon-folder-download',
			'id' => 'import_export_options',
			'fields' => array(
				array(
					'id'         => 'opt-import-export',
					'type'       => 'import_export',
					'title'      => '',
					'subtitle'   => '',
					'full_width' => true,
				),
			),
		)
	);

	/*
	 * <--- END SECTIONS
	 */

	function kadence_override_redux_icons_css() {
		wp_dequeue_style( 'redux-admin-css' );
		wp_register_style( 'kt-redux-custom-css', get_template_directory_uri() . '/themeoptions/options_assets/css/style.css', false, 152 );
		wp_enqueue_style( 'kt-redux-custom-css' );
		wp_dequeue_style( 'select2-css' );
		wp_dequeue_style( 'redux-elusive-icon' );
		wp_dequeue_style( 'redux-elusive-icon-ie7' );
	}

	add_action( 'redux-enqueue-pinnacle', 'kadence_override_redux_icons_css' );

	function kadence_remove_demo() {

		// Used to hide the demo mode link from the plugin page. Only used when Redux is a plugin.
		if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
			remove_filter(
				'plugin_row_meta',
				array(
					ReduxFrameworkPlugin::instance(),
					'plugin_metalinks',
				),
				null,
				2
			);

			// Used to hide the activation notice informing users of the demo panel. Only used when Redux is a plugin.
			remove_action( 'admin_notices', array( ReduxFrameworkPlugin::instance(), 'admin_notices' ) );
		}
	}
