<?php
/**
 * Page titles
 */
function kadence_title() {
	if ( is_home() ) {
		if (get_option('page_for_posts', true)) {
			$title = get_the_title(get_option('page_for_posts', true));
		} else {
			$title = __('Latest Posts', 'pinnacle');
		}
	} elseif ( is_search() ) {
		$title = sprintf( __('Search Results for %s', 'pinnacle' ), get_search_query() );
	} elseif ( is_archive() ) {
		$title = get_the_archive_title();
	} elseif ( is_404() ) {
		$title = __( 'Not Found', 'pinnacle' );
	} else if ( is_singular( 'tribe_events' ) ) {
		$title = tribe_get_event_label_singular();
	} else {
		$title = get_the_title();
	}
	return apply_filters( 'kadence_title', $title );
}
add_filter('get_the_archive_title', 'pinnacle_filter_archive_title');
function pinnacle_filter_archive_title( $title ){
		$term = get_term_by('slug', get_query_var('term'), get_query_var('taxonomy'));
    	if ( is_category() ) {
      		$title = single_cat_title( '', false );
    	} elseif ( is_tag() ) {
        	$title = single_tag_title( '', false );
    	} elseif (is_author()) {
      		$title = sprintf(__('Author Archives: %s', 'pinnacle'), get_the_author());
    	} elseif (is_day()) {
      		$title = sprintf(__('Daily Archives: %s', 'pinnacle'), get_the_date());
    	} elseif (is_month()) {
      		$title = sprintf(__('Monthly Archives: %s', 'pinnacle'), get_the_date('F Y'));
    	} elseif (is_year()) {
      		$title = sprintf(__('Yearly Archives: %s', 'pinnacle'), get_the_date('Y'));
    	} else if ($term) {
      		$title = $term->name;
    	} elseif ( is_tax( array( 'product_cat', 'product_tag' ) ) ) {
			$title = single_term_title( '', false );
		} elseif( function_exists( 'is_bbpress' ) ) {
    		if( is_bbpress() ) {
    			$title = bbp_title();
    		}
    	} else if ( function_exists( 'tribe_is_month') ) {
			if ( tribe_is_month() || tribe_is_past() || tribe_is_upcoming() || tribe_is_day() ) {
				$title = tribe_get_event_label_plural();
			}
			if ( function_exists( 'tribe_is_photo') ) {
				if ( tribe_is_map() || tribe_is_photo() || tribe_is_week() ) { 
					$title = tribe_get_event_label_plural();
				}
			}
    	}
    	return $title;
}