<?php
/**
 * Elementor Pro Support
 *
 * @package Pinnacle Theme
 */

namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) || ! class_exists( 'ElementorPro\Modules\ThemeBuilder\Module' ) ) {
	return;
}

namespace ElementorPro\Modules\ThemeBuilder\ThemeSupport;

use Elementor\TemplateLibrary\Source_Local;
use ElementorPro\Modules\ThemeBuilder\Classes\Locations_Manager;
use ElementorPro\Modules\ThemeBuilder\Module;


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Pinnacle Elementor Compatibility
 */
if ( ! class_exists( 'Pinnacle_Elementor_Pro' ) ) {

	/**
	 * Pinnacle Elementor Compatibility
	 *
	 * @since 1.2.7
	 */
	class Pinnacle_Elementor_Pro {

		/**
		 * Instance Control Variable
		 *
		 * @var object instance
		 */
		private static $instance;

		/**
		 * Initiator
		 *
		 * @return object Class object.
		 */
		public static function get_instance() {
			if ( ! isset( self::$instance ) ) {
				self::$instance = new self();
			}
			return self::$instance;
		}
		/**
		 * Constructor
		 */
		public function __construct() {

			add_action( 'elementor/theme/register_locations', array( $this, 'pinnacle_register_elementor_locations' ) );

			add_action( 'pinnacle_header', array( $this, 'pinnacle_elementor_do_header' ), 0 );
			add_action( 'pinnacle_footer', array( $this, 'pinnacle_elementor_do_footer' ), 0 );
		}

		/**
		 * Elementor Location support.
		 *
		 * @param object $elementor_theme_manager the theme manager.
		 */
		public function pinnacle_register_elementor_locations( $elementor_theme_manager ) {
			$elementor_theme_manager->register_location( 'header' );
			$elementor_theme_manager->register_location( 'footer' );
		}

		/**
		 * Header Support
		 *
		 * @return void
		 */
		public function pinnacle_elementor_do_header() {
			$did_location = Module::instance()->get_locations_manager()->do_location( 'header' );
			if ( $did_location ) {
				remove_action( 'pinnacle_header', 'pinnacle_header_markup' );
			}
		}

		/**
		 * Footer Support
		 *
		 * @return void
		 */
		public function pinnacle_elementor_do_footer() {
			$did_location = Module::instance()->get_locations_manager()->do_location( 'footer' );
			if ( $did_location ) {
				remove_action( 'pinnacle_footer', 'pinnacle_footer_markup' );
			}
		}
	}
	/**
	 * Kicking this off by calling 'get_instance()' method
	 */
	Pinnacle_Elementor_Pro::get_instance();
}
