<?php
/*
Template Name: Contact
*/
	global $pinnacle, $post;
	get_header();

	$map           = get_post_meta( $post->ID, '_kad_contact_map', true );
	$pageemail     = get_post_meta( $post->ID, '_kad_contact_form_email', true ); 
	$form_math     = get_post_meta( $post->ID, '_kad_contact_form_math', true );
	$name_required = get_post_meta( $post->ID, '_kad_contact_name_required', true );
	$consent       = get_post_meta( $post->ID, '_kad_contact_consent', true );
	$form          = get_post_meta( $post->ID, '_kad_contact_form', true );
	if ( isset( $_POST['submitted'] ) ) {
		$spam_hook = apply_filters( 'kadence-contact-spam-check', true, $_POST );
		if ( ! $spam_hook ) {
			$hasError = true;
			$spamError = __( 'Your post appears to be spam, if this is incorrect please contact the site admnistator.', 'pinnacle' );
		}

		if ( isset( $form_math) && $form_math == 'yes' ) {
			$math_answer = trim( $_POST['kad_captcha'] );
			if( md5( $math_answer) != $_POST['hval'] ) {
				$kad_captchaError = __( 'Check your math.', 'pinnacle' );
				$hasError = true;
			}
		}
		if ( isset( $consent ) && 'true' == $consent ) {
			$gdpr_consent = sanitize_text_field( $_POST['gdpr-consent'] );
			if( 'on' != $gdpr_consent ) {
				$kad_consentError = __('Please check the box.', 'pinnacle');
				$hasError = true;
			}
		}
		if ( 'false' ==  $name_required ) {
			$name = sanitize_text_field( trim( $_POST['contactName'] ) );
		} else {
			if(trim($_POST['contactName']) === '') {
				$nameError = __('Please enter your name.', 'pinnacle');
				$hasError = true;
			} else {
				$name = sanitize_text_field( trim( $_POST['contactName'] ) );
			}
		}

		if(trim($_POST['email']) === '')  {
			$emailError = __('Please enter your email address.', 'pinnacle');
			$hasError = true;
		} else if (!is_email(trim($_POST['email']))) {
			$emailError = __('You entered an invalid email address.', 'pinnacle');
			$hasError = true;
		} else {
			$email = sanitize_text_field( trim($_POST['email']) );
		}

		if(trim($_POST['comments']) === '') {
			$commentError = __('Please enter a message.', 'pinnacle');
			$hasError = true;
		} else {
			if(function_exists('stripslashes')) {
				$comments = stripslashes(trim($_POST['comments']));
			} else {
				$comments = wp_kses_post( trim($_POST['comments']) );
			}
		}

		if(!isset($hasError)) {
			if (isset($pageemail)) {
				$emailTo = $pageemail;
			} else {
				$emailTo = get_option('admin_email');
			}
			$sitename = get_bloginfo('name');
			$name = wp_filter_kses( $name );
			$email = wp_filter_kses( $email );
			$comments = wp_filter_kses( $comments );

			$subject = '['.$sitename . ' ' . __("Contact", "pinnacle").'] '. __("From", "pinnacle") . ' ' . $name;
			$body = __('Name', 'pinnacle').": $name \n\n";
			$body .= __('Email', 'pinnacle').": $email \n\n";
			$body .= __('Comments', 'pinnacle').":\n $comments";
			$headers = 'Reply-To: ' . $name . '<' . $email . '>' . "\r\n";

			wp_mail($emailTo, $subject, $body, $headers);
			$emailSent = true;
		}

	}

	get_template_part( 'templates/page', 'header' );

	if ( 'yes' == $map ) {
		$address 	= get_post_meta( $post->ID, '_kad_contact_address', true ); 
		$maptype 	= get_post_meta( $post->ID, '_kad_contact_maptype', true ); 
		$height 	= get_post_meta( $post->ID, '_kad_contact_mapheight', true );
		$address2 	= get_post_meta( $post->ID, '_kad_contact_address2', true );
		$address3 	= get_post_meta( $post->ID, '_kad_contact_address3', true );
		$address4 	= get_post_meta( $post->ID, '_kad_contact_address4', true );
		$mapcenter 	= get_post_meta( $post->ID, '_kad_contact_map_center', true );
		$mapzoom 	= get_post_meta( $post->ID, '_kad_contact_zoom', true );
		if ( isset( $pinnacle['google_map_api'] ) && ! empty( $pinnacle['google_map_api'] ) ) {
			$gmap_api = $pinnacle['google_map_api'];
		} else {
			$gmap_api = '';
		}
		if ( ! empty( $height ) ) {
			$mapheight = $height;
		} else {
			$mapheight = 300;
		}
		if ( empty( $mapcenter ) ) {
			$center = $address;
		} else {
			$center = $mapcenter;
		}
		if ( ! empty( $mapzoom ) ) {
			$zoom = $mapzoom;
		} else {
			$zoom = 15;
		}
		if ( ! empty( $gmap_api ) ) {
			wp_enqueue_script( 'pinnacle_google_map_api' );
			wp_enqueue_script( 'pinnacle_gmap' );
			?>
			<div id="map_address" style="height:<?php echo esc_attr( $mapheight ); ?>px; margin-bottom:20px;" class="kt-gmap-js-init" data-maptype="<?php echo esc_attr( $maptype ); ?>" data-mapzoom="<?php echo esc_attr( $zoom ); ?>" data-mapcenter="<?php echo esc_attr( $center ); ?>" data-address1="<?php echo esc_attr( $address ); ?>" data-address2="<?php echo esc_attr( $address2 ); ?>" data-address3="<?php echo esc_attr( $address3 ); ?>" data-address4="<?php echo esc_attr( $address4 ); ?>">
			</div>
		<?php 
		} else {
			if ( 'TERRAIN' === $maptype ) {
				$maptype = 'p';
			} else if ( 'HYBRID' === $maptype ) {
				$maptype = 'h';
			} else if ( 'SATELLITE' === $maptype ) {
				$maptype = 'k';
			} else {
				$maptype = 'm';
			}
			$query_string = 'q=' . rawurlencode( $address ) . '&cid=&t=' . rawurlencode( $maptype ) . '&center=' . rawurlencode( $center );
			echo '<div class="kt-map"><iframe height="' . esc_attr( $mapheight ) . '" src="https://maps.google.com/maps?&' . esc_attr( htmlentities( $query_string ) ) . '&output=embed&z=' . esc_attr( $zoom ) . '&iwloc=A&visual_refresh=true"></iframe></div>';
		}
	}
	?>
	<div id="content" class="container">
   		<div class="row">
   		<?php
      	if ($form == 'yes') { ?>
	  		<div id="main" class="main col-md-5" role="main">
	  			<div class="postclass pageclass">
	  	<?php } else { ?>
      		<div id="main" class="main col-md-12" role="main">
      			<div class="postclass pageclass">
      <?php } ?>
      <div class="entry-content" itemprop="mainContentOfPage">
					<?php get_template_part( 'templates/content', 'page' ); ?>
		</div>
		      </div>
		  </div>
      <?php if ( $form == 'yes' ) { ?>
      		<div class="contactformcase col-md-7">
      			<?php
      			 $contactformtitle = get_post_meta( $post->ID, '_kad_contact_form_title', true );
      			 if ( ! empty( $contactformtitle ) ) { 
      				echo '<h3>'. __( $contactformtitle ) .'</h3>';
      			} ?>
				<?php if(isset($emailSent) && $emailSent == true) { ?>
							<div class="thanks">
								<p><?php _e('Thanks, your email was sent successfully.', 'pinnacle');?></p>
							</div>
						<?php } else { ?>
							<?php if(isset($hasError) || isset($captchaError)) { ?>
								<p class="error"><?php _e('Sorry, an error occured.', 'pinnacle');?><p>
							<?php } ?>

						<form action="<?php the_permalink(); ?>" id="contactForm" method="post">
							<div class="contactform">
							<p>
								<?php if ( 'false' ==  $name_required ) { ?>
									<label for="contactName"><b><?php _e('Name:', 'pinnacle');?></b></label>
								<?php } else { ?>
									<label for="contactName"><b><?php _e('Name:', 'pinnacle');?></b><span class="contact-required">*</span></label>
								<?php } ?>
								<?php if(isset($nameError)) { ?>
									<span class="error"><?php echo esc_html($nameError);?></span>
								<?php } ?>
								<?php if ( 'false' ==  $name_required ) { ?>
									<input type="text" name="contactName" id="contactName" value="<?php if(isset($_POST['contactName'])){ echo esc_attr($_POST['contactName']);}?>" class="full" />
                               <?php } else { ?>
                               		<input type="text" name="contactName" id="contactName" value="<?php if(isset($_POST['contactName'])){ echo esc_attr($_POST['contactName']);}?>" class="required requiredField full" />
								<?php } ?>
							</p>

							<p>
								<label for="email"><?php _e('Email:', 'pinnacle'); ?><span class="contact-required">*</span></label> <?php if(isset($emailError)) { ?>
									<span class="error"><?php echo esc_html($emailError);?></span>
								<?php } ?>
								<input type="text" name="email" id="email" value="<?php if(isset($_POST['email'])) echo esc_attr($_POST['email']);?>" class="required requiredField email full" />
							</p>

							<p><label for="commentsText"><?php _e('Message:', 'pinnacle'); ?><span class="contact-required">*</span></label>
								<?php if(isset($commentError)) { ?>
									<span class="error"><?php echo esc_html($commentError);?></span>
								<?php } ?>
								<textarea name="comments" id="commentsText" rows="10" class="required requiredField"><?php if(isset($_POST['comments'])) { if(function_exists('stripslashes')) { echo esc_textarea(stripslashes($_POST['comments'])); } else { echo esc_textarea($_POST['comments']); } } ?></textarea>
							</p>
							<?php if(isset($form_math) && $form_math == 'yes') { ?>
							<?php   $one = rand(5, 50);
									$two = rand(1, 9);
									$result = md5($one + $two); ?>
									<p>
									<label for="kad_captcha"><?php echo $one.' + '.$two; ?> = <span class="contact-required">*</span></label>
									<input type="text" name="kad_captcha" id="kad_captcha" class="required requiredField kad_captcha kad-quarter" />
									<?php if(isset($kad_captchaError)) { ?><label class="error"><?php echo esc_html($kad_captchaError);?></label><?php } ?>
									<input type="hidden" name="hval" id="hval" value="<?php echo esc_attr($result);?>" />
								</p>
							<?php } ?>
							<?php if( isset( $consent ) && 'true' == $consent ) { ?>
								<p>
									<input type="checkbox" name="gdpr-consent" id="gdpr-consent" class="required requiredField kad_gdpr-consent" />
									<?php 
									if ( isset($pinnacle['contact_consent'] ) && ! empty( $pinnacle['contact_consent'] ) ) {
										$contact_consent_label = $pinnacle['contact_consent'];
									} else {
										if ( function_exists( 'the_privacy_policy_link' ) ) {
											$privacy_link = get_the_privacy_policy_link();
										}
										if( ! empty( $privacy_link ) ) {
											$contact_consent_label = sprintf( __('Please check to consent to our %s.', 'pinnacle'), $privacy_link);
										} else {
											$contact_consent_label = __('Please check to consent to our privacy policy.', 'pinnacle');
										}
									} ?>
									<label for="gdpr-consent"><?php echo $contact_consent_label; ?><span class="contact-required">*</span></label>
									<?php if(isset($kad_consentError)) { ?><label class="error"><?php echo esc_html($kad_consentError);?></label><?php } ?>
								</p>
							<?php } ?>
							<?php
							$spam_field = apply_filters( 'kadence-contact-spam-field', null );

							if( ! empty( $spam_field ) && is_array( $spam_field ) ) { ?>
								<p>	
									<?php if( isset( $spam_field['label'] ) && !empty( $spam_field['label'] ) ){
										echo wp_kses_post( $spam_field['label'] );
									}
									if( isset( $spam_field['input'] ) && !empty( $spam_field['input'] ) ){
										echo wp_kses_post( $spam_field['input'] );
									}
							
									if( isset( $spamError) ) { ?><label class="error"><?php echo esc_html( $spamError );?></label><?php } ?>
								</p>
							<?php } ?>
							<p>
								<input type="submit" class="kad-btn kad-btn-primary" id="submit" tabindex="5" value="<?php _e('Send Email', 'pinnacle'); ?>" ></input>
							</p>
						</div><!-- /.contactform-->
						<input type="hidden" name="submitted" id="submitted" value="true" />
					</form>
				<?php } ?>
      </div><!--contactform-->
      <?php } ?>
        <?php get_footer(); ?>