<?php
/**
 * Cleaner walker for wp_nav_menu()
 *
 * @package Pinnacle
 */

// Get Walkers.
require_once trailingslashit( get_template_directory() ) . 'lib/classes/class-pinnacle-nav-walker.php';
require_once trailingslashit( get_template_directory() ) . 'lib/classes/class-pinnacle-mobile-nav-walker.php';



/**
 * Deprecated class.
 *
 * @category class
 */
class kadence_Nav_Walker extends Pinnacle_Nav_Walker {
	/**
	 * Starts the list before the elements are added.
	 *
	 * @param string   $output Used to append additional content (passed by reference).
	 * @param int      $depth  Depth of menu item. Used for padding.
	 * @param stdClass $args   An object of wp_nav_menu() arguments.
	 */
	public function start_lvl( &$output, $depth = 0, $args = array() ) {

		error_log( 'The kadence_Nav_Walker class is deprecated since version 2.3.3. Please use Pinnacle_Nav_Walker instead.' );
		parent::start_lvl( $output, $depth, $args );
	}
}
/**
 * Clean up wp_nav_menu_args
 *
 * Remove the container
 * Use Pinnacle_Nav_Walker() by default
 */
function pinnacle_nav_menu_args( $args = array() ) {
	$pinnacle_nav_menu_args = array();

	if ( ( ! isset( $args['container_class'] ) || empty( $args['container_class'] ) ) && ( ! isset( $args['container_id'] ) || empty( $args['container_id'] ) ) ) {
		$pinnacle_nav_menu_args['container'] = false;
	}

	if ( ! $args['items_wrap'] ) {
		$pinnacle_nav_menu_args['items_wrap'] = '<ul class="%2$s">%3$s</ul>';
	}

	if ( ! $args['walker'] ) {
		$pinnacle_nav_menu_args['walker'] = new Pinnacle_Nav_Walker();
	}

	return array_merge( $args, $pinnacle_nav_menu_args );
}
add_filter( 'wp_nav_menu_args', 'pinnacle_nav_menu_args' );

/**
 * Custom Menu Walker
 */
class kadence_mobile_walker extends Pinnacle_Mobile_Nav_Walker {
	/**
	 * Starts the list before the elements are added.
	 *
	 * @param string   $output Used to append additional content (passed by reference).
	 * @param int      $depth  Depth of menu item. Used for padding.
	 * @param stdClass $args   An object of wp_nav_menu() arguments.
	 */
	public function start_lvl( &$output, $depth = 0, $args = array() ) {

		error_log( 'The kadence_mobile_walker class is deprecated since version 2.3.3. Please use Pinnacle_Mobile_Nav_Walker instead.' );
		parent::start_lvl( $output, $depth, $args );
	}
}

