<?php
/**
 * Kadence initial setup and constants
 */
function kadence_setup() {
 global $pinnacle, $pagenow; 
 if(isset($pinnacle['header_style']) && $pinnacle['header_style'] == "center") {
      register_nav_menus(array(
        'left_navigation' => __('Left Navigation', 'pinnacle'),
        'right_navigation' => __('Right Navigation', 'pinnacle'),
        'primary_navigation' => __('Mobile Navigation', 'pinnacle'),
        'topbar_navigation' => __('Topbar Navigation', 'pinnacle'),
        'footer_navigation' => __('Footer Navigation', 'pinnacle'),
      ));
  } else {
  register_nav_menus(array(
        'primary_navigation' => __('Primary Navigation', 'pinnacle'),
        'mobile_navigation' => __('Mobile Navigation', 'pinnacle'),
        'topbar_navigation' => __('Topbar Navigation', 'pinnacle'),
        'footer_navigation' => __('Footer Navigation', 'pinnacle'),
      ));
  }
  add_theme_support( 'title-tag' );
  add_theme_support('post-thumbnails');
  add_image_size( 'widget-thumb', 60, 60, true );
  add_post_type_support( 'attachment', 'page-attributes' );
  add_theme_support('post-formats', array('gallery', 'image', 'video'));
  add_theme_support( 'automatic-feed-links' );
  add_editor_style('/assets/css/editor-style.css');

  add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'script',
			'style',
		)
	);


  if ( is_admin() && 'themes.php' == $pagenow && isset( $_GET['activated'] ) ) {
      wp_redirect(admin_url("themes.php?page=kt_api_manager_dashboard"));
  }
  // Gutenberg Support.
	add_theme_support( 'editor-color-palette', array(
		array(
			'name'  => __( 'Primary Color', 'pinnacle' ),
			'slug'  => 'pinnacle-primary',
			'color' => ( isset( $pinnacle['primary_color'] ) && ! empty( $pinnacle['primary_color'] ) ? $pinnacle['primary_color'] : '#f3690e' ),
		),
		array(
			'name'  => __( 'Lighter Primary Color', 'pinnacle' ),
			'slug'  => 'pinnacle-primary-light',
			'color' => ( isset( $pinnacle['primary20_color'] ) && ! empty( $pinnacle['primary20_color'] ) ? $pinnacle['primary20_color'] : '#f5873f' ),
		),
		array(
			'name'  => __( 'Very light gray', 'pinnacle' ),
			'slug'  => 'very-light-gray',
			'color' => '#eee',
		),
		array(
			'name'  => esc_html__( 'White', 'pinnacle' ),
			'slug'  => 'white',
			'color' => '#fff',
		),
		array(
			'name'  => __( 'Very dark gray', 'pinnacle' ),
			'slug'  => 'very-dark-gray',
			'color' => '#444',
		),
		array(
			'name'  => esc_html__( 'Black', 'pinnacle' ),
			'slug'  => 'black',
			'color' => '#000',
		),
	) );
	add_theme_support( 'align-wide' );
	define( 'PINNACLE_VERSION', '2.4.17' );
}
add_action('after_setup_theme', 'kadence_setup');

function kt_fav_output() {
	// Keep for fallback, deprecated.
	global $pinnacle;
	if ( ! empty( $pinnacle['pinnacle_custom_favicon']['url'] ) ) {
		echo '<link rel="shortcut icon" type="image/x-icon" href="' . esc_url( $pinnacle['pinnacle_custom_favicon']['url'] ) . '" />';
	}
}
add_action('wp_head', 'kt_fav_output', 1);

if ( ! function_exists( 'wp_body_open' ) ) {
	/**
	 * WP Body Open
	 */
	function wp_body_open() {
		do_action( 'wp_body_open' );
	}
}
