<?php 

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

function pinnacle_basic_image_sizes() {
	$sizes = array('full' => 'Full Size');

	foreach ( get_intermediate_image_sizes() as $_size ) {
		if ( in_array( $_size, array('thumbnail', 'medium', 'medium_large', 'large') ) ) {
			$sizes[$_size]  = $_size .' - '. get_option( "{$_size}_size_w" ).'x'.get_option( "{$_size}_size_h" );
		} 
	}
	$sizes['custom'] = 'Custom';

	return $sizes;
}

add_filter( 'max_srcset_image_width','kt_srcset_max');
function kt_srcset_max($string) {
  return 2300;
}
function pinnacle_img_placeholder() {
  return apply_filters('kadence_placeholder_image', get_template_directory_uri() . '/assets/img/post_standard.jpg');
}
function pinnacle_img_placeholder_cat() {
  return apply_filters('kadence_placeholder_image_cat', get_template_directory_uri() . '/assets/img/placement.jpg');
}
function pinnacle_img_placeholder_small() {
  return apply_filters('kadence_placeholder_image_small', get_template_directory_uri() . '/assets/img/post_standard-60x60.jpg');
}

function pinnacle_post_default_placeholder() {
   return apply_filters('kadence_post_default_placeholder_image', get_template_directory_uri() . '/assets/img/post_standard.jpg');
}
function pinnacle_post_default_placeholder_square() {
  return apply_filters('kadence_post_default_placeholder_image_square', get_template_directory_uri() . '/assets/img/placement.jpg');
}

function pinnacle_post_default_placeholder_override() {
	global $pinnacle;
	$custom_image = $pinnacle['post_summery_default_image']['url'];
	return $custom_image;
}
add_action( 'init', 'kt_check_for_post_image' );
function kt_check_for_post_image() {
	global $pinnacle;
	if (isset($pinnacle['post_summery_default_image']) && !empty($pinnacle['post_summery_default_image']['url'])) {
		add_filter('kadence_placeholder_image_small', 'pinnacle_post_default_placeholder_override');
		add_filter('kadence_post_default_placeholder_image', 'pinnacle_post_default_placeholder_override');
		add_filter('kadence_post_default_placeholder_image_square', 'pinnacle_post_default_placeholder_override');
	}
}

function pinnacle_default_placeholder_image() {
    return apply_filters('pinnacle_default_placeholder_image', 'http://placehold.it/');
}
function pinnacle_get_options_placeholder_image() {
    global $pinnacle;
    if(isset($pinnacle['post_summery_default_image']) && isset($pinnacle['post_summery_default_image']['id']) && !empty($pinnacle['post_summery_default_image']['id'])){
        return $pinnacle['post_summery_default_image']['id'];
    } else {
        return '';
    }
}

function pinnacle_get_image_array($width = null, $height = null, $crop = true, $class = null, $alt = null, $id = null, $placeholder = false) {
    if ( empty( $id ) ) {
        $id = get_post_thumbnail_id();
    }
    if (empty( $id ) ) {
        if ( $placeholder == true ) {
            $id = pinnacle_get_options_placeholder_image();
        }
    }
    if ( ! empty( $id ) ) {
		$pinnacle_Get_Image = Pinnacle_Get_Image::getInstance();
		$image = $pinnacle_Get_Image->process( $id, $width, $height);
		if( empty( $alt ) ) {
			$alt = get_post_meta($id, '_wp_attachment_image_alt', true);
		}
		$return_array = array(
			'src' => $image[0],
			'width' => $image[1],
			'height' => $image[2],
			'srcset' => $image[3],
			'src_set' => $image[4],
            'sizes' => $image[5],
			'class' => $class,
			'alt' => $alt,
			'full' => $image[6],
		);
    } else if(empty($id) && $placeholder == true) {
    	if(empty($height)){
    		$height = floor($width*.666666667);
    	}
    	if(empty($width)){
    		$width = $height;
    	}
        $return_array = array(
            'src' => pinnacle_post_default_placeholder(),
            'width' => $width,
            'height' => $height,
            'srcset' => '',
            'src_set' => '',
            'sizes' => '',
            'class' => $class,
            'alt' => $alt,
            'full' => pinnacle_post_default_placeholder(),
        );
    } else {
        $return_array = array(
            'src' => '',
            'width' => '',
            'height' => '',
            'srcset' => '',
            'src_set' => '',
            'sizes' => '',
            'class' => '',
            'alt' => '',
            'full' => '',
        );
    }

    return $return_array;
}

function pinnacle_get_processed_image_array( $args = array() ) {
	$defaults = array(
		'width' 		=> null,
		'height' 		=> null,
		'crop'			=> true,
		'class'			=> null,
		'alt'			=> null,
		'id'			=> null,
		'placeholder'	=> false,
	);
	$args = wp_parse_args( $args, $defaults );
	extract($args);
	if ( empty( $id ) ) {
		$id = get_post_thumbnail_id();
	}
	if ( empty( $id ) ) {
		if( $placeholder == true ) {
			$id = virtue_get_options_placeholder_image();
		}
	}
	if( ! empty( $id ) ) {
		$virtue_get_image = Pinnacle_Get_Image::getInstance();
		$image = $virtue_get_image->process( $id, $width, $height);
		if( empty( $alt ) ) {
			$alt = get_post_meta( $id, '_wp_attachment_image_alt', true );
		}
		$return_array = array(
			'src' => $image[0],
			'width' => $image[1],
			'height' => $image[2],
			'srcset' => $image[3],
			'src_set' => $image[4],
			'sizes' => $image[5],
			'class' => $class,
			'alt' => $alt,
			'full' => $image[6],
		);
	} else if( empty( $id ) && $placeholder == true ) {
		if ( empty( $height ) ){
			$height = $width;
		}
		if ( empty( $width ) ){
			$width = $height;
		}
		$return_array = array(
			'src' => pinnacle_post_default_placeholder(),
			'width' => $width,
			'height' => $height,
			'srcset' => '',
			'src_set' => '',
			'sizes' => '',
			'class' => $class,
			'alt' => $alt,
			'full' => pinnacle_post_default_placeholder(),
		);
	} else {
		$return_array = array(
			'src' => '',
			'width' => '',
			'height' => '',
			'srcset' => '',
			'src_set' => '',
			'sizes' => '',
			'class' => '',
			'alt' => '',
			'full' => '',
		);
	}

	return $return_array;
}

function pinnacle_print_full_image_output( $args ) {
	$defaults = array(
		'width' 		=> null,
		'height' 		=> null,
		'crop'			=> true,
		'class'			=> null,
		'alt'			=> null,
		'id'			=> null,
		'placeholder'	=> false,
		'lazy'			=> true,
		'schema'		=> true,
		'extra'           => null,
		'intrinsic'       => false,
		'intrinsic_max'   => false,
	);
	$args = wp_parse_args( $args, $defaults );
    $img = pinnacle_get_processed_image_array($args);
    extract( $args );
	if( $lazy && Pinnacle_Lazy_Load::is_lazy() ) {
		$image_src_output = 'data-lazy-src="'.esc_url($img['src']).'" ';
		$image_src_output = apply_filters('pinnacle_lazy_src_output', $image_src_output );
		$image_src_set_output = ( ! empty( $img['src_set'] ) ? 'data-lazy-srcset="'.esc_attr( $img['src_set'] ).'"' : ''); 
		$image_sizes_output = ( ! empty( $img['src_set'] ) ? 'sizes="'.esc_attr($img['sizes']).'"' : ''); 
	} else {
		$image_src_output = 'src="'.esc_url($img['src']).'"'; 
		$image_src_set_output = ( ! empty( $img['src_set'] ) ? 'srcset="'.esc_attr( $img['src_set']).'"' : '');
		$image_sizes_output =  ( ! empty( $img['src_set'] ) ? 'sizes="'.esc_attr($img['sizes']).'"' : '');
	}
    $extras = '';
    if( is_array( $extra ) ) {
    	foreach ($extra as $key => $value) {
    		$extras .= esc_attr($key).'="'.esc_attr($value).'" ';
    	}
    } else {
    	$extras = $extra;	
    }
    if ( ! empty($img['src'] ) && $schema == true ) {
    	$output = '';
    	if($intrinsic == true) {
			if ( true == $intrinsic_max ) {
				$output .= '<div class="kt-intrinsic-container kt-intrinsic-container-center" style="max-width:' . esc_attr( $img['width'] ) . 'px">';
			}
    		$output .= '<div class="kt-intrinsic" style="padding-bottom:'.esc_attr(($img['height']/$img['width']) * 100).'%;">';
    	}
		$output .= '<div itemprop="image" itemscope itemtype="http://schema.org/ImageObject">';
		$output .='<img '.$image_src_output.' width="'.esc_attr($img['width']).'" height="'.esc_attr($img['height']).'" '.$image_src_set_output.' '.$image_sizes_output.' class="'.esc_attr($img['class']).'" itemprop="contentUrl" alt="'.esc_attr($img['alt']).'" '.$extras.'>';
		$output .= '<meta itemprop="url" content="'.esc_url($img['src']).'">';
		$output .= '<meta itemprop="width" content="'.esc_attr($img['width']).'px">';
		$output .= '<meta itemprop="height" content="'.esc_attr($img['height']).'px">';
		$output .= '</div>';

	    if($intrinsic == true) {
    		$output .= '</div>';
			if ( true == $intrinsic_max ) {
				$output .= '</div>';
			}
    	}
      	echo $output;

    } elseif( ! empty($img['src'] ) ) {
    	$output = '';
    	if($intrinsic == true) {
    		if ( true == $intrinsic_max ) {
				$output .= '<div class="kt-intrinsic-container kt-intrinsic-container-center" style="max-width:' . esc_attr( $img['width'] ) . 'px">';
			}
    		$output .= '<div class="kt-intrinsic" style="padding-bottom:'.esc_attr(($img['height']/$img['width']) * 100).'%;">';
    	}
        	$output .= '<img '.$image_src_output.' width="'.esc_attr($img['width']).'" height="'.esc_attr($img['height']).'" '.$image_src_set_output.' '.$image_sizes_output.' class="'.esc_attr($img['class']).'" alt="'.esc_attr($img['alt']).'" '.$extras.'>';
        if($intrinsic == true) {
    		$output .= '</div>';
    		if ( true == $intrinsic_max ) {
				$output .= '</div>';
			}
    	}
      	echo $output;
    } else {
        echo null;
    }
}

/**
 * Function for getting image markup
 */
function pinnacle_get_full_image_output( $width = null, $height = null, $crop = true, $class = null, $alt = null, $id = null, $placeholder = false, $lazy = false, $schema = true, $extra = null ) {
	$img = pinnacle_get_image_array( $width, $height, $crop, $class, $alt, $id, $placeholder );
	if ( $lazy && Pinnacle_Lazy_Load::is_lazy() ) {
		$image_src_output     = 'data-lazy-src="' . esc_url( $img['src'] ) . '" ';
		$image_src_output     = apply_filters( 'virtue_lazy_src_output', $image_src_output );
		$image_src_set_output = ( ! empty( $img['src_set'] ) ? 'data-lazy-srcset="' . esc_attr( $img['src_set'] ) . '"' : '' );
		$image_sizes_output   = ( ! empty( $img['src_set'] ) ? 'sizes="' . esc_attr( $img['sizes'] ) . '"' : '' );
	} else {
		$image_src_output     = 'src="' . esc_url( $img['src'] ) . '"';
		$image_src_set_output = ( ! empty( $img['src_set'] ) ? 'srcset="' . esc_attr( $img['src_set'] ) . '"' : '' );
		$image_sizes_output   = ( ! empty( $img['src_set'] ) ? 'sizes="' . esc_attr( $img['sizes'] ) . '"' : '' );
	}
    $extras = '';
    if(is_array($extra)) {
    	foreach ($extra as $key => $value) {
    		$extras .= esc_attr($key).'="'.esc_attr($value).'" ';
    	}
    } else {
    	$extras = $extra;	
    }
    if(!empty($img['src']) && $schema == true) {
        $output = '<div itemprop="image" itemscope itemtype="http://schema.org/ImageObject">';
        $output .='<img '.$image_src_output.' width="'.esc_attr($img['width']).'" height="'.esc_attr($img['height']).'" '.$image_src_set_output.' '.$image_sizes_output.' class="'.esc_attr($img['class']).'" itemprop="contentUrl" alt="'.esc_attr($img['alt']).'" '.$extras.'>';
        $output .= '<meta itemprop="url" content="'.esc_url($img['src']).'">';
        $output .= '<meta itemprop="width" content="'.esc_attr($img['width']).'px">';
        $output .= '<meta itemprop="height" content="'.esc_attr($img['height']).'px">';
        $output .= '</div>';
      	return $output;

    } elseif(!empty($img['src'])) {
        return '<img '.$image_src_output.' width="'.esc_attr($img['width']).'" height="'.esc_attr($img['height']).'" '.$image_src_set_output.' '.$image_sizes_output.' class="'.esc_attr($img['class']).'" alt="'.esc_attr($img['alt']).'" '.$extras.'>';
    } else {
        return null;
    }
}