<?php

/**
 * Enqueue CSS & JS
 */
function kadence_admin_scripts($hook) {
	wp_register_style( 'kadence-blocks-install', get_template_directory_uri() . '/assets/css/blocks-admin-activate.css', false, PINNACLE_VERSION );
	wp_register_script( 'kadence-blocks-install', get_template_directory_uri() . '/assets/js/blocks-admin-activate.js', false, PINNACLE_VERSION );
  	//wp_enqueue_style('pinnacle_admin_styles', get_template_directory_uri() . '/assets/css/pinnacle_admin_styles.css', false, PINNACLE_VERSION);
  	if( $hook != 'edit.php' && $hook != 'post.php' && $hook != 'post-new.php' && $hook != 'widgets.php' && $hook != 'toplevel_page_ktoptions') {
		return;
  	}
  	wp_enqueue_style( 'pinnacle_admin_styles', get_template_directory_uri() . '/assets/css/pinnacle_admin_styles.css', false, PINNACLE_VERSION);
  	wp_enqueue_style( 'wp-color-picker' );
  	if ( class_exists( 'woocommerce' ) ) {
		if ( version_compare( WC_VERSION, '2.7', '>' ) ) {  
			wp_register_script('select2', get_template_directory_uri() . '/assets/js/min/select2_v4-min.js', false, PINNACLE_VERSION, false);
		} else {
			wp_register_script('select2', get_template_directory_uri() . '/assets/js/min/select2-min.js', false, PINNACLE_VERSION, false);
			
		}
	} else {
		wp_register_script('select2', get_template_directory_uri() . '/assets/js/min/select2_v4-min.js', false, PINNACLE_VERSION, false);
	}
  	wp_enqueue_script('select2');
  	 wp_enqueue_media();
  	 wp_register_script('mustache-js', get_template_directory_uri() . '/assets/js/vendor/mustache.min.js');
  	wp_enqueue_script('pinnacle_admin_js', get_template_directory_uri() . '/assets/js/pinnacle_admin_scripts.js', array( 'wp-color-picker', 'jquery', 'underscore', 'backbone', 'jquery-ui-sortable', 'mustache-js'), PINNACLE_VERSION, false);

}

add_action('admin_enqueue_scripts', 'kadence_admin_scripts');

/**
 * Enqueue block editor style
 */
function pinnacle_block_editor_styles() {
	wp_enqueue_style( 'pinnacle-guten-editor-styles', get_template_directory_uri() . '/assets/css/guten-editor-styles.css', false, PINNACLE_VERSION, 'all' );
}
add_action( 'enqueue_block_editor_assets', 'pinnacle_block_editor_styles' );

/**
 * Add inline css for fonts
 */
function pinnacle_editor_dynamic_css() {
	global $current_screen;
	$current_screen = get_current_screen();
	if ( ( method_exists( $current_screen, 'is_block_editor' ) && $current_screen->is_block_editor() ) || ( function_exists( 'is_gutenberg_page' ) && is_gutenberg_page() ) ) {
		$pinnacle        = pinnacle_get_options();
		$options_fonts = array( 'font_h1', 'font_h2', 'font_h3', 'font_h4', 'font_h5', 'font_p' );
		$load_gfonts   = array();
		foreach ( $options_fonts as $options_key ) {
			if ( isset( $pinnacle[ $options_key ] ) && isset( $pinnacle[ $options_key ]['google'] ) && 'false' !== $pinnacle[ $options_key ]['google'] ) {
				// check if it's in the array.
				if ( isset( $load_gfonts[ sanitize_key( $pinnacle[ $options_key ]['font-family'] ) ] ) ) {
					if ( isset( $pinnacle[ $options_key ]['font-weight'] ) && ! empty( $pinnacle[ $options_key ]['font-weight'] ) ) {
						if ( isset( $pinnacle[ $options_key ]['font-style'] ) && ! empty( $pinnacle[ $options_key ]['font-style'] ) && ! is_numeric( $pinnacle[ $options_key ]['font-style'] ) && 'normal' !== $pinnacle[ $options_key ]['font-style'] ) {
							$load_gfonts[ sanitize_key( $pinnacle[ $options_key ]['font-family'] ) ]['font-style'][ $pinnacle[ $options_key ]['font-weight'] . $pinnacle[ $options_key ]['font-style'] ] = $pinnacle[ $options_key ]['font-weight'] . $pinnacle[ $options_key ]['font-style'];
						} else {
							$load_gfonts[ sanitize_key( $pinnacle[ $options_key ]['font-family'] ) ]['font-style'][ $pinnacle[ $options_key ]['font-weight'] ] = $pinnacle[ $options_key ]['font-weight'];
						}
					}
					if ( isset( $pinnacle[ $options_key ]['subsets'] ) && ! empty( $pinnacle[ $options_key ]['subsets'] ) ) {
						$load_gfonts[ sanitize_key( $pinnacle[ $options_key ]['font-family'] ) ]['subsets'][ $pinnacle[ $options_key ]['subsets'] ] = $pinnacle[ $options_key ]['subsets'];
					}
				} else {
					$load_gfonts[ sanitize_key( $pinnacle[ $options_key ]['font-family'] ) ] = array(
						'font-family' => $pinnacle[ $options_key ]['font-family'],
						'font-style'  => array(),
						'subsets'     => array(),
					);
					if ( isset( $pinnacle[ $options_key ]['font-weight'] ) && ! empty( $pinnacle[ $options_key ]['font-weight'] ) ) {
						if ( isset( $pinnacle[ $options_key ]['font-style'] ) && ! empty( $pinnacle[ $options_key ]['font-style'] ) && ! is_numeric( $pinnacle[ $options_key ]['font-style'] ) && 'normal' !== $pinnacle[ $options_key ]['font-style'] ) {
							$load_gfonts[ sanitize_key( $pinnacle[ $options_key ]['font-family'] ) ]['font-style'][ $pinnacle[ $options_key ]['font-weight'] . $pinnacle[ $options_key ]['font-style'] ] = $pinnacle[ $options_key ]['font-weight'] . $pinnacle[ $options_key ]['font-style'];
						} else {
							$load_gfonts[ sanitize_key( $pinnacle[ $options_key ]['font-family'] ) ]['font-style'][ $pinnacle[ $options_key ]['font-weight'] ] = $pinnacle[ $options_key ]['font-weight'];
						}
					}
					if ( isset( $pinnacle[ $options_key ]['subsets'] ) && ! empty( $pinnacle[ $options_key ]['subsets'] ) ) {
						$load_gfonts[ sanitize_key( $pinnacle[ $options_key ]['font-family'] ) ]['subsets'][ $pinnacle[ $options_key ]['subsets'] ] = $pinnacle[ $options_key ]['subsets'];
					}
				}
				if ( 'font_p' === $options_key ) {
					$path      = trailingslashit( get_template_directory() ) . 'kt-framework/gfont-downloader-json.php';
					$all_fonts = include $path;
					if ( isset( $all_fonts[ $pinnacle[ $options_key ]['font-family'] ] ) ) {
						$p_font = $all_fonts[ $pinnacle[ $options_key ]['font-family'] ];
						if ( isset( $p_font['variants']['italic']['400'] ) ) {
							$load_gfonts[ sanitize_key( $pinnacle[ $options_key ]['font-family'] ) ]['font-style']['400italic'] = '400italic';
						}
						if ( isset( $p_font['variants']['italic']['700'] ) ) {
							$load_gfonts[ sanitize_key( $pinnacle[ $options_key ]['font-family'] ) ]['font-style']['700italic'] = '700italic';
						}
						if ( isset( $p_font['variants']['normal']['400'] ) ) {
							$load_gfonts[ sanitize_key( $pinnacle[ $options_key ]['font-family'] ) ]['font-style']['400'] = '400';
						}
						if ( isset( $p_font['variants']['normal']['700'] ) ) {
							$load_gfonts[ sanitize_key( $pinnacle[ $options_key ]['font-family'] ) ]['font-style']['700'] = '700';
						}
					}
				}
			}
		}
		if ( ! empty( $load_gfonts ) ) {
			// Build the font family link.
			$link    = '';
			$subsets = array();
			foreach ( $load_gfonts as $gfont_values ) {
				if ( ! empty( $link ) ) {
					$link .= '%7C'; // Append a new font to the string.
				}
				$link .= $gfont_values['font-family'];
				if ( ! empty( $gfont_values['font-style'] ) ) {
					$link .= ':';
					$link .= implode( ',', $gfont_values['font-style'] );
				}
				if ( ! empty( $gfont_values['subsets'] ) ) {
					foreach ( $gfont_values['subsets'] as $subset ) {
						if ( ! in_array( $subset, $subsets ) ) {
							array_push( $subsets, $subset );
						}
					}
				}
			}
			if ( ! empty( $subsets ) ) {
				$link .= '&amp;subset=' . implode( ',', $subsets );
			}
			echo '<link href="//fonts.googleapis.com/css?family=' . esc_attr( str_replace( '|', '%7C', $link ) ) . ' " rel="stylesheet">';
		}
		echo '<style type="text/css" id="pinnacle-editor-font-family">';
		if ( isset( $pinnacle['font_h1'] ) ) {
			echo 'body.block-editor-page .editor-post-title__block .editor-post-title__input, body.block-editor-page .wp-block-heading h1, body.block-editor-page .editor-block-list__block h1, body.block-editor-page .editor-post-title__block .editor-post-title__input {
					font-size: ' . esc_attr( $pinnacle['font_h1']['font-size'] ) . ';
					line-height: ' . esc_attr( $pinnacle['font_h1']['line-height'] ) . ';
					font-weight: ' . ( isset( $pinnacle['font_h1']['font-weight'] ) ? esc_attr( $pinnacle['font_h1']['font-weight'] ) : '700' ) . ';
					font-family: ' . esc_attr( $pinnacle['font_h1']['font-family'] ) . ';
					color: ' . esc_attr( $pinnacle['font_h1']['color'] ) . ';
				}';
		}
		if ( isset( $pinnacle['font_h2'] ) ) {
			echo 'body.block-editor-page .wp-block-heading h2, body.block-editor-page .editor-block-list__block h2 {
				font-size: ' . esc_attr( $pinnacle['font_h2']['font-size'] ) . ';
				line-height: ' . esc_attr( $pinnacle['font_h2']['line-height'] ) . ';
				font-weight: ' . ( isset( $pinnacle['font_h2']['font-weight'] ) ? esc_attr( $pinnacle['font_h2']['font-weight'] ) : '400' ) . ';
				font-family: ' . esc_attr( $pinnacle['font_h2']['font-family'] ) . ';
				color: ' . esc_attr( $pinnacle['font_h2']['color'] ) . ';
			}';
		}
		if ( isset( $pinnacle['font_h3'] ) ) {
			echo 'body.block-editor-page .wp-block-heading h3, body.block-editor-page .editor-block-list__block h3 {
				font-size: ' . esc_attr( $pinnacle['font_h3']['font-size'] ) . ';
				line-height: ' . esc_attr( $pinnacle['font_h3']['line-height'] ) . ';
				font-weight: ' . ( isset( $pinnacle['font_h3']['font-weight'] ) ? esc_attr( $pinnacle['font_h3']['font-weight'] ) : '400' ) . ';
				font-family: ' . esc_attr( $pinnacle['font_h3']['font-family'] ) . ';
				color: ' . esc_attr( $pinnacle['font_h3']['color'] ) . ';
			}';
		}
		if ( isset( $pinnacle['font_h4'] ) ) {
			echo 'body.block-editor-page .wp-block-heading h4, body.block-editor-page .editor-block-list__block h4 {
				font-size: ' . esc_attr( $pinnacle['font_h4']['font-size'] ) . ';
				line-height: ' . esc_attr( $pinnacle['font_h4']['line-height'] ) . ';
				font-weight: ' . ( isset( $pinnacle['font_h4']['font-weight'] ) ? esc_attr( $pinnacle['font_h4']['font-weight'] ) : '400' ) . ';
				font-family: ' . esc_attr( $pinnacle['font_h4']['font-family'] ) . ';
				color: ' . esc_attr( $pinnacle['font_h4']['color'] ) . ';
			}body.block-editor-page .editor-block-list__block .widgets-container .so-widget h4 {font-size:inherit; letter-spacing:normal; font-family:inherit;}';
		}
		if ( isset( $pinnacle['font_h5'] ) ) {
			echo 'body.block-editor-page .wp-block-heading h5, body.block-editor-page .editor-block-list__block h5 {
				font-size: ' . esc_attr( $pinnacle['font_h5']['font-size'] ) . ';
				line-height: ' . esc_attr( $pinnacle['font_h5']['line-height'] ) . ';
				font-weight: ' . ( isset( $pinnacle['font_h5']['font-weight'] ) ? esc_attr( $pinnacle['font_h5']['font-weight'] ) : '400' ) . ';
				font-family: ' . esc_attr( $pinnacle['font_h5']['font-family'] ) . ';
				color: ' . esc_attr( $pinnacle['font_h5']['color'] ) . ';
			}';
		}
		if ( isset( $pinnacle['font_p'] ) ) {
			echo '.edit-post-visual-editor, .edit-post-visual-editor p, .edit-post-visual-editor.editor-styles-wrapper p {
				font-size: ' . esc_attr( $pinnacle['font_p']['font-size'] ) . ';
				font-weight: ' . ( isset( $pinnacle['font_p']['font-weight'] ) ? esc_attr( $pinnacle['font_p']['font-weight'] ) : '400' ) . ';
				font-family: ' . esc_attr( $pinnacle['font_p']['font-family'] ) . ';
			}';
			echo '.block-editor-page .edit-post-visual-editor {
				font-family: ' . esc_attr( $pinnacle['font_p']['font-family'] ) . ';
			}';
		}
		echo '</style>';
	}
}
add_action( 'admin_head-post.php', 'pinnacle_editor_dynamic_css' );
add_action( 'admin_head-post-new.php', 'pinnacle_editor_dynamic_css' );


function kadence_gallery_default_type_set_link( $settings ) {
    $settings['galleryDefaults']['link'] = 'file';
    return $settings;
}
add_filter( 'media_view_settings', 'kadence_gallery_default_type_set_link');

add_action('print_media_templates', 'kadence_media_gallery_extras');
function kadence_media_gallery_extras(){
?>
<script type="text/html" id="tmpl-custom-gallery-setting">
    <hr style="clear: both;">
    <h3 style="margin-top:10px;"><?php echo __('KT Extra Gallery Settings', 'pinnacle');?></h3>
    <label class="setting">
      <span><?php _e('Type', 'pinnacle'); ?></span>
      <select data-setting="type">
        <option value="default"><?php _e('Default', 'pinnacle');?></option>
        <option value="slider"><?php _e('Slider', 'pinnacle');?></option>
        <option value="carousel"><?php _e('Carousel', 'pinnacle');?></option>
        <option value="mosaic"><?php _e('Mosaic', 'pinnacle');?></option>
        <option value="grid"><?php _e('Custom Grid', 'pinnacle');?></option>
      </select>
    </label>
    <label class="setting">
      <span><?php _e('Show Captions', 'pinnacle'); ?></span>
      <select data-setting="caption">
      <option value="default"><?php _e('Default', 'pinnacle');?></option>
        <option value="false"><?php _e('False', 'pinnacle');?></option>
        <option value="true"><?php _e('True', 'pinnacle');?></option>
      </select>
    </label>
    <label class="setting">
      <span><?php _e('Masonry', 'pinnacle'); ?></span>
      <select data-setting="masonry">
        <option value="default"><?php _e('Default', 'pinnacle');?></option>
        <option value="false"><?php _e('False', 'pinnacle');?></option>
        <option value="true"><?php _e('True', 'pinnacle');?></option>
      </select>
    </label>
    <h4><?php echo __('Slider Option - Settings', 'pinnacle');?></h4>
    <label class="setting">
        <span style="min-width: 50px;"><?php _e('Width', 'pinnacle'); ?></span>
        <input type="text" value="" data-setting="width" style="float:left;">
    </label>
    <label class="setting">
        <span style="min-width: 50px;"><?php _e('Height', 'pinnacle'); ?></span>
        <input type="text" value="" data-setting="height" style="float:left;">
    </label>
    <hr style="clear: both;">
</script>

<script>

    jQuery(document).ready(function()
    {
        _.extend(wp.media.gallery.defaults, {
        type: 'default',
        caption: 'default',
        masonry: 'default',
        width: '',
        height: '',
        });

        wp.media.view.Settings.Gallery = wp.media.view.Settings.Gallery.extend({
        template: function(view){
          return wp.media.template('gallery-settings')(view)
               + wp.media.template('custom-gallery-setting')(view);
        }
        });

    });

</script>
<?php

}