<?php
$controls = [];

$controls['layout'] = [
	'label'       => esc_html__( 'Layout', 'bricks' ),
	'type'        => 'select',
	'options'     => [
		'grid'    => esc_html__( 'Grid', 'bricks' ),
		'masonry' => 'Masonry',
		'metro'   => 'Metro',
	],
	'placeholder' => esc_html__( 'Grid', 'bricks' ),
	'inline'      => true,
];

$controls['imageRatio'] = [
	'label'       => esc_html__( 'Image ratio', 'bricks' ),
	'description' => esc_html__( 'Precedes image height setting.', 'bricks' ),
	'type'        => 'text',
	'inline'      => true,
	'css'         => [
		[
			'selector' => '.image',
			'property' => 'aspect-ratio',
		],
	],
	'required'    => [ 'layout', '!=', [ 'masonry', 'metro' ] ],
];

$controls['columns'] = [
	'label'       => esc_html__( 'Columns', 'bricks' ),
	'type'        => 'number',
	'min'         => 1,
	'placeholder' => 3,
	'required'    => [ 'layout', '!=', [ 'metro' ] ],
];

$controls['imageHeight'] = [
	'label'       => esc_html__( 'Image height', 'bricks' ),
	'type'        => 'number',
	'units'       => true,
	'css'         => [
		[
			'property'  => 'padding-top',
			'selector'  => '.image',
			'important' => true,
		],
	],
	'placeholder' => '',
	'required'    => [ 'layout', '!=', [ 'masonry', 'metro' ] ],
];

$controls['gutter'] = [
	'label'       => esc_html__( 'Spacing', 'bricks' ),
	'type'        => 'number',
	'units'       => true,
	'css'         => [
		[
			'property' => '--gutter',
			'selector' => '',
		],
	],
	'placeholder' => 0,
];

return [
	'name'        => 'image-gallery',
	'controls'    => $controls,
	'cssSelector' => '.brxe-image-gallery',
];
