<?php
/**
 * Footer Meta Content
 *
 * @package Ascend Theme
 */

global $ascend;
?>
<div class="post-grid-footer-meta kt_color_gray">
	<?php do_action( 'ascend_before_grid_post_footer_meta' ); ?>
	<?php
	if ( isset( $ascend['post_updated_date'] ) && '1' === $ascend['post_updated_date'] ) {
		if ( ! empty( $ascend['post_updated_date_text'] ) ) {
			$updated_date_text = $ascend['post_updated_date_text'];
		} else {
			$updated_date_text = __( 'Updated:', 'ascend' );
		}
		?>
		<span class="postdate kt-post-date updated">
			<?php echo '<span class="kt-updated-post-time">' . esc_html( $updated_date_text ) . ' </span>' . esc_html( get_the_modified_date( get_option( 'date_format' ) ) ); ?>
		</span>
	<?php } else { ?>
		<span class="postdate kt-post-date updated">
			<?php echo get_the_date( get_option( 'date_format' ) ); ?>
		</span>
	<?php } ?>
	<?php
	if ( 0 !== get_comments_number() ) {
		echo '<span class="postcommentscount kt-post-comments"><a href="' . esc_url( get_the_permalink() ) . '#comments" class="kt_color_gray">';
		if ( '2' === ascend_get_option( 'minimal_icons' ) ) {
			ascend_print_svg_icon( 'comments', true );
		} else {
			echo '<i class="kt-icon-comments-o"></i>';
		}
		echo ' ' . esc_html( get_comments_number( '0', '1', '%' ) ) . '</a></span>';
	}
	?>
	<span class="postauthor kt-post-author author">
			<span>
				<span class="kt_color_gray" data-toggle="tooltip" data-placement="top" data-original-title="<?php echo esc_attr( get_the_author() ); ?>">
					<?php
					if ( '2' === ascend_get_option( 'minimal_icons' ) ) {
						ascend_print_svg_icon( 'user', true );
					} else {
						echo '<i class="kt-icon-user2"></i>';
					}
					?>
				</span>
			</span>
	</span>
	<?php do_action( 'ascend_after_grid_post_footer_meta' ); ?>
</div>
