<?php
/**
 * Lifter LMS support
 *
 * @package Ascend Theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Ascend Gallery before.
 */
function ascend_kt_gallery_before() {
	/**
	 * Ascend Post Header.
	 *
	 * @hooked asencd_single_post_header - 20
	 */
	do_action( 'ascend_post_header' );
	?>
	<div id="content" class="container clearfix">
		<div class="row single-article">
			<div class="main <?php echo esc_attr( ascend_main_class() ); ?>" id="ktmain" role="main">
			<?php
}
add_action( 'kadence_gallery_post_before', 'ascend_kt_gallery_before' );

/**
 * Ascend Gallery Album before.
 */
function ascend_kt_gallery_album_before() {
	/**
	 * Ascend Archive Header.
	 *
	 * @hooked ascend_archive_title - 20
	 */
	do_action( 'kadence_archive_title_container' );
	?>
	<div id="content" class="container clearfix">
		<div class="row single-article">
			<div class="main <?php echo esc_attr( ascend_main_class() ); ?>" id="ktmain" role="main">
			<?php
}

add_action( 'kadence_gallery_album_before', 'ascend_kt_gallery_album_before' );
/**
 * Add Sidebar to Single Kadence Gallery.
 */
function ascend_kt_gallery_after() {
	?>
	</div><!-- /.main-->

		<?php
		/**
		 * Sidebar.
		 */
		if ( ascend_display_sidebar() ) :
			get_sidebar();
		endif;
		?>
		</div><!-- /.row-->
	</div><!-- /#content -->
	<?php
}
add_action( 'kadence_gallery_post_after', 'ascend_kt_gallery_after' );
add_action( 'kadence_gallery_album_after', 'ascend_kt_gallery_after' );
