<?php
/**
 * Beaver Themer support
 *
 * @package Ascend Theme
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Declare explicit theme support for beaver themer.
 *
 * @return   void
 */
function ascend_beaverthemer_support() {
	if ( class_exists( 'FLThemeBuilderLayoutData' ) ) {
		add_action( 'after_setup_theme', 'ascend_add_beaverthemer_support' );
		add_filter( 'fl_theme_builder_part_hooks', 'ascend_beaverthemer_register_part_hooks' );
		add_action( 'wp', 'ascend_beaverthemer_header_footer_render' );
	}
}
add_action( 'after_setup_theme', 'ascend_beaverthemer_support', 5 );

/**
 * Adds theme support for the Beaver builder plugin.
 */
function ascend_add_beaverthemer_support() {
	add_theme_support( 'fl-theme-builder-headers' );
	add_theme_support( 'fl-theme-builder-footers' );
	add_theme_support( 'fl-theme-builder-parts' );
}

/**
 * Adds theme support for the Beaver hooks.
 */
function ascend_beaverthemer_register_part_hooks() {
	return array(
		array(
			'label' => 'Header',
			'hooks' => array(
				'ascend_beforeheader' => 'Before Header',
				'ascend_header_after' => 'After Header',
			),
		),
		array(
			'label' => 'Content',
			'hooks' => array(
				'kadence_page_content' => 'Before Page Content',
				'kadence_page_footer'  => 'After Page Content',
			),
		),
		array(
			'label' => 'Footer',
			'hooks' => array(
				'ascend_before_footer' => 'Before Footer',
			),
		),
	);
}

/**
 * Adds theme support for the Beaver builder plugin.
 */
function ascend_beaverthemer_header_footer_render() {
	// Get the header ID.
	$header_ids = FLThemeBuilderLayoutData::get_current_page_header_ids();

	// If we have a header, remove the theme header and hook in Theme Builder's.
	if ( ! empty( $header_ids ) ) {
		remove_action( 'ascend_header', 'ascend_header_markup' );
		add_action( 'ascend_header', 'FLThemeBuilderLayoutRenderer::render_header' );
	}

	// Get the footer ID.
	$footer_ids = FLThemeBuilderLayoutData::get_current_page_footer_ids();

	// If we have a footer, remove the theme footer and hook in Theme Builder's.
	if ( ! empty( $footer_ids ) ) {
		remove_action( 'ascend_footer', 'ascend_footer_markup' );
		add_action( 'ascend_footer', 'FLThemeBuilderLayoutRenderer::render_footer' );
	}
}

