<?php
/**
 * Sidebar and page settings
 *
 * @package Ascend Theme
 */

/**
 * All posts BUT pages sidebar options.
 */
function ascend_sidebar_metaboxes() {
	$prefix     = '_kad_';
	$kt_sidebar = new_cmb2_box( array(
		'id'           => 'sidebar_post_metabox',
		'title'        => __( 'Sidebar Options', 'ascend' ),
		'object_types' => ascend_all_custom_posts( 'page' ),
		'priority'     => 'low',
		'context'      => 'side',
	) );
	$kt_sidebar->add_field( array(
		'name'    => __( 'Display Sidebar?', 'ascend' ),
		'id'      => $prefix . 'post_sidebar',
		'type'    => 'select',
		'options' => array(
			'default' => __( 'Default', 'ascend' ),
			'yes'     => __( 'Yes', 'ascend' ),
			'no'      => __( 'No', 'ascend' ),
		),
	) );
	$kt_sidebar->add_field( array(
		'name'    => __( 'Choose Sidebar', 'ascend' ),
		'desc'    => '',
		'id'      => $prefix . 'sidebar_choice',
		'type'    => 'select',
		'options' => ascend_cmb_sidebar_options(),
	) );
}
add_filter( 'cmb2_admin_init', 'ascend_sidebar_metaboxes' );

/**
 * All posts BUT pages sidebar options.
 */
function ascend_page_layout_metaboxes() {
	$prefix         = '_kad_';
	$kt_page_layout = new_cmb2_box( array(
		'id'           => 'page_layout_metabox',
		'title'        => __( 'Page Layout Options', 'ascend' ),
		'object_types' => array( 'page' ),
		'priority'     => 'low',
		'context'      => 'side',
	) );
	$kt_page_layout->add_field( array(
		'name'    => __( 'Display Sidebar?', 'ascend' ),
		'id'      => $prefix . 'post_sidebar',
		'type'    => 'select',
		'options' => array(
			'default' => __( 'Default', 'ascend' ),
			'yes'     => __( 'Yes', 'ascend' ),
			'no'      => __( 'No', 'ascend' ),
		),
	) );
	$kt_page_layout->add_field( array(
		'name'    => __( 'Choose Sidebar', 'ascend' ),
		'desc'    => '',
		'id'      => $prefix . 'sidebar_choice',
		'type'    => 'select',
		'options' => ascend_cmb_sidebar_options(),
	) );
	$kt_page_layout->add_field( array(
		'name'    => __( 'Page Content Width', 'ascend' ),
		'desc'    => '',
		'id'      => $prefix . 'page_content_width',
		'type'    => 'select',
		'options' => array(
			'default'   => __( 'Default', 'ascend' ),
			'contained' => __( 'Contained', 'ascend' ),
			'full'      => __( 'Fullwidth', 'ascend' ),
		),
	) );
}
add_filter( 'cmb2_admin_init', 'ascend_page_layout_metaboxes' );
